/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler;

import com.alipay.sofa.registry.metrics.TaskMetrics;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.scheduler.SessionThreadPoolExecutor;
import com.alipay.sofa.registry.task.scheduler.TimedSupervisorTask;
import com.alipay.sofa.registry.util.NamedThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutorManager {
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor fetchDataExecutor;
    private final ThreadPoolExecutor standaloneCheckVersionExecutor;
    private final ThreadPoolExecutor renNewDataExecutor;
    private final ThreadPoolExecutor getSessionNodeExecutor;
    private final ThreadPoolExecutor connectMetaExecutor;
    private final ThreadPoolExecutor connectDataExecutor;
    private final ExecutorService checkPushExecutor;
    private final ExecutorService pushTaskClosureExecutor;
    private final ThreadPoolExecutor accessDataExecutor;
    private final ThreadPoolExecutor dataChangeRequestExecutor;
    private final ThreadPoolExecutor pushTaskExecutor;
    private final ThreadPoolExecutor disconnectClientExecutor;
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Registry sessionRegistry;
    @Autowired
    private NodeManager sessionNodeManager;
    @Autowired
    private NodeManager dataNodeManager;
    @Autowired
    private NodeManager metaNodeManager;
    @Autowired
    protected NodeExchanger metaNodeExchanger;
    @Autowired
    private NodeExchanger dataNodeExchanger;
    private Map<String, ThreadPoolExecutor> reportExecutors = new HashMap<String, ThreadPoolExecutor>();
    private static final String PUSH_TASK_EXECUTOR = "PushTaskExecutor";
    private static final String ACCESS_DATA_EXECUTOR = "AccessDataExecutor";
    private static final String DATA_CHANGE_REQUEST_EXECUTOR = "DataChangeRequestExecutor";
    private static final String USER_DATA_ELEMENT_PUSH_TASK_CHECK_EXECUTOR = "UserDataElementPushCheckExecutor";
    private static final String PUSH_TASK_CLOSURE_CHECK_EXECUTOR = "PushTaskClosureCheckExecutor";
    private static final String DISCONNECT_CLIENT_EXECUTOR = "DisconnectClientExecutor";

    public ExecutorManager(SessionServerConfig sessionServerConfig) {
        this.sessionServerConfig = sessionServerConfig;
        this.scheduler = new ScheduledThreadPoolExecutor(7, (ThreadFactory)new NamedThreadFactory("SessionScheduler"));
        this.fetchDataExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-fetchData"));
        this.renNewDataExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-reNewData"));
        this.getSessionNodeExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-getSessionNode"));
        this.standaloneCheckVersionExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-standaloneCheckVersion"));
        this.connectMetaExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-connectMetaServer"));
        this.connectDataExecutor = new ThreadPoolExecutor(1, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SessionScheduler-connectDataServer"));
        this.accessDataExecutor = this.reportExecutors.computeIfAbsent(ACCESS_DATA_EXECUTOR, k -> new SessionThreadPoolExecutor(ACCESS_DATA_EXECUTOR, sessionServerConfig.getAccessDataExecutorMinPoolSize(), sessionServerConfig.getAccessDataExecutorMaxPoolSize(), sessionServerConfig.getAccessDataExecutorKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(sessionServerConfig.getAccessDataExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("AccessData-executor", true)));
        this.pushTaskExecutor = this.reportExecutors.computeIfAbsent(PUSH_TASK_EXECUTOR, k -> new ThreadPoolExecutor(sessionServerConfig.getPushTaskExecutorMinPoolSize(), sessionServerConfig.getPushTaskExecutorMaxPoolSize(), sessionServerConfig.getPushTaskExecutorKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(sessionServerConfig.getPushTaskExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("PushTask-executor", true)));
        TaskMetrics.getInstance().registerThreadExecutor(PUSH_TASK_EXECUTOR, this.pushTaskExecutor);
        this.dataChangeRequestExecutor = this.reportExecutors.computeIfAbsent(DATA_CHANGE_REQUEST_EXECUTOR, k -> new SessionThreadPoolExecutor(DATA_CHANGE_REQUEST_EXECUTOR, sessionServerConfig.getDataChangeExecutorMinPoolSize(), sessionServerConfig.getDataChangeExecutorMaxPoolSize(), sessionServerConfig.getDataChangeExecutorKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(sessionServerConfig.getDataChangeExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("DataChangeRequestHandler-executor", true)));
        this.checkPushExecutor = this.reportExecutors.computeIfAbsent(USER_DATA_ELEMENT_PUSH_TASK_CHECK_EXECUTOR, k -> new SessionThreadPoolExecutor(USER_DATA_ELEMENT_PUSH_TASK_CHECK_EXECUTOR, 100, 600, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100000), (ThreadFactory)new NamedThreadFactory("UserDataElementPushCheck-executor", true)));
        this.pushTaskClosureExecutor = this.reportExecutors.computeIfAbsent(PUSH_TASK_CLOSURE_CHECK_EXECUTOR, k -> new SessionThreadPoolExecutor(PUSH_TASK_CLOSURE_CHECK_EXECUTOR, 80, 400, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), (ThreadFactory)new NamedThreadFactory("PushTaskClosureCheck", true)));
        this.disconnectClientExecutor = this.reportExecutors.computeIfAbsent(DISCONNECT_CLIENT_EXECUTOR, k -> new SessionThreadPoolExecutor(DISCONNECT_CLIENT_EXECUTOR, sessionServerConfig.getDisconnectClientExecutorMinPoolSize(), sessionServerConfig.getDisconnectClientExecutorMaxPoolSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(sessionServerConfig.getDisconnectClientExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory(DISCONNECT_CLIENT_EXECUTOR, true)));
    }

    public void startScheduler() {
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("FetchData", this.scheduler, this.fetchDataExecutor, this.sessionServerConfig.getSchedulerFetchDataTimeout(), TimeUnit.MINUTES, this.sessionServerConfig.getSchedulerFetchDataExpBackOffBound(), () -> this.sessionRegistry.fetchChangData()), (long)this.sessionServerConfig.getSchedulerFetchDataFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("ReNewData", this.scheduler, this.renNewDataExecutor, this.sessionServerConfig.getSchedulerHeartbeatTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerHeartbeatExpBackOffBound(), () -> this.sessionNodeManager.reNewNode()), (long)this.sessionServerConfig.getSchedulerHeartbeatFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("GetSessionNode", this.scheduler, this.getSessionNodeExecutor, this.sessionServerConfig.getSchedulerGetSessionNodeTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerGetSessionNodeExpBackOffBound(), () -> {
            this.sessionNodeManager.getAllDataCenterNodes();
            this.dataNodeManager.getAllDataCenterNodes();
            this.metaNodeManager.getAllDataCenterNodes();
        }), (long)this.sessionServerConfig.getSchedulerGetSessionNodeFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("ConnectMetaServer", this.scheduler, this.connectMetaExecutor, this.sessionServerConfig.getSchedulerConnectMetaTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerConnectMetaExpBackOffBound(), () -> this.metaNodeExchanger.connectServer()), (long)this.sessionServerConfig.getSchedulerConnectMetaFirstDelay(), TimeUnit.SECONDS);
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("ConnectDataServer", this.scheduler, this.connectDataExecutor, this.sessionServerConfig.getSchedulerConnectDataTimeout(), TimeUnit.SECONDS, this.sessionServerConfig.getSchedulerConnectDataExpBackOffBound(), () -> this.dataNodeExchanger.connectServer()), (long)this.sessionServerConfig.getSchedulerConnectDataFirstDelay(), TimeUnit.SECONDS);
    }

    public void stopScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        if (this.standaloneCheckVersionExecutor != null && !this.standaloneCheckVersionExecutor.isShutdown()) {
            this.standaloneCheckVersionExecutor.shutdown();
        }
        if (this.renNewDataExecutor != null && !this.renNewDataExecutor.isShutdown()) {
            this.renNewDataExecutor.shutdown();
        }
        if (this.fetchDataExecutor != null && !this.fetchDataExecutor.isShutdown()) {
            this.fetchDataExecutor.shutdown();
        }
        if (this.getSessionNodeExecutor != null && !this.getSessionNodeExecutor.isShutdown()) {
            this.getSessionNodeExecutor.shutdown();
        }
        if (this.connectMetaExecutor != null && !this.connectMetaExecutor.isShutdown()) {
            this.connectMetaExecutor.shutdown();
        }
        if (this.connectDataExecutor != null && !this.connectDataExecutor.isShutdown()) {
            this.connectDataExecutor.shutdown();
        }
        if (this.accessDataExecutor != null && !this.accessDataExecutor.isShutdown()) {
            this.accessDataExecutor.shutdown();
        }
        if (this.pushTaskExecutor != null && !this.pushTaskExecutor.isShutdown()) {
            this.pushTaskExecutor.shutdown();
        }
        if (this.checkPushExecutor != null && !this.checkPushExecutor.isShutdown()) {
            this.checkPushExecutor.shutdown();
        }
        if (this.dataChangeRequestExecutor != null && !this.dataChangeRequestExecutor.isShutdown()) {
            this.dataChangeRequestExecutor.shutdown();
        }
        if (this.pushTaskClosureExecutor != null && !this.pushTaskClosureExecutor.isShutdown()) {
            this.pushTaskClosureExecutor.shutdown();
        }
        if (this.disconnectClientExecutor != null && !this.disconnectClientExecutor.isShutdown()) {
            this.disconnectClientExecutor.shutdown();
        }
    }

    public Map<String, ThreadPoolExecutor> getReportExecutors() {
        return this.reportExecutors;
    }

    public ThreadPoolExecutor getAccessDataExecutor() {
        return this.accessDataExecutor;
    }

    public ThreadPoolExecutor getPushTaskExecutor() {
        return this.pushTaskExecutor;
    }

    public ExecutorService getCheckPushExecutor() {
        return this.checkPushExecutor;
    }

    public ThreadPoolExecutor getDataChangeRequestExecutor() {
        return this.dataChangeRequestExecutor;
    }

    public ExecutorService getPushTaskClosureExecutor() {
        return this.pushTaskClosureExecutor;
    }

    public ThreadPoolExecutor getDisconnectClientExecutor() {
        return this.disconnectClientExecutor;
    }
}

