/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting.handler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.RemotingException;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.store.DataStore;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.Watchers;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientNodeConnectionHandler
extends AbstractServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SESSION-CONNECT");
    @Autowired
    private Registry sessionRegistry;
    @Autowired
    private DataStore sessionDataStore;
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private Watchers sessionWatchers;
    @Autowired
    private ExecutorManager executorManager;

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.LISENTER;
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        this.fireCancelClient(channel);
    }

    public void fireCancelClient(Channel channel) {
        this.executorManager.getDisconnectClientExecutor().execute(() -> {
            String connectId = NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress());
            if (this.checkCache(connectId)) {
                ArrayList<String> connectIds = new ArrayList<String>();
                connectIds.add(connectId);
                this.sessionRegistry.cancel(connectIds);
            }
        });
    }

    private boolean checkCache(String connectId) {
        boolean checkSub = this.checkSub(connectId);
        boolean checkPub = this.checkPub(connectId);
        boolean checkWatcher = this.checkWatcher(connectId);
        LOGGER.info("Client off checkCache connectId:{} result pub:{},sub:{},wat:{}", new Object[]{connectId, checkPub, checkSub, checkWatcher});
        return checkPub || checkSub || checkWatcher;
    }

    private boolean checkPub(String connectId) {
        Map pubMap = this.sessionDataStore.queryByConnectId(connectId);
        return pubMap != null && !pubMap.isEmpty();
    }

    private boolean checkSub(String connectId) {
        Map subMap = this.sessionInterests.queryByConnectId(connectId);
        return subMap != null && !subMap.isEmpty();
    }

    private boolean checkWatcher(String connectId) {
        Map subMap = this.sessionWatchers.queryByConnectId(connectId);
        return subMap != null && !subMap.isEmpty();
    }
}

