/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.ReNewNodesRequest;
import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.server.session.node.AbstractNodeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SessionNodeManager
extends AbstractNodeManager<SessionNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionNodeManager.class);

    @Override
    public SessionNode getNode(String dataInfoId) {
        return null;
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.SESSION;
    }

    public List<String> getZoneServerList(String zonename) {
        ArrayList<String> serverList = new ArrayList<String>();
        Collection sessionNodes = this.getDataCenterNodes();
        if (sessionNodes != null && !sessionNodes.isEmpty()) {
            if (zonename == null || zonename.isEmpty()) {
                zonename = this.sessionServerConfig.getSessionServerRegion();
            }
            for (SessionNode sessionNode : sessionNodes) {
                URL url;
                if (!zonename.equals(sessionNode.getRegionId()) || (url = sessionNode.getNodeUrl()) == null) continue;
                serverList.add(url.getIpAddress());
            }
        }
        return serverList;
    }

    @Override
    public void reNewNode() {
        try {
            Request<ReNewNodesRequest> reNewNodesRequestRequest = new Request<ReNewNodesRequest>(){

                public ReNewNodesRequest getRequestBody() {
                    URL clientUrl = new URL(NetUtil.getLocalAddress().getHostAddress(), 0);
                    SessionNode sessionNode = new SessionNode(clientUrl, SessionNodeManager.this.sessionServerConfig.getSessionServerRegion());
                    return new ReNewNodesRequest((Node)sessionNode);
                }

                public URL getRequestUrl() {
                    return new URL(SessionNodeManager.this.raftClientManager.getLeader().getIp(), SessionNodeManager.this.sessionServerConfig.getMetaServerPort());
                }
            };
            this.metaNodeExchanger.request((Request)reNewNodesRequestRequest);
        }
        catch (RequestException e) {
            LOGGER.error("SessionNodeManager reNew node error! " + e.getRequestMessage(), (Throwable)e);
            throw new RuntimeException("SessionNodeManager reNew node error! " + e.getRequestMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodes(NodeChangeResult nodeChangeResult) {
        this.write.lock();
        try {
            Long receiveVersion = nodeChangeResult.getVersion();
            boolean versionChange = this.checkAndUpdateListVersions(this.sessionServerConfig.getSessionServerDataCenter(), receiveVersion);
            if (!versionChange && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current data type {} list version has not updated!", (Object)this.getNodeType());
            }
            this.nodes = nodeChangeResult.getNodes();
        }
        finally {
            this.write.unlock();
        }
    }
}

