/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.consistency.hash.ConsistentHash;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.AbstractNodeManager;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeManager
extends AbstractNodeManager<DataNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeManager.class, (String)"[DataNodeManager]");
    @Autowired
    private SessionServerConfig sessionServerConfig;
    private ConsistentHash<DataNode> consistentHash;

    @Override
    public DataNode getNode(String dataInfoId) {
        DataNode dataNode = (DataNode)this.consistentHash.getNodeFor((Object)dataInfoId);
        if (dataNode == null) {
            LOGGER.error("calculate data node error!,dataInfoId={}", (Object)dataInfoId);
            throw new RuntimeException("DataNodeManager calculate data node error!,dataInfoId=" + dataInfoId);
        }
        return dataNode;
    }

    @Override
    public void updateNodes(NodeChangeResult nodeChangeResult) {
        this.write.lock();
        try {
            super.updateNodes(nodeChangeResult);
            this.consistentHash = new ConsistentHash(this.sessionServerConfig.getNumberOfReplicas(), this.getDataCenterNodes());
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.DATA;
    }

    @Override
    public void reNewNode() {
    }
}

