/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.listener;

import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.task.DataChangeFetchCloudTask;
import com.alipay.sofa.registry.server.session.scheduler.task.SessionTask;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.task.batcher.TaskDispatcher;
import com.alipay.sofa.registry.task.batcher.TaskDispatchers;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListener;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import org.springframework.beans.factory.annotation.Autowired;

public class DataChangeFetchCloudTaskListener
implements TaskListener {
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private TaskListenerManager taskListenerManager;
    @Autowired
    private ExecutorManager executorManager;
    @Autowired
    private CacheService sessionCacheService;
    private TaskDispatcher<String, SessionTask> singleTaskDispatcher;
    private TaskProcessor dataNodeSingleTaskProcessor;

    public DataChangeFetchCloudTaskListener(TaskProcessor dataNodeSingleTaskProcessor) {
        this.dataNodeSingleTaskProcessor = dataNodeSingleTaskProcessor;
    }

    public TaskDispatcher<String, SessionTask> getSingleTaskDispatcher() {
        if (this.singleTaskDispatcher == null) {
            this.singleTaskDispatcher = TaskDispatchers.createSingleTaskDispatcher((String)TaskDispatchers.getDispatcherName((String)TaskEvent.TaskType.DATA_CHANGE_FETCH_CLOUD_TASK.getName()), (int)this.sessionServerConfig.getDataChangeFetchTaskMaxBufferSize(), (int)this.sessionServerConfig.getDataChangeFetchTaskWorkerSize(), (long)1000L, (long)100L, (TaskProcessor)this.dataNodeSingleTaskProcessor);
        }
        return this.singleTaskDispatcher;
    }

    public boolean support(TaskEvent event) {
        return TaskEvent.TaskType.DATA_CHANGE_FETCH_CLOUD_TASK.equals((Object)event.getTaskType());
    }

    public void handleEvent(TaskEvent event) {
        DataChangeFetchCloudTask dataChangeFetchTask = new DataChangeFetchCloudTask(this.sessionServerConfig, this.taskListenerManager, this.sessionInterests, this.executorManager, this.sessionCacheService);
        dataChangeFetchTask.setTaskEvent(event);
        this.getSingleTaskDispatcher().dispatch((Object)dataChangeFetchTask.getTaskId(), (Object)dataChangeFetchTask, dataChangeFetchTask.getExpiryTime());
    }
}

