/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.converter;

import com.alipay.sofa.registry.common.model.ServerDataBox;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.core.model.DataBox;
import com.alipay.sofa.registry.core.model.ReceivedConfigData;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class ReceivedDataConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceivedDataConverter.class);

    public static ReceivedData getReceivedDataMulti(String dataId, String group, String instanceId, String dataCenter, ScopeEnum scope, List subscriberRegisterIdList, String regionLocal) {
        ReceivedData receivedData = new ReceivedData();
        receivedData.setDataId(dataId);
        receivedData.setGroup(group);
        receivedData.setInstanceId(instanceId);
        receivedData.setSubscriberRegistIds(subscriberRegisterIdList);
        receivedData.setSegment(dataCenter);
        receivedData.setScope(scope.name());
        receivedData.setVersion(Long.valueOf(1L));
        receivedData.setLocalZone(regionLocal);
        HashMap swizzMap = new HashMap();
        receivedData.setData(swizzMap);
        return receivedData;
    }

    public static ReceivedData getReceivedDataMulti(Datum datum, ScopeEnum scope, List subscriberRegisterIdList, String regionLocal, Predicate<String> zonePredicate) {
        if (null == datum) {
            return null;
        }
        ReceivedData receivedData = new ReceivedData();
        receivedData.setDataId(datum.getDataId());
        receivedData.setGroup(datum.getGroup());
        receivedData.setInstanceId(datum.getInstanceId());
        receivedData.setSubscriberRegistIds(subscriberRegisterIdList);
        receivedData.setSegment(datum.getDataCenter());
        receivedData.setScope(scope.name());
        receivedData.setVersion(Long.valueOf(datum.getVersion()));
        receivedData.setLocalZone(regionLocal);
        HashMap<String, List> swizzMap = new HashMap<String, List>();
        Map publisherMap = datum.getPubMap();
        if (publisherMap == null || publisherMap.isEmpty()) {
            receivedData.setData(swizzMap);
            return receivedData;
        }
        for (Map.Entry entry : publisherMap.entrySet()) {
            Publisher publisher = (Publisher)entry.getValue();
            ArrayList<ServerDataBox> datas = publisher.getDataList();
            String region = publisher.getCell();
            if (zonePredicate.test(region)) continue;
            if (null == datas) {
                datas = new ArrayList<ServerDataBox>();
            }
            List regionDatas = swizzMap.computeIfAbsent(region, k -> new ArrayList());
            ReceivedDataConverter.fillRegionDatas(regionDatas, datas);
        }
        receivedData.setData(swizzMap);
        return receivedData;
    }

    private static void fillRegionDatas(List<DataBox> regionDatas, List<ServerDataBox> datas) {
        for (ServerDataBox data : datas) {
            DataBox box = new DataBox();
            try {
                String dataString = (String)data.extract();
                box.setData(dataString);
                regionDatas.add(box);
            }
            catch (Exception e) {
                LOGGER.error("ReceivedData convert error", (Throwable)e);
            }
        }
    }

    public static ReceivedData getReceivedDataMulti(Map<String, Datum> datums, ScopeEnum scope, List subscriberRegisterIdList, Subscriber subscriber) {
        ReceivedData receivedData = new ReceivedData();
        receivedData.setDataId(subscriber.getDataId());
        receivedData.setGroup(subscriber.getGroup());
        receivedData.setInstanceId(subscriber.getInstanceId());
        receivedData.setSubscriberRegistIds(subscriberRegisterIdList);
        receivedData.setSegment("DefaultDataCenter");
        receivedData.setScope(scope.name());
        String regionLocal = subscriber.getCell();
        receivedData.setLocalZone(regionLocal);
        receivedData.setVersion(Long.valueOf(System.currentTimeMillis()));
        HashMap<String, List> swizzMap = new HashMap<String, List>();
        for (Map.Entry<String, Datum> entry : datums.entrySet()) {
            Datum datum = entry.getValue();
            Map publisherMap = datum.getPubMap();
            if (publisherMap == null || publisherMap.isEmpty()) continue;
            for (Map.Entry publishers : publisherMap.entrySet()) {
                Publisher publisher = (Publisher)publishers.getValue();
                ArrayList<ServerDataBox> datas = publisher.getDataList();
                String region = publisher.getCell();
                if (ScopeEnum.zone == scope && !regionLocal.equals(region)) continue;
                if (null == datas) {
                    datas = new ArrayList<ServerDataBox>();
                }
                List regionDatas = swizzMap.computeIfAbsent(region, k -> new ArrayList());
                ReceivedDataConverter.fillRegionDatas(regionDatas, datas);
            }
        }
        receivedData.setData(swizzMap);
        return receivedData;
    }

    public static Datum getMergeDatum(Map<String, Datum> datumMap) {
        Datum merge = null;
        HashMap mergePublisherMap = new HashMap();
        long version = 0L;
        for (Datum datum : datumMap.values()) {
            if (datum.getDataId() == null) {
                LOGGER.error("ReceivedData convert error,datum dataId is null,datum={}", (Object)datum);
                continue;
            }
            if (null == merge) {
                merge = new Datum(datum.getDataInfoId(), datum.getDataCenter());
                merge.setDataId(datum.getDataId());
                merge.setGroup(datum.getGroup());
                merge.setInstanceId(datum.getInstanceId());
            }
            mergePublisherMap.putAll(datum.getPubMap());
            version = Math.max(version, datum.getVersion());
        }
        if (null == merge) {
            return null;
        }
        merge.setVersion(version);
        merge.setPubMap(mergePublisherMap);
        merge.setDataCenter("DefaultDataCenter");
        return merge;
    }

    public static ReceivedConfigData getReceivedConfigData(ServerDataBox dataBox, DataInfo dataInfo, Long version) {
        ReceivedConfigData receivedConfigData = new ReceivedConfigData();
        if (dataBox != null) {
            DataBox box = new DataBox();
            String dataString = (String)dataBox.getObject();
            box.setData(dataString);
            receivedConfigData.setDataBox(box);
        }
        receivedConfigData.setDataId(dataInfo.getDataId());
        receivedConfigData.setGroup(dataInfo.getDataType());
        receivedConfigData.setInstanceId(dataInfo.getInstanceId());
        receivedConfigData.setVersion(version);
        return receivedConfigData;
    }
}

