/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.cache;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.cache.CacheGenerator;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.cache.EntityType;
import com.alipay.sofa.registry.server.session.cache.Key;
import com.alipay.sofa.registry.server.session.cache.Value;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionCacheService
implements CacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionCacheService.class);
    private final LoadingCache<Key, Value> readWriteCacheMap = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(31000L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Key, Value>(){

        public Value load(Key key) {
            return SessionCacheService.this.generatePayload(key);
        }
    });
    private Map<String, CacheGenerator> cacheGenerators;

    private Value generatePayload(Key key) {
        if (key == null || key.getEntityType() == null) {
            throw new IllegalArgumentException("Generator key input error!");
        }
        Value value = null;
        switch (key.getKeyType()) {
            case OBJ: {
                EntityType entityType = key.getEntityType();
                CacheGenerator cacheGenerator = this.cacheGenerators.get(entityType.getClass().getName());
                value = cacheGenerator.generatePayload(key);
                break;
            }
            case JSON: {
                break;
            }
            case XML: {
                break;
            }
            default: {
                LOGGER.error("Unidentified data type: " + (Object)((Object)key.getKeyType()) + " found in the cache key.");
                value = new Value(new HashMap());
            }
        }
        return value;
    }

    @Override
    public Value getValue(Key key) {
        Value payload = null;
        try {
            payload = (Value)this.readWriteCacheMap.get((Object)key);
        }
        catch (Throwable t) {
            LOGGER.error("Cannot get value for key :" + key, t);
        }
        return payload;
    }

    @Override
    public Map<Key, Value> getValues(Iterable<Key> keys) {
        ImmutableMap valueMap = null;
        try {
            valueMap = this.readWriteCacheMap.getAll(keys);
        }
        catch (ExecutionException e) {
            LOGGER.error("Cannot get value for keys :" + keys, (Throwable)e);
        }
        return valueMap;
    }

    @Override
    public void invalidate(Key ... keys) {
        for (Key key : keys) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invalidating the response cache key : {} {} {}", new Object[]{key.getEntityType(), key.getEntityName(), key.getKeyType()});
            }
            this.readWriteCacheMap.invalidate((Object)key);
        }
    }

    @Autowired
    public void setCacheGenerators(Map<String, CacheGenerator> cacheGenerators) {
        this.cacheGenerators = cacheGenerators;
    }
}

