/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.style.column;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;

public class LongestMatchColumnWidthStyleStrategy
extends AbstractColumnWidthStyleStrategy {
    private static final int MAX_COLUMN_WIDTH = 256;
    private static final Map<Integer, Map<Integer, Integer>> CACHE = new HashMap<Integer, Map<Integer, Integer>>(8);

    @Override
    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, CellData cellData, Cell cell, Head head, int relativeRowIndex, boolean isHead) {
        Integer maxColumnWidth;
        Integer columnWidth;
        if (!isHead && cellData == null) {
            return;
        }
        Map<Integer, Integer> maxColumnWidthMap = CACHE.get(writeSheetHolder.getSheetNo());
        if (maxColumnWidthMap == null) {
            maxColumnWidthMap = new HashMap<Integer, Integer>(16);
            CACHE.put(writeSheetHolder.getSheetNo(), maxColumnWidthMap);
        }
        if ((columnWidth = this.dataLength(cellData, cell, isHead)) < 0) {
            return;
        }
        if (columnWidth > 256) {
            columnWidth = 256;
        }
        if ((maxColumnWidth = maxColumnWidthMap.get(head.getColumnIndex())) == null || columnWidth > maxColumnWidth) {
            maxColumnWidthMap.put(head.getColumnIndex(), columnWidth);
            writeSheetHolder.getSheet().setColumnWidth(head.getColumnIndex().intValue(), columnWidth * 256);
        }
    }

    private Integer dataLength(CellData cellData, Cell cell, boolean isHead) {
        if (isHead) {
            return cell.getStringCellValue().getBytes().length;
        }
        switch (cellData.getType()) {
            case STRING: {
                return cellData.getStringValue().getBytes().length;
            }
            case BOOLEAN: {
                return cellData.getBooleanValue().toString().getBytes().length;
            }
            case NUMBER: {
                return cellData.getNumberValue().toString().getBytes().length;
            }
        }
        return -1;
    }
}

