/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.metadata.holder;

import com.alibaba.excel.enums.HolderEnum;
import com.alibaba.excel.enums.WriteLastRowType;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.holder.AbstractWriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class WriteSheetHolder
extends AbstractWriteHolder {
    private WriteSheet writeSheet;
    private Sheet sheet;
    private Integer sheetNo;
    private String sheetName;
    private WriteWorkbookHolder parentWriteWorkbookHolder;
    private Map<Integer, WriteTableHolder> hasBeenInitializedTable;
    private WriteLastRowType writeLastRowType;

    public WriteSheetHolder(WriteSheet writeSheet, WriteWorkbookHolder writeWorkbookHolder) {
        super(writeSheet, writeWorkbookHolder, writeWorkbookHolder.getWriteWorkbook().getConvertAllFiled());
        this.writeSheet = writeSheet;
        this.sheetNo = writeSheet.getSheetNo();
        this.sheetName = writeSheet.getSheetName() == null ? writeSheet.getSheetNo().toString() : writeSheet.getSheetName();
        this.parentWriteWorkbookHolder = writeWorkbookHolder;
        this.hasBeenInitializedTable = new HashMap<Integer, WriteTableHolder>();
        this.writeLastRowType = writeWorkbookHolder.getTemplateInputStream() == null && writeWorkbookHolder.getTemplateFile() == null ? WriteLastRowType.COMMON_EMPTY : WriteLastRowType.TEMPLATE_EMPTY;
    }

    public WriteSheet getWriteSheet() {
        return this.writeSheet;
    }

    public void setWriteSheet(WriteSheet writeSheet) {
        this.writeSheet = writeSheet;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Integer getSheetNo() {
        return this.sheetNo;
    }

    public void setSheetNo(Integer sheetNo) {
        this.sheetNo = sheetNo;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public WriteWorkbookHolder getParentWriteWorkbookHolder() {
        return this.parentWriteWorkbookHolder;
    }

    public void setParentWriteWorkbookHolder(WriteWorkbookHolder parentWriteWorkbookHolder) {
        this.parentWriteWorkbookHolder = parentWriteWorkbookHolder;
    }

    public Map<Integer, WriteTableHolder> getHasBeenInitializedTable() {
        return this.hasBeenInitializedTable;
    }

    public void setHasBeenInitializedTable(Map<Integer, WriteTableHolder> hasBeenInitializedTable) {
        this.hasBeenInitializedTable = hasBeenInitializedTable;
    }

    public WriteLastRowType getWriteLastRowType() {
        return this.writeLastRowType;
    }

    public void setWriteLastRowType(WriteLastRowType writeLastRowType) {
        this.writeLastRowType = writeLastRowType;
    }

    public int getNewRowIndexAndStartDoWrite() {
        int newRowIndex = 0;
        switch (this.writeLastRowType) {
            case TEMPLATE_EMPTY: {
                if (this.parentWriteWorkbookHolder.getExcelType() == ExcelTypeEnum.XLSX) {
                    if (this.parentWriteWorkbookHolder.getTemplateLastRowMap().containsKey(this.sheetNo)) {
                        newRowIndex = this.parentWriteWorkbookHolder.getTemplateLastRowMap().get(this.sheetNo);
                    }
                } else {
                    newRowIndex = this.sheet.getLastRowNum();
                }
                ++newRowIndex;
                break;
            }
            case HAS_DATA: {
                newRowIndex = this.sheet.getLastRowNum();
                ++newRowIndex;
                break;
            }
        }
        this.writeLastRowType = WriteLastRowType.HAS_DATA;
        return newRowIndex;
    }

    @Override
    public HolderEnum holderType() {
        return HolderEnum.SHEET;
    }
}

