/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.property;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.converters.AutoConverter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.DateTimeFormatProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.NumberFormatProperty;
import com.alibaba.excel.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelHeadProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelHeadProperty.class);
    private Class headClazz;
    private HeadKindEnum headKind;
    private int headRowNumber;
    private Map<Integer, Head> headMap;
    private Map<Integer, ExcelContentProperty> contentPropertyMap;
    private Map<String, Field> ignoreMap;

    public ExcelHeadProperty(Class headClazz, List<List<String>> head, Boolean convertAllFiled) {
        this.headClazz = headClazz;
        this.headMap = new TreeMap<Integer, Head>();
        this.contentPropertyMap = new TreeMap<Integer, ExcelContentProperty>();
        this.ignoreMap = new HashMap<String, Field>(16);
        this.headKind = HeadKindEnum.NONE;
        this.headRowNumber = 0;
        if (head != null && !head.isEmpty()) {
            for (int i = 0; i < head.size(); ++i) {
                this.headMap.put(i, new Head(i, null, head.get(i), Boolean.FALSE, Boolean.TRUE));
                this.contentPropertyMap.put(i, null);
            }
            this.headKind = HeadKindEnum.STRING;
        } else {
            this.initColumnProperties(convertAllFiled);
        }
        this.initHeadRowNumber();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The initialization sheet/table 'ExcelHeadProperty' is complete , head kind is {}", (Object)this.headKind);
        }
        if (!this.hasHead()) {
            LOGGER.warn("The table has no header set and all annotations will not be read.If you want to use annotations, please use set head class in ExcelWriterBuilder/ExcelWriterSheetBuilder/ExcelWriterTableBuilder");
        }
    }

    private void initHeadRowNumber() {
        List<String> list;
        this.headRowNumber = 0;
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.size() <= this.headRowNumber) continue;
            this.headRowNumber = list.size();
        }
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.isEmpty() || list.size() >= this.headRowNumber) continue;
            int lack = this.headRowNumber - list.size();
            int last = list.size() - 1;
            for (int i = 0; i < lack; ++i) {
                list.add(list.get(last));
            }
        }
    }

    private void initColumnProperties(Boolean convertAllFiled) {
        if (this.headClazz == null) {
            return;
        }
        ArrayList fieldList = new ArrayList();
        for (Class tempClass = this.headClazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            Collections.addAll(fieldList, tempClass.getDeclaredFields());
        }
        ArrayList<Field> defaultFieldList = new ArrayList<Field>();
        TreeMap<Integer, Field> customFiledMap = new TreeMap<Integer, Field>();
        for (Field field : fieldList) {
            ExcelIgnore excelIgnore = field.getAnnotation(ExcelIgnore.class);
            if (excelIgnore != null) {
                this.ignoreMap.put(field.getName(), field);
                continue;
            }
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null && convertAllFiled != null && !convertAllFiled.booleanValue()) {
                this.ignoreMap.put(field.getName(), field);
                continue;
            }
            if (excelProperty == null || excelProperty.index() < 0) {
                defaultFieldList.add(field);
                continue;
            }
            if (customFiledMap.containsKey(excelProperty.index())) {
                throw new ExcelGenerateException("The index of '" + ((Field)customFiledMap.get(excelProperty.index())).getName() + "' and '" + field.getName() + "' must be inconsistent");
            }
            customFiledMap.put(excelProperty.index(), field);
        }
        int index = 0;
        for (Field field : defaultFieldList) {
            while (customFiledMap.containsKey(index)) {
                this.initOneColumnProperty(index, (Field)customFiledMap.get(index), Boolean.TRUE);
                customFiledMap.remove(index);
                ++index;
            }
            this.initOneColumnProperty(index, field, Boolean.FALSE);
            ++index;
        }
        for (Map.Entry entry : customFiledMap.entrySet()) {
            this.initOneColumnProperty((Integer)entry.getKey(), (Field)entry.getValue(), Boolean.TRUE);
        }
        this.headKind = HeadKindEnum.CLASS;
    }

    private void initOneColumnProperty(int index, Field field, Boolean forceIndex) {
        Class<? extends Converter> convertClazz;
        boolean notForceName;
        ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
        ArrayList<String> tmpHeadList = new ArrayList<String>();
        boolean bl = notForceName = excelProperty == null || excelProperty.value().length <= 0 || excelProperty.value().length == 1 && StringUtils.isEmpty(excelProperty.value()[0]);
        if (notForceName) {
            tmpHeadList.add(field.getName());
        } else {
            Collections.addAll(tmpHeadList, excelProperty.value());
        }
        Head head = new Head(index, field.getName(), tmpHeadList, forceIndex, !notForceName);
        ExcelContentProperty excelContentProperty = new ExcelContentProperty();
        if (excelProperty != null && (convertClazz = excelProperty.converter()) != AutoConverter.class) {
            try {
                Converter converter = convertClazz.newInstance();
                excelContentProperty.setConverter(converter);
            }
            catch (Exception e) {
                throw new ExcelCommonException("Can not instance custom converter:" + convertClazz.getName());
            }
        }
        excelContentProperty.setHead(head);
        excelContentProperty.setField(field);
        excelContentProperty.setDateTimeFormatProperty(DateTimeFormatProperty.build(field.getAnnotation(DateTimeFormat.class)));
        excelContentProperty.setNumberFormatProperty(NumberFormatProperty.build(field.getAnnotation(NumberFormat.class)));
        this.headMap.put(index, head);
        this.contentPropertyMap.put(index, excelContentProperty);
    }

    public Class getHeadClazz() {
        return this.headClazz;
    }

    public void setHeadClazz(Class headClazz) {
        this.headClazz = headClazz;
    }

    public HeadKindEnum getHeadKind() {
        return this.headKind;
    }

    public void setHeadKind(HeadKindEnum headKind) {
        this.headKind = headKind;
    }

    public boolean hasHead() {
        return this.headKind != HeadKindEnum.NONE;
    }

    public int getHeadRowNumber() {
        return this.headRowNumber;
    }

    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    public Map<Integer, Head> getHeadMap() {
        return this.headMap;
    }

    public void setHeadMap(Map<Integer, Head> headMap) {
        this.headMap = headMap;
    }

    public Map<Integer, ExcelContentProperty> getContentPropertyMap() {
        return this.contentPropertyMap;
    }

    public void setContentPropertyMap(Map<Integer, ExcelContentProperty> contentPropertyMap) {
        this.contentPropertyMap = contentPropertyMap;
    }

    public Map<String, Field> getIgnoreMap() {
        return this.ignoreMap;
    }

    public void setIgnoreMap(Map<String, Field> ignoreMap) {
        this.ignoreMap = ignoreMap;
    }
}

