/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.context;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.CellRange;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.handler.WorkbookWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.alibaba.excel.write.property.ExcelWriteHeadProperty;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteContextImpl
implements WriteContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteContextImpl.class);
    private WriteWorkbookHolder writeWorkbookHolder;
    private WriteSheetHolder writeSheetHolder;
    private WriteTableHolder writeTableHolder;
    private WriteHolder currentWriteHolder;

    public WriteContextImpl(WriteWorkbook writeWorkbook) {
        if (writeWorkbook == null) {
            throw new IllegalArgumentException("Workbook argument cannot be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Begin to Initialization 'WriteContextImpl'");
        }
        this.initCurrentWorkbookHolder(writeWorkbook);
        this.beforeWorkbookCreate();
        try {
            this.writeWorkbookHolder.setWorkbook(WorkBookUtil.createWorkBook(this.writeWorkbookHolder));
        }
        catch (Exception e) {
            throw new ExcelGenerateException("Create workbook failure", e);
        }
        this.afterWorkbookCreate();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialization 'WriteContextImpl' complete");
        }
    }

    private void beforeWorkbookCreate() {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(WorkbookWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof WorkbookWriteHandler)) continue;
            ((WorkbookWriteHandler)writeHandler).beforeWorkbookCreate();
        }
    }

    private void afterWorkbookCreate() {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(WorkbookWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof WorkbookWriteHandler)) continue;
            ((WorkbookWriteHandler)writeHandler).afterWorkbookCreate(this.writeWorkbookHolder);
        }
    }

    private void initCurrentWorkbookHolder(WriteWorkbook writeWorkbook) {
        this.writeWorkbookHolder = new WriteWorkbookHolder(writeWorkbook);
        this.currentWriteHolder = this.writeWorkbookHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeWorkbookHolder");
        }
    }

    @Override
    public void currentSheet(WriteSheet writeSheet) {
        if (writeSheet == null) {
            throw new IllegalArgumentException("Sheet argument cannot be null");
        }
        if (writeSheet.getSheetNo() == null || writeSheet.getSheetNo() <= 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sheet number is null");
            }
            writeSheet.setSheetNo(0);
        }
        if (this.writeWorkbookHolder.getHasBeenInitializedSheet().containsKey(writeSheet.getSheetNo())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sheet:{} is already existed", (Object)writeSheet.getSheetNo());
            }
            this.writeSheetHolder = this.writeWorkbookHolder.getHasBeenInitializedSheet().get(writeSheet.getSheetNo());
            this.writeSheetHolder.setNewInitialization(Boolean.FALSE);
            this.writeTableHolder = null;
            this.currentWriteHolder = this.writeSheetHolder;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("CurrentConfiguration is writeSheetHolder");
            }
            return;
        }
        this.initCurrentSheetHolder(writeSheet);
        this.beforeSheetCreate();
        this.initSheet();
        this.afterSheetCreate();
    }

    private void beforeSheetCreate() {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(SheetWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof SheetWriteHandler)) continue;
            ((SheetWriteHandler)writeHandler).beforeSheetCreate(this.writeWorkbookHolder, this.writeSheetHolder);
        }
    }

    private void afterSheetCreate() {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(SheetWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof SheetWriteHandler)) continue;
            ((SheetWriteHandler)writeHandler).afterSheetCreate(this.writeWorkbookHolder, this.writeSheetHolder);
        }
        if (null != this.writeWorkbookHolder.getWriteWorkbook().getWriteHandler()) {
            this.writeWorkbookHolder.getWriteWorkbook().getWriteHandler().sheet(this.writeSheetHolder.getSheetNo(), this.writeSheetHolder.getSheet());
        }
    }

    private void initCurrentSheetHolder(WriteSheet writeSheet) {
        this.writeSheetHolder = new WriteSheetHolder(writeSheet, this.writeWorkbookHolder);
        this.writeWorkbookHolder.getHasBeenInitializedSheet().put(writeSheet.getSheetNo(), this.writeSheetHolder);
        this.writeTableHolder = null;
        this.currentWriteHolder = this.writeSheetHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeSheetHolder");
        }
    }

    private void initSheet() {
        Sheet currentSheet;
        try {
            currentSheet = this.writeWorkbookHolder.getWorkbook().getSheetAt(this.writeSheetHolder.getSheetNo().intValue());
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Can not find sheet:{} ,now create it", (Object)this.writeSheetHolder.getSheetNo());
            }
            currentSheet = WorkBookUtil.createSheet(this.writeWorkbookHolder.getWorkbook(), this.writeSheetHolder.getSheetName());
        }
        this.writeSheetHolder.setSheet(currentSheet);
        this.initHead(this.writeSheetHolder.excelWriteHeadProperty());
    }

    public void initHead(ExcelWriteHeadProperty excelWriteHeadProperty) {
        if (!this.currentWriteHolder.needHead() || !this.currentWriteHolder.excelWriteHeadProperty().hasHead()) {
            return;
        }
        int newRowIndex = this.writeSheetHolder.getNewRowIndexAndStartDoWrite();
        this.addMergedRegionToCurrentSheet(excelWriteHeadProperty, newRowIndex += this.currentWriteHolder.relativeHeadRowIndex());
        int relativeRowIndex = 0;
        int i = newRowIndex;
        while (i < excelWriteHeadProperty.getHeadRowNumber() + newRowIndex) {
            this.beforeRowCreate(newRowIndex, relativeRowIndex);
            Row row = WorkBookUtil.createRow(this.writeSheetHolder.getSheet(), i);
            this.afterRowCreate(row, relativeRowIndex);
            this.addOneRowOfHeadDataToExcel(row, excelWriteHeadProperty.getHeadMap(), relativeRowIndex);
            ++i;
            ++relativeRowIndex;
        }
    }

    private void beforeRowCreate(int rowIndex, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(RowWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof RowWriteHandler)) continue;
            ((RowWriteHandler)writeHandler).beforeRowCreate(this.writeSheetHolder, this.writeTableHolder, rowIndex, relativeRowIndex, true);
        }
    }

    private void afterRowCreate(Row row, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(RowWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof RowWriteHandler)) continue;
            ((RowWriteHandler)writeHandler).afterRowCreate(this.writeSheetHolder, this.writeTableHolder, row, relativeRowIndex, true);
        }
        if (null != this.writeWorkbookHolder.getWriteWorkbook().getWriteHandler()) {
            this.writeWorkbookHolder.getWriteWorkbook().getWriteHandler().row(row.getRowNum(), row);
        }
    }

    private void addMergedRegionToCurrentSheet(ExcelWriteHeadProperty excelWriteHeadProperty, int rowIndex) {
        for (CellRange cellRangeModel : excelWriteHeadProperty.headCellRangeList()) {
            this.writeSheetHolder.getSheet().addMergedRegion(new CellRangeAddress(cellRangeModel.getFirstRow() + rowIndex, cellRangeModel.getLastRow() + rowIndex, cellRangeModel.getFirstCol(), cellRangeModel.getLastCol()));
        }
    }

    private void addOneRowOfHeadDataToExcel(Row row, Map<Integer, Head> headMap, int relativeRowIndex) {
        for (Map.Entry<Integer, Head> entry : headMap.entrySet()) {
            Head head = entry.getValue();
            this.beforeCellCreate(row, head, relativeRowIndex);
            Cell cell = WorkBookUtil.createCell(row, (int)entry.getKey(), head.getHeadNameList().get(relativeRowIndex));
            this.afterCellCreate(head, cell, relativeRowIndex);
        }
    }

    private void beforeCellCreate(Row row, Head head, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(CellWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof CellWriteHandler)) continue;
            ((CellWriteHandler)writeHandler).beforeCellCreate(this.writeSheetHolder, this.writeTableHolder, row, head, relativeRowIndex, true);
        }
    }

    private void afterCellCreate(Head head, Cell cell, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.currentWriteHolder.writeHandlerMap().get(CellWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof CellWriteHandler)) continue;
            ((CellWriteHandler)writeHandler).afterCellCreate(this.writeSheetHolder, this.writeTableHolder, null, cell, head, relativeRowIndex, true);
        }
        if (null != this.writeWorkbookHolder.getWriteWorkbook().getWriteHandler()) {
            this.writeWorkbookHolder.getWriteWorkbook().getWriteHandler().cell(cell.getRowIndex(), cell);
        }
    }

    @Override
    public void currentTable(WriteTable writeTable) {
        if (writeTable == null) {
            return;
        }
        if (writeTable.getTableNo() == null || writeTable.getTableNo() <= 0) {
            writeTable.setTableNo(0);
        }
        if (this.writeSheetHolder.getHasBeenInitializedTable().containsKey(writeTable.getTableNo())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Table:{} is already existed", (Object)writeTable.getTableNo());
            }
            this.writeTableHolder = this.writeSheetHolder.getHasBeenInitializedTable().get(writeTable.getTableNo());
            this.writeTableHolder.setNewInitialization(Boolean.FALSE);
            this.currentWriteHolder = this.writeTableHolder;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("CurrentConfiguration is writeTableHolder");
            }
            return;
        }
        this.initCurrentTableHolder(writeTable);
        this.initHead(this.writeTableHolder.excelWriteHeadProperty());
    }

    private void initCurrentTableHolder(WriteTable writeTable) {
        this.writeTableHolder = new WriteTableHolder(writeTable, this.writeSheetHolder, this.writeWorkbookHolder);
        this.writeSheetHolder.getHasBeenInitializedTable().put(writeTable.getTableNo(), this.writeTableHolder);
        this.currentWriteHolder = this.writeTableHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeTableHolder");
        }
    }

    @Override
    public WriteWorkbookHolder writeWorkbookHolder() {
        return this.writeWorkbookHolder;
    }

    @Override
    public WriteSheetHolder writeSheetHolder() {
        return this.writeSheetHolder;
    }

    @Override
    public WriteTableHolder writeTableHolder() {
        return this.writeTableHolder;
    }

    @Override
    public WriteHolder currentWriteHolder() {
        return this.currentWriteHolder;
    }

    @Override
    public void finish() {
        if (this.writeWorkbookHolder == null) {
            return;
        }
        try {
            this.writeWorkbookHolder.getWorkbook().write(this.writeWorkbookHolder.getOutputStream());
            this.writeWorkbookHolder.getWorkbook().close();
        }
        catch (Throwable t) {
            this.throwCanNotCloseIo(t);
        }
        try {
            Workbook workbook = this.writeWorkbookHolder.getWorkbook();
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
        catch (Throwable t) {
            this.throwCanNotCloseIo(t);
        }
        try {
            if (this.writeWorkbookHolder.getAutoCloseStream().booleanValue() && this.writeWorkbookHolder.getOutputStream() != null) {
                this.writeWorkbookHolder.getOutputStream().close();
            }
        }
        catch (Throwable t) {
            this.throwCanNotCloseIo(t);
        }
        try {
            if (this.writeWorkbookHolder.getAutoCloseStream().booleanValue() && this.writeWorkbookHolder.getTemplateInputStream() != null) {
                this.writeWorkbookHolder.getTemplateInputStream().close();
            }
        }
        catch (Throwable t) {
            this.throwCanNotCloseIo(t);
        }
        try {
            if (!this.writeWorkbookHolder.getAutoCloseStream().booleanValue() && this.writeWorkbookHolder.getFile() != null && this.writeWorkbookHolder.getOutputStream() != null) {
                this.writeWorkbookHolder.getOutputStream().close();
            }
        }
        catch (Throwable t) {
            this.throwCanNotCloseIo(t);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished write.");
        }
    }

    private void throwCanNotCloseIo(Throwable t) {
        throw new ExcelGenerateException("Can not close IO", t);
    }

    @Override
    public Sheet getCurrentSheet() {
        return this.writeSheetHolder.getSheet();
    }

    @Override
    public boolean needHead() {
        return this.writeSheetHolder.needHead();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.writeWorkbookHolder.getOutputStream();
    }

    @Override
    public Workbook getWorkbook() {
        return this.writeWorkbookHolder.getWorkbook();
    }
}

