/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.support;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.registry.integration.RegistryDirectory;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;

public class ConsumerInvokerWrapper<T>
implements Invoker {
    private Invoker<T> invoker;
    private URL originUrl;
    private URL registryUrl;
    private URL consumerUrl;
    private RegistryDirectory registryDirectory;

    public ConsumerInvokerWrapper(Invoker<T> invoker, URL registryUrl, URL consumerUrl, RegistryDirectory registryDirectory) {
        this.invoker = invoker;
        this.originUrl = URL.valueOf((String)invoker.getUrl().toFullString());
        this.registryUrl = URL.valueOf((String)registryUrl.toFullString());
        this.consumerUrl = consumerUrl;
        this.registryDirectory = registryDirectory;
    }

    public Class<T> getInterface() {
        return this.invoker.getInterface();
    }

    public URL getUrl() {
        return this.invoker.getUrl();
    }

    public boolean isAvailable() {
        return this.invoker.isAvailable();
    }

    public Result invoke(Invocation invocation) throws RpcException {
        return this.invoker.invoke(invocation);
    }

    public void destroy() {
        this.invoker.destroy();
    }

    public URL getOriginUrl() {
        return this.originUrl;
    }

    public URL getRegistryUrl() {
        return this.registryUrl;
    }

    public Invoker<T> getInvoker() {
        return this.invoker;
    }

    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public RegistryDirectory getRegistryDirectory() {
        return this.registryDirectory;
    }
}

