/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.rest;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.trogdor.rest.ErrorResponse;
import org.apache.kafka.trogdor.rest.RequestConflictException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionMapper.class);

    @Override
    public Response toResponse(Throwable e) {
        if (log.isDebugEnabled()) {
            log.debug("Uncaught exception in REST call: ", e);
        } else if (log.isInfoEnabled()) {
            log.info("Uncaught exception in REST call: {}", (Object)e.getMessage());
        }
        if (e instanceof NotFoundException) {
            return this.buildResponse(Response.Status.NOT_FOUND, e);
        }
        if (e instanceof InvalidRequestException) {
            return this.buildResponse(Response.Status.BAD_REQUEST, e);
        }
        if (e instanceof InvalidTypeIdException) {
            return this.buildResponse(Response.Status.NOT_IMPLEMENTED, e);
        }
        if (e instanceof JsonMappingException) {
            return this.buildResponse(Response.Status.BAD_REQUEST, e);
        }
        if (e instanceof ClassNotFoundException) {
            return this.buildResponse(Response.Status.NOT_IMPLEMENTED, e);
        }
        if (e instanceof SerializationException) {
            return this.buildResponse(Response.Status.BAD_REQUEST, e);
        }
        if (e instanceof RequestConflictException) {
            return this.buildResponse(Response.Status.CONFLICT, e);
        }
        return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, e);
    }

    public static Exception toException(int code, String msg) throws Exception {
        if (code == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new NotFoundException(msg);
        }
        if (code == Response.Status.NOT_IMPLEMENTED.getStatusCode()) {
            throw new ClassNotFoundException(msg);
        }
        if (code == Response.Status.BAD_REQUEST.getStatusCode()) {
            throw new InvalidRequestException(msg);
        }
        if (code == Response.Status.CONFLICT.getStatusCode()) {
            throw new RequestConflictException(msg);
        }
        throw new RuntimeException(msg);
    }

    private Response buildResponse(Response.Status code, Throwable e) {
        return Response.status(code).entity(new ErrorResponse(code.getStatusCode(), e.getMessage())).build();
    }
}

