/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.socket;

import com.alibaba.otter.canal.parse.driver.mysql.socket.NettySocketChannel;
import com.alibaba.otter.canal.parse.driver.mysql.socket.SocketChannel;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettySocketChannelPool {
    private static EventLoopGroup group = new NioEventLoopGroup();
    private static Bootstrap boot = new Bootstrap();
    private static Map<Channel, SocketChannel> chManager = new ConcurrentHashMap<Channel, SocketChannel>();
    private static final Logger logger = LoggerFactory.getLogger(NettySocketChannelPool.class);

    public static SocketChannel open(SocketAddress address) throws Exception {
        SocketChannel socket = null;
        ChannelFuture future = boot.connect(address).sync();
        if (future.isSuccess()) {
            ((BusinessHandler)future.channel().pipeline().get(BusinessHandler.class)).latch.await();
            socket = chManager.get(future.channel());
        }
        if (null == socket) {
            throw new IOException("can't create socket!");
        }
        return socket;
    }

    static {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)boot.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)AdaptiveRecvByteBufAllocator.DEFAULT)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new BusinessHandler()});
            }
        });
    }

    public static class BusinessHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private NettySocketChannel socket = null;
        private final CountDownLatch latch = new CountDownLatch(1);

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.socket.setChannel(null);
            chManager.remove(ctx.channel());
            super.channelInactive(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.socket = new NettySocketChannel();
            this.socket.setChannel(ctx.channel());
            chManager.put(ctx.channel(), this.socket);
            this.latch.countDown();
            super.channelActive(ctx);
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            if (this.socket != null) {
                this.socket.writeCache(msg);
            } else {
                logger.error("no socket available.");
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.error("business error.", cause);
            ctx.close();
        }
    }
}

