/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.socket;

import com.alibaba.otter.canal.parse.driver.mysql.socket.SocketChannel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.util.internal.OutOfDirectMemoryError;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.net.SocketAddress;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySocketChannel
implements SocketChannel {
    private static final Logger logger = LoggerFactory.getLogger(SocketChannel.class);
    private static final int WAIT_PERIOD = 10;
    private static final int DEFAULT_INIT_BUFFER_SIZE = 0x100000;
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x1000000;
    private Channel channel = null;
    private Object lock = new Object();
    private ByteBuf cache = PooledByteBufAllocator.DEFAULT.directBuffer(0x100000);
    private int maxDirectBuffer = this.cache.maxCapacity();

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCache(ByteBuf buf) throws InterruptedException, IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (null == this.cache) {
                    throw new IOException("socket is closed !");
                }
                if (!buf.isReadable()) break;
                int length = buf.readableBytes();
                int deltaSize = length - this.cache.writableBytes();
                if (deltaSize > 0) {
                    int oldCapacity;
                    if (this.cache.readerIndex() >= deltaSize) {
                        this.cache.discardReadBytes();
                        oldCapacity = this.cache.capacity();
                        if (oldCapacity > 0x1000000) {
                            int newCapacity = this.cache.writerIndex();
                            newCapacity = ((newCapacity - 1) / 0x100000 + 1) * 0x100000;
                            int quarter = newCapacity >> 2;
                            if ((newCapacity += (quarter = ((quarter - 1) / 0x100000 + 1) * 0x100000)) < oldCapacity >> 1) {
                                try {
                                    this.cache.capacity(newCapacity);
                                    logger.info("shrink cache capacity: {} - {} = {} bytes", new Object[]{oldCapacity, oldCapacity - newCapacity, newCapacity});
                                }
                                catch (OutOfMemoryError ignore) {
                                    this.maxDirectBuffer = oldCapacity;
                                    logger.warn("cache OutOfMemoryError: {} bytes", (Object)newCapacity, (Object)ignore);
                                }
                            }
                        }
                    } else {
                        oldCapacity = this.cache.capacity();
                        if (oldCapacity < this.maxDirectBuffer) {
                            int quarter = oldCapacity >> 2;
                            int newCapacity = oldCapacity + (deltaSize = ((deltaSize - 1) / (quarter = ((quarter - 1) / 0x100000 + 1) * 0x100000) + 1) * quarter);
                            if (newCapacity > this.maxDirectBuffer) {
                                newCapacity = this.maxDirectBuffer;
                            }
                            try {
                                this.cache.capacity(newCapacity);
                                logger.info("expand cache capacity: {} + {} = {} bytes", new Object[]{oldCapacity, newCapacity - oldCapacity, newCapacity});
                            }
                            catch (OutOfDirectMemoryError e) {
                                long maxDirectMemory = SystemPropertyUtil.getLong((String)"io.netty.maxDirectMemory", (long)-1L);
                                if (maxDirectMemory < 0L) {
                                    maxDirectMemory = PlatformDependent.maxDirectMemory();
                                }
                                if ((long)this.maxDirectBuffer > maxDirectMemory) {
                                    newCapacity = this.maxDirectBuffer = (int)maxDirectMemory;
                                    logger.warn("resize maxDirectBuffer: {} bytes", (Object)this.maxDirectBuffer, (Object)e);
                                    try {
                                        this.cache.capacity(newCapacity);
                                        logger.info("expand cache capacity: {} + {} = {} bytes", new Object[]{oldCapacity, newCapacity - oldCapacity, newCapacity});
                                    }
                                    catch (OutOfMemoryError ignore) {
                                        this.maxDirectBuffer = oldCapacity;
                                        logger.warn("cache OutOfMemoryError: {} bytes", (Object)newCapacity, (Object)ignore);
                                    }
                                } else {
                                    this.maxDirectBuffer = oldCapacity;
                                    logger.warn("cache OutOfDirectMemoryError: {} bytes", (Object)newCapacity, (Object)e);
                                }
                            }
                            catch (OutOfMemoryError ignore) {
                                this.maxDirectBuffer = oldCapacity;
                                logger.warn("cache OutOfMemoryError: {} bytes", (Object)newCapacity, (Object)ignore);
                            }
                        }
                    }
                    deltaSize = length - this.cache.writableBytes();
                }
                if (deltaSize != length) {
                    if (deltaSize <= 0) {
                        this.cache.writeBytes(buf, length);
                        break;
                    }
                    this.cache.writeBytes(buf, length - deltaSize);
                }
                this.lock.wait(10L);
                this.cache.discardReadBytes();
            }
        }
    }

    @Override
    public void write(byte[] ... buf) throws IOException {
        if (this.channel == null || !this.channel.isWritable()) {
            throw new IOException("write failed ! please checking !");
        }
        this.channel.writeAndFlush((Object)Unpooled.copiedBuffer((byte[][])buf));
    }

    @Override
    public byte[] read(int readSize) throws IOException {
        return this.read(readSize, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(int readSize, int timeout) throws IOException {
        int accumulatedWaitTime = 0;
        if (timeout > 0 && readSize > 0x100000) {
            timeout *= readSize / 0x100000 + 1;
        }
        while (readSize > this.cache.readableBytes()) {
            Object sb;
            if (null == this.channel) {
                throw new IOException("socket has Interrupted !");
            }
            if (timeout > 0 && (accumulatedWaitTime += 10) > timeout) {
                sb = new StringBuilder("socket read timeout occured !");
                ((StringBuilder)sb).append(" readSize = ").append(readSize);
                ((StringBuilder)sb).append(", readableBytes = ").append(this.cache.readableBytes());
                ((StringBuilder)sb).append(", timeout = ").append(timeout);
                throw new IOException(((StringBuilder)sb).toString());
            }
            sb = this;
            synchronized (sb) {
                try {
                    this.wait(10L);
                }
                catch (InterruptedException e) {
                    throw new IOException("socket has Interrupted !");
                }
            }
        }
        byte[] back = new byte[readSize];
        Object object = this.lock;
        synchronized (object) {
            this.cache.readBytes(back);
        }
        return back;
    }

    @Override
    public void read(byte[] data, int off, int len, int timeout) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public boolean isConnected() {
        return this.channel != null;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.channel != null ? this.channel.remoteAddress() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
        Object object = this.lock;
        synchronized (object) {
            this.cache.discardReadBytes();
            this.cache.release();
            this.cache = null;
        }
    }
}

