/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.index.AbstractLogPositionManager;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.alibaba.otter.canal.store.helper.CanalEventUtils;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MetaLogPositionManager
extends AbstractLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(MetaLogPositionManager.class);
    private final CanalMetaManager metaManager;

    public MetaLogPositionManager(CanalMetaManager metaManager) {
        if (metaManager == null) {
            throw new NullPointerException("null metaManager");
        }
        this.metaManager = metaManager;
    }

    public void stop() {
        super.stop();
        if (this.metaManager.isStart()) {
            this.metaManager.stop();
        }
    }

    public void start() {
        super.start();
        if (!this.metaManager.isStart()) {
            this.metaManager.start();
        }
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        List clientIdentities = this.metaManager.listAllSubscribeInfo(destination);
        LogPosition result = null;
        if (!CollectionUtils.isEmpty((Collection)clientIdentities)) {
            for (ClientIdentity clientIdentity : clientIdentities) {
                LogPosition position = (LogPosition)this.metaManager.getCursor(clientIdentity);
                if (position == null) continue;
                if (result == null) {
                    result = position;
                    continue;
                }
                result = CanalEventUtils.min((LogPosition)result, (LogPosition)position);
            }
        }
        return result;
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) throws CanalParseException {
        logger.info("persist LogPosition:{}", (Object)destination, (Object)logPosition);
    }
}

