/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.tsdb;

import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DefaultTableMetaTSDBFactory;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDB;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TableMetaTSDBBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultTableMetaTSDBFactory.class);
    private static ConcurrentMap<String, ClassPathXmlApplicationContext> contexts = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMetaTSDB build(String destination, String springXml) {
        if (StringUtils.isNotEmpty((String)springXml)) {
            ClassPathXmlApplicationContext applicationContext = (ClassPathXmlApplicationContext)contexts.get(destination);
            if (applicationContext == null) {
                ConcurrentMap<String, ClassPathXmlApplicationContext> concurrentMap = contexts;
                synchronized (concurrentMap) {
                    if (applicationContext == null) {
                        applicationContext = new ClassPathXmlApplicationContext(springXml);
                        contexts.put(destination, applicationContext);
                    }
                }
            }
            TableMetaTSDB tableMetaTSDB = (TableMetaTSDB)applicationContext.getBean("tableMetaTSDB");
            logger.info("{} init TableMetaTSDB with {}", (Object)destination, (Object)springXml);
            return tableMetaTSDB;
        }
        return null;
    }

    public static void destory(String destination) {
        ClassPathXmlApplicationContext context = (ClassPathXmlApplicationContext)contexts.remove(destination);
        if (context != null) {
            logger.info("{} destory TableMetaTSDB", (Object)destination);
            context.close();
        }
    }
}

