/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.filter.CanalEventFilter;
import com.alibaba.otter.canal.filter.aviater.AviaterRegexFilter;
import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.AbstractEventParser;
import com.alibaba.otter.canal.parse.inbound.BinlogParser;
import com.alibaba.otter.canal.parse.inbound.MultiStageCoprocessor;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlMultiStageCoprocessor;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.LogEventConvert;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DatabaseTableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DefaultTableMetaTSDBFactory;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDB;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDBFactory;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractMysqlEventParser
extends AbstractEventParser {
    protected static final long BINLOG_START_OFFEST = 4L;
    protected TableMetaTSDBFactory tableMetaTSDBFactory = new DefaultTableMetaTSDBFactory();
    protected boolean enableTsdb = false;
    protected int tsdbSnapshotInterval = 24;
    protected int tsdbSnapshotExpire = 360;
    protected String tsdbSpringXml;
    protected TableMetaTSDB tableMetaTSDB;
    protected byte connectionCharsetNumber = (byte)33;
    protected Charset connectionCharset = Charset.forName("UTF-8");
    protected boolean filterQueryDcl = false;
    protected boolean filterQueryDml = false;
    protected boolean filterQueryDdl = false;
    protected boolean filterRows = false;
    protected boolean filterTableError = false;
    protected boolean useDruidDdlFilter = true;
    protected final AtomicLong receivedBinlogBytes = new AtomicLong(0L);
    private final AtomicLong eventsPublishBlockingTime = new AtomicLong(0L);

    @Override
    protected BinlogParser buildParser() {
        LogEventConvert convert = new LogEventConvert();
        if (this.eventFilter != null && this.eventFilter instanceof AviaterRegexFilter) {
            convert.setNameFilter((AviaterRegexFilter)this.eventFilter);
        }
        if (this.eventBlackFilter != null && this.eventBlackFilter instanceof AviaterRegexFilter) {
            convert.setNameBlackFilter((AviaterRegexFilter)this.eventBlackFilter);
        }
        convert.setCharset(this.connectionCharset);
        convert.setFilterQueryDcl(this.filterQueryDcl);
        convert.setFilterQueryDml(this.filterQueryDml);
        convert.setFilterQueryDdl(this.filterQueryDdl);
        convert.setFilterRows(this.filterRows);
        convert.setFilterTableError(this.filterTableError);
        convert.setUseDruidDdlFilter(this.useDruidDdlFilter);
        return convert;
    }

    @Override
    public void setEventFilter(CanalEventFilter eventFilter) {
        super.setEventFilter(eventFilter);
        if (eventFilter != null && eventFilter instanceof AviaterRegexFilter) {
            if (this.binlogParser instanceof LogEventConvert) {
                ((LogEventConvert)this.binlogParser).setNameFilter((AviaterRegexFilter)eventFilter);
            }
            if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
                ((DatabaseTableMeta)this.tableMetaTSDB).setFilter(eventFilter);
            }
        }
    }

    @Override
    public void setEventBlackFilter(CanalEventFilter eventBlackFilter) {
        super.setEventBlackFilter(eventBlackFilter);
        if (eventBlackFilter != null && eventBlackFilter instanceof AviaterRegexFilter) {
            if (this.binlogParser instanceof LogEventConvert) {
                ((LogEventConvert)this.binlogParser).setNameBlackFilter((AviaterRegexFilter)eventBlackFilter);
            }
            if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
                ((DatabaseTableMeta)this.tableMetaTSDB).setBlackFilter(eventBlackFilter);
            }
        }
    }

    @Override
    protected boolean processTableMeta(EntryPosition position) {
        if (this.tableMetaTSDB != null) {
            if (position.getTimestamp() == null || position.getTimestamp() <= 0L) {
                throw new CanalParseException("use gtid and TableMeta TSDB should be config timestamp > 0");
            }
            return this.tableMetaTSDB.rollback(position);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws CanalParseException {
        if (this.enableTsdb && this.tableMetaTSDB == null) {
            Class<CanalEventParser> clazz = CanalEventParser.class;
            // MONITORENTER : com.alibaba.otter.canal.parse.CanalEventParser.class
            try {
                System.setProperty("canal.instance.destination", this.destination);
                this.tableMetaTSDB = this.tableMetaTSDBFactory.build(this.destination, this.tsdbSpringXml);
            }
            finally {
                System.setProperty("canal.instance.destination", "");
            }
            // MONITOREXIT : clazz
        }
        super.start();
    }

    @Override
    public void stop() throws CanalParseException {
        if (this.enableTsdb) {
            this.tableMetaTSDBFactory.destory(this.destination);
            this.tableMetaTSDB = null;
        }
        super.stop();
    }

    @Override
    protected MultiStageCoprocessor buildMultiStageCoprocessor() {
        MysqlMultiStageCoprocessor mysqlMultiStageCoprocessor = new MysqlMultiStageCoprocessor(this.parallelBufferSize, this.parallelThreadSize, (LogEventConvert)this.binlogParser, this.transactionBuffer, this.destination);
        mysqlMultiStageCoprocessor.setEventsPublishBlockingTime(this.eventsPublishBlockingTime);
        return mysqlMultiStageCoprocessor;
    }

    public void setConnectionCharsetNumber(byte connectionCharsetNumber) {
        this.connectionCharsetNumber = connectionCharsetNumber;
    }

    public void setConnectionCharset(Charset connectionCharset) {
        this.connectionCharset = connectionCharset;
    }

    public void setConnectionCharset(String connectionCharset) {
        this.connectionCharset = Charset.forName(connectionCharset);
    }

    public void setFilterQueryDcl(boolean filterQueryDcl) {
        this.filterQueryDcl = filterQueryDcl;
    }

    public void setFilterQueryDml(boolean filterQueryDml) {
        this.filterQueryDml = filterQueryDml;
    }

    public void setFilterQueryDdl(boolean filterQueryDdl) {
        this.filterQueryDdl = filterQueryDdl;
    }

    public void setFilterRows(boolean filterRows) {
        this.filterRows = filterRows;
    }

    public void setFilterTableError(boolean filterTableError) {
        this.filterTableError = filterTableError;
    }

    public boolean isUseDruidDdlFilter() {
        return this.useDruidDdlFilter;
    }

    public void setUseDruidDdlFilter(boolean useDruidDdlFilter) {
        this.useDruidDdlFilter = useDruidDdlFilter;
    }

    public void setEnableTsdb(boolean enableTsdb) {
        this.enableTsdb = enableTsdb;
        if (this.enableTsdb && this.tableMetaTSDB == null) {
            this.tableMetaTSDB = this.tableMetaTSDBFactory.build(this.destination, this.tsdbSpringXml);
        }
    }

    public void setTsdbSpringXml(String tsdbSpringXml) {
        this.tsdbSpringXml = tsdbSpringXml;
        if (this.enableTsdb && this.tableMetaTSDB == null) {
            this.tableMetaTSDB = this.tableMetaTSDBFactory.build(this.destination, tsdbSpringXml);
        }
    }

    public void setTableMetaTSDBFactory(TableMetaTSDBFactory tableMetaTSDBFactory) {
        this.tableMetaTSDBFactory = tableMetaTSDBFactory;
    }

    public AtomicLong getEventsPublishBlockingTime() {
        return this.eventsPublishBlockingTime;
    }

    public AtomicLong getReceivedBinlogBytes() {
        return this.receivedBinlogBytes;
    }

    public int getTsdbSnapshotInterval() {
        return this.tsdbSnapshotInterval;
    }

    public void setTsdbSnapshotInterval(int tsdbSnapshotInterval) {
        this.tsdbSnapshotInterval = tsdbSnapshotInterval;
    }

    public int getTsdbSnapshotExpire() {
        return this.tsdbSnapshotExpire;
    }

    public void setTsdbSnapshotExpire(int tsdbSnapshotExpire) {
        this.tsdbSnapshotExpire = tsdbSnapshotExpire;
    }
}

