/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;

public class JdbcDoubleColumnValues
extends JdbcColumnValues {
    Double[] array;

    public JdbcDoubleColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new Double[rowCount];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = JdbcDoubleColumnValues.castToDouble(obj);
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(JdbcDoubleColumnValues.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw JdbcDoubleColumnValues.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw JdbcDoubleColumnValues.cannotCastException(in.getClass().getName(), "double");
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

