/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcBigDecimalColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcBooleanColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcByteaColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcDateColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcDoubleColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcFloatColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcIntegerColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcLongColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcShortColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcStringColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcTimeColumnValues;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcTimestampColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import com.alibaba.hologres.org.postgresql.util.GT;
import com.alibaba.hologres.org.postgresql.util.PSQLException;
import com.alibaba.hologres.org.postgresql.util.PSQLState;
import java.sql.SQLException;

public class JdbcColumnValuesBuilder {
    public static JdbcColumnValues build(PgConnection connection, int rowCount, int targetSqlType, String typeName, HoloConfig config) throws SQLException {
        TimestampUtils timestampUtils = connection.getTimestampUtils();
        switch (targetSqlType) {
            case 4: {
                return new JdbcIntegerColumnValues(timestampUtils, rowCount);
            }
            case -6: 
            case 5: {
                return new JdbcShortColumnValues(timestampUtils, rowCount);
            }
            case -5: {
                return new JdbcLongColumnValues(timestampUtils, rowCount);
            }
            case 7: {
                return new JdbcFloatColumnValues(timestampUtils, rowCount);
            }
            case 6: 
            case 8: {
                return new JdbcDoubleColumnValues(timestampUtils, rowCount);
            }
            case 2: 
            case 3: {
                return new JdbcBigDecimalColumnValues(timestampUtils, rowCount);
            }
            case -1: 
            case 1: 
            case 12: {
                return new JdbcStringColumnValues(timestampUtils, rowCount);
            }
            case 91: {
                return new JdbcDateColumnValues(timestampUtils, rowCount, config);
            }
            case 92: {
                return new JdbcTimeColumnValues(timestampUtils, rowCount);
            }
            case 93: 
            case 2014: {
                return new JdbcTimestampColumnValues(timestampUtils, rowCount, config);
            }
            case -7: 
            case 16: {
                return new JdbcBooleanColumnValues(timestampUtils, rowCount);
            }
            case -4: 
            case -3: 
            case -2: {
                return new JdbcByteaColumnValues(timestampUtils, rowCount);
            }
            case 1111: {
                if ("json".equals(typeName) || "jsonb".equals(typeName)) {
                    return new JdbcStringColumnValues(timestampUtils, rowCount);
                }
                if ("roaringbitmap".equals(typeName)) {
                    return new JdbcByteaColumnValues(timestampUtils, rowCount);
                }
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        throw new PSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), PSQLState.INVALID_PARAMETER_TYPE);
    }
}

