/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.collector;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.exception.HoloClientWithDetailsException;
import com.alibaba.hologres.client.impl.ExecutionPool;
import com.alibaba.hologres.client.impl.collector.CollectorStatistics;
import com.alibaba.hologres.client.impl.collector.TableShardCollector;
import com.alibaba.hologres.client.impl.collector.shard.DistributionKeyShardPolicy;
import com.alibaba.hologres.client.impl.collector.shard.ShardPolicy;
import com.alibaba.hologres.client.model.Record;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCollector {
    public static final Logger LOG = LoggerFactory.getLogger(TableCollector.class);
    private TableShardCollector[] pairArray;
    private final HoloConfig config;
    private final ExecutionPool pool;
    private CollectorStatistics stat;
    private final ShardPolicy shardPolicy;
    private final long recordSampleInterval;
    private long lastSampleTime = 0L;

    public TableCollector(HoloConfig config, ExecutionPool pool) {
        this.config = config;
        this.pool = pool;
        this.stat = new CollectorStatistics();
        this.shardPolicy = new DistributionKeyShardPolicy();
        this.recordSampleInterval = config.getRecordSampleInterval() * 1000000L;
        this.initTableShardCollector(config.getWriteThreadSize());
    }

    private void initTableShardCollector(int size) {
        this.pairArray = new TableShardCollector[size];
        for (int i = 0; i < this.pairArray.length; ++i) {
            this.pairArray[i] = new TableShardCollector(this.config, this.pool, this.stat, this.pairArray.length);
        }
        this.shardPolicy.init(size);
    }

    public void resize(int size) {
        if (this.pairArray.length != size) {
            this.initTableShardCollector(size);
        }
    }

    public long getByteSize() {
        return Arrays.stream(this.pairArray).collect(Collectors.summingLong(TableShardCollector::getByteSize));
    }

    public void append(Record record) throws HoloClientException {
        long nano = System.nanoTime();
        if (this.recordSampleInterval > 0L && nano - this.lastSampleTime > this.recordSampleInterval) {
            Object attachmentObj = null;
            try {
                if (record.getAttachmentList() != null && record.getAttachmentList().size() > 0) {
                    attachmentObj = record.getAttachmentList().get(0);
                }
                LOG.info("sample data: table name={}, record={}, attachObj={}", new Object[]{record.getSchema().getTableNameObj(), record, attachmentObj});
            }
            catch (Exception e) {
                LOG.warn("sample data fail", (Throwable)e);
            }
            this.lastSampleTime = nano;
        }
        int index = this.shardPolicy.locate(record);
        this.pairArray[index].append(record);
    }

    public boolean flush(boolean force) throws HoloClientException {
        return this.flush(force, true);
    }

    public boolean flush(boolean force, boolean async) throws HoloClientException {
        return this.flush(force, async, null);
    }

    public boolean flush(boolean force, boolean async, AtomicInteger uncommittedActionCount) throws HoloClientException {
        HoloClientWithDetailsException exception = null;
        int doneCount = 0;
        for (TableShardCollector pair : this.pairArray) {
            try {
                doneCount += pair.flush(force, async, uncommittedActionCount) ? 1 : 0;
            }
            catch (HoloClientWithDetailsException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.merge(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return doneCount == this.pairArray.length;
    }

    public int getShardCount() {
        return this.pairArray.length;
    }

    public CollectorStatistics getStat() {
        return this.stat;
    }
}

