/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.binlog;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayBuffer<T> {
    private T[] buffer;
    private int position;
    private int size;
    private boolean readable = false;
    private final Class<T[]> arrayClass;

    public ArrayBuffer(int initSize, Class<T[]> arrayClass) {
        this.arrayClass = arrayClass;
        this.buffer = (Object[])Array.newInstance(arrayClass.getComponentType(), initSize);
        this.position = 0;
        this.size = initSize;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public int getSize() {
        return this.size;
    }

    public int remain() {
        return this.size - this.position;
    }

    public T last() {
        if (this.remain() > 0) {
            return this.buffer[this.size - 1];
        }
        return null;
    }

    public T pop() {
        if (this.remain() > 0) {
            return this.buffer[this.position++];
        }
        return null;
    }

    public T peek() {
        if (this.remain() > 0) {
            return this.buffer[this.position];
        }
        return null;
    }

    public void add(T r) {
        if (this.remain() > 0) {
            this.buffer = Arrays.copyOf(this.buffer, Math.min(this.buffer.length + 1, this.buffer.length * 3 / 2), this.arrayClass);
            this.size = this.buffer.length;
        }
        this.buffer[this.position++] = r;
    }

    public void beginRead() {
        this.size = this.position;
        this.position = 0;
        this.readable = true;
    }

    public void beginWrite() {
        this.position = 0;
        this.size = this.buffer.length;
        this.readable = false;
    }

    public boolean isReadable() {
        return this.readable;
    }
}

