/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReader
implements Runnable {
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordReader.class);
    private static final int DEFAULT_MAX_CELL_BUFFER_SIZE = 0x200000;
    private static final int QUOTA = 34;
    private static final int ESCAPE = 92;
    private static final int DELIMITER = 44;
    private static final int NEWLINE = 10;
    private static final String NULL = "N";
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final TableSchema schema;
    private final int maxCellBufferSize;
    private final TimestampUtils timestampUtils;
    private final BlockingQueue<Record> queue;
    private final InputStream is;
    AtomicInteger numOpened;
    byte[] inputBuffer;
    int currentPos = 0;
    int bufferLen = 0;
    boolean closed = false;
    ByteBuffer cellBuffer = ByteBuffer.allocate(1024);
    Record currentRecord = null;
    int currentColumnIndex;
    boolean isInQuota = false;
    boolean isEscapeBefore = false;
    boolean isNull = false;

    public RecordReader(InputStream is, TableSchema schema, BlockingQueue<Record> queue, AtomicInteger numOpened, TimestampUtils timestampUtils) {
        this(is, schema, queue, numOpened, timestampUtils, 0x200000);
    }

    public RecordReader(InputStream is, TableSchema schema, BlockingQueue<Record> queue, AtomicInteger numOpened, TimestampUtils timestampUtils, int maxCellBufferSize) {
        this.is = is;
        this.schema = schema;
        this.queue = queue;
        this.maxCellBufferSize = maxCellBufferSize;
        this.numOpened = numOpened;
        this.inputBuffer = new byte[1024];
        this.timestampUtils = timestampUtils;
    }

    public Record getRecord() throws IOException {
        if (this.closed) {
            return null;
        }
        int r = this.readByte();
        Object ret = null;
        if (r == -1) {
            this.closed = true;
            this.numOpened.getAndDecrement();
            return null;
        }
        boolean recordEnd = false;
        while (!recordEnd) {
            if (this.isEscapeBefore) {
                this.write(r);
                this.isEscapeBefore = false;
            } else if (this.isInQuota) {
                switch (r) {
                    case 92: {
                        this.isEscapeBefore = true;
                        break;
                    }
                    case 34: {
                        this.isInQuota = false;
                        break;
                    }
                    default: {
                        this.write(r);
                        break;
                    }
                }
            } else {
                switch (r) {
                    case 92: {
                        this.isEscapeBefore = true;
                        break;
                    }
                    case 34: {
                        this.isInQuota = true;
                        break;
                    }
                    case 44: {
                        this.fillRecord();
                        break;
                    }
                    case 10: {
                        this.fillRecord();
                        recordEnd = true;
                        break;
                    }
                    default: {
                        this.write(r);
                    }
                }
            }
            if (recordEnd) continue;
            r = this.readByte();
        }
        Record temp = this.currentRecord;
        this.currentRecord = new Record(this.schema);
        this.currentColumnIndex = 0;
        return temp;
    }

    private void fillRecord() throws IOException {
        this.cellBuffer.flip();
        if (this.currentRecord == null) {
            this.currentRecord = new Record(this.schema);
        }
        Column column = this.schema.getColumn(this.currentColumnIndex);
        int type = column.getType();
        if (this.cellBuffer.remaining() == 0) {
            switch (type) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    this.currentRecord.setObject(this.currentColumnIndex, "");
                    break;
                }
                default: {
                    this.currentRecord.setObject(this.currentColumnIndex, null);
                    break;
                }
            }
        } else {
            byte[] temp = null;
            String text = null;
            try {
                temp = new byte[this.cellBuffer.remaining()];
                this.cellBuffer.get(temp);
                text = new String(temp, UTF8);
                if (text.equals(NULL)) {
                    this.currentRecord.setObject(this.currentColumnIndex, null);
                } else {
                    switch (type) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2003: 
                        case 2005: 
                        case 2011: {
                            this.currentRecord.setObject(this.currentColumnIndex, text);
                            break;
                        }
                        case 92: 
                        case 2013: {
                            this.currentRecord.setObject(this.currentColumnIndex, this.timestampUtils.toTime(null, text));
                            break;
                        }
                        case 91: {
                            this.currentRecord.setObject(this.currentColumnIndex, this.timestampUtils.toDate(null, text));
                            break;
                        }
                        case 93: 
                        case 2014: {
                            this.currentRecord.setObject(this.currentColumnIndex, this.timestampUtils.toTimestamp(null, text));
                            break;
                        }
                        case 5: {
                            this.currentRecord.setObject(this.currentColumnIndex, Short.parseShort(text));
                            break;
                        }
                        case 4: {
                            this.currentRecord.setObject(this.currentColumnIndex, Integer.parseInt(text));
                            break;
                        }
                        case -5: {
                            this.currentRecord.setObject(this.currentColumnIndex, Long.parseLong(text));
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.currentRecord.setObject(this.currentColumnIndex, new BigDecimal(text));
                            break;
                        }
                        case 6: 
                        case 7: {
                            this.currentRecord.setObject(this.currentColumnIndex, Float.valueOf(Float.parseFloat(text)));
                            break;
                        }
                        case 8: {
                            this.currentRecord.setObject(this.currentColumnIndex, Double.parseDouble(text));
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 1111: 
                        case 2004: {
                            byte[] temp2 = new byte[temp.length];
                            System.arraycopy(temp, 0, temp2, 0, temp.length);
                            this.currentRecord.setObject(this.currentColumnIndex, temp2);
                            break;
                        }
                        case -7: 
                        case 16: {
                            this.currentRecord.setObject(this.currentColumnIndex, Boolean.parseBoolean(text));
                            break;
                        }
                        default: {
                            throw new IOException("unsupported type " + type + " type name:" + column.getTypeName());
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("fill column " + column.getName() + " fail.index:" + this.currentRecord + " record:" + this.currentRecord + ", bytes:" + (temp != null ? Arrays.toString(temp) : "null") + ", text:" + text, e);
            }
        }
        this.cellBuffer.clear();
        ++this.currentColumnIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(int r) throws IOException {
        if (this.cellBuffer.remaining() == 0) {
            if (this.cellBuffer.position() >= 0x200000) throw new IOException("RecordInputStream cellBuffer exceed max cell size " + this.maxCellBufferSize + " for column " + this.schema.getColumn(this.currentColumnIndex).getName());
            int target = Math.min(this.cellBuffer.position() * 2, this.maxCellBufferSize);
            ByteBuffer temp = ByteBuffer.allocate(target);
            temp.put(this.cellBuffer);
            this.cellBuffer.clear();
            this.cellBuffer = temp;
            return;
        } else {
            this.cellBuffer.put((byte)(r & 0xFF));
        }
    }

    private int readByte() throws IOException {
        if (this.currentPos >= this.bufferLen) {
            this.bufferLen = this.is.read(this.inputBuffer, 0, 1024);
            this.currentPos = 0;
            if (this.bufferLen == -1) {
                return -1;
            }
        }
        byte content = this.inputBuffer[this.currentPos++];
        return content & 0xFF;
    }

    @Override
    public void run() {
        try {
            Record r;
            while ((r = this.getRecord()) != null) {
                this.queue.put(r);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

