/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client;

import com.alibaba.hologres.client.model.TableSchema;
import java.io.OutputStream;
import java.security.InvalidParameterException;

public class Exporter {
    private TableSchema schema;
    int startShardId = -1;
    int endShardId = -1;
    OutputStream os;
    int threadSize = 1;

    Exporter(TableSchema schema, int startShardId, int endShardId, OutputStream os, int threadSize) {
        this.schema = schema;
        this.startShardId = startShardId;
        this.endShardId = endShardId;
        this.os = os;
        this.threadSize = threadSize;
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public int getStartShardId() {
        return this.startShardId;
    }

    public int getEndShardId() {
        return this.endShardId;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public int getThreadSize() {
        return this.threadSize;
    }

    public static Builder newBuilder(TableSchema schema) {
        return new Builder(schema);
    }

    public static class Builder {
        private TableSchema schema;
        int startShardId = -1;
        int endShardId = -1;
        OutputStream os;
        int threadSize = 1;

        public Builder(TableSchema schema) {
            this.schema = schema;
        }

        public Builder setShardRange(int shardId) {
            this.setShardRange(shardId, shardId + 1);
            return this;
        }

        public Builder setShardRange(int startShardId, int endShardId) {
            if (endShardId <= startShardId) {
                throw new InvalidParameterException("startShardId must less then endShardId");
            }
            this.startShardId = startShardId;
            this.endShardId = endShardId;
            return this;
        }

        public Builder setOutputStream(OutputStream os) {
            this.os = os;
            this.threadSize = 1;
            return this;
        }

        public Builder setThreadSize(int threadSize) {
            if (this.os == null) {
                this.threadSize = threadSize;
            }
            return this;
        }

        public Exporter build() {
            return new Exporter(this.schema, this.startShardId, this.endShardId, this.os, this.threadSize);
        }
    }
}

