/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.dataformat;

import com.alibaba.blink.dataformat.BinaryRow;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public final class BinaryRowSet {
    public static int VERSION = 0;
    private int fieldCount;
    private MemorySegment segment;
    private List<BinaryRow> rows;

    public BinaryRowSet(int fieldCount) {
        this.fieldCount = fieldCount;
    }

    public BinaryRow GetRow(int index) {
        return this.rows.get(index);
    }

    public int size() {
        return this.rows.size();
    }

    public int bytesCount() {
        return this.segment.size();
    }

    public void Deserialize(byte[] bytes) {
        if (bytes.length < 8) {
            throw new IllegalStateException("invalid buffer");
        }
        IntBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int version = buffer.get(0);
        if (version != VERSION) {
            throw new IllegalStateException("version mismatch, expected: " + VERSION + ", actual: " + version);
        }
        int rowCount = buffer.get(1);
        this.segment = MemorySegmentFactory.wrap(bytes);
        this.rows = new ArrayList<BinaryRow>();
        for (int i = 0; i < rowCount; ++i) {
            int offsetNext;
            int offset = buffer.get(2 + i);
            int n = offsetNext = i == rowCount - 1 ? bytes.length : buffer.get(3 + i);
            if (offset > offsetNext) {
                throw new IllegalStateException("invalid offset in pos " + i + ", offset=" + offset + ", offsetNext=" + offsetNext);
            }
            BinaryRow row = new BinaryRow(this.fieldCount);
            row.pointTo(this.segment, offset, offsetNext - offset);
            this.rows.add(row);
        }
    }
}

