/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

class ObjectReaderImplGenericArray
implements ObjectReader {
    final Type itemType;
    final Class<?> componentClass;
    ObjectReader itemObjectReader;

    public ObjectReaderImplGenericArray(GenericArrayType genericType) {
        this.itemType = genericType.getGenericComponentType();
        this.componentClass = TypeUtils.getMapping(this.itemType);
    }

    public Object createInstance(long features) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        int entryCnt = jsonReader.startArray();
        if (entryCnt > 0 && this.itemObjectReader == null) {
            this.itemObjectReader = jsonReader.getContext().getObjectReader(this.itemType);
        }
        Object array = Array.newInstance(this.componentClass, entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            Object item = this.itemObjectReader.readJSONBObject(jsonReader, 0L);
            Array.set(array, i, item);
        }
        return array;
    }

    public Object readObject(JSONReader jsonReader, long features) {
        if (this.itemObjectReader == null) {
            this.itemObjectReader = jsonReader.getContext().getObjectReader(this.itemType);
        }
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        char ch = jsonReader.current();
        if (ch == '\"') {
            String str = jsonReader.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw new JSONException(jsonReader.info());
        }
        ArrayList list = new ArrayList();
        if (ch != '[') {
            throw new JSONException(jsonReader.info());
        }
        jsonReader.next();
        while (!jsonReader.nextIfMatch(']')) {
            Object item;
            if (this.itemObjectReader != null) {
                item = this.itemObjectReader.readObject(jsonReader, 0L);
            } else if (this.itemType == String.class) {
                item = jsonReader.readString();
            } else {
                throw new JSONException(jsonReader.info("TODO : " + this.itemType));
            }
            list.add(item);
            if (!jsonReader.nextIfMatch(',')) continue;
        }
        jsonReader.nextIfMatch(',');
        Object array = Array.newInstance(this.componentClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }
}

