// ASM: a very small and fast Java bytecode manipulation framework
// Copyright (c) 2000-2011 INRIA, France Telecom
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the copyright holders nor the names of its
//    contributors may be used to endorse or promote products derived from
//    this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
// THE POSSIBILITY OF SUCH DAMAGE.
package com.alibaba.fastjson2.internal.asm;

/**
 * @author Eric Bruneton
 */
public final class FieldWriter {
    protected FieldWriter fv;

    /**
     * Where the constants used in this FieldWriter must be stored.
     */
    private final SymbolTable symbolTable;

    // Note: fields are ordered as in the field_info structure, and those related to attributes are
    // ordered as in Section 4.7 of the JVMS.

    private final int accessFlags;

    /**
     * The name_index field of the field_info JVMS structure.
     */
    private final int nameIndex;

    /**
     * The descriptor_index field of the field_info JVMS structure.
     */
    private final int descriptorIndex;

    /**
     * Constructs a new {@link FieldWriter}.
     *
     * @param symbolTable where the constants used in this FieldWriter must be stored.
     * @param access      the field's access flags (see {@link Opcodes}).
     * @param name        the field's name.
     * @param descriptor  the field's descriptor (see {@link Type}).
     */
    FieldWriter(
            final SymbolTable symbolTable,
            final int access,
            final String name,
            final String descriptor) {
        this.symbolTable = symbolTable;
        this.accessFlags = access;
        this.nameIndex = symbolTable.addConstantUtf8(name);
        this.descriptorIndex = symbolTable.addConstantUtf8(descriptor);
    }

    public void visitEnd() {
    }

    /**
     * Puts the content of the field_info JVMS structure generated by this FieldWriter into the given
     * ByteVector.
     *
     * @param output where the field_info structure must be put.
     */
    void putFieldInfo(final ByteVector output) {
        // Put the access_flags, name_index and descriptor_index fields.
        int mask = 0;
        output.putShort(accessFlags & ~mask).putShort(nameIndex).putShort(descriptorIndex);
        // Compute and put the attributes_count field.
        // For ease of reference, we use here the same attribute order as in Section 4.7 of the JVMS.
        int attributesCount = 0;
        output.putShort(attributesCount);
    }
}
