/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class JSONWriterUTF8JDK9
extends JSONWriterUTF8 {
    JSONWriterUTF8JDK9(JSONWriter.Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        byte c1;
        byte c0;
        int minCapacity;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        byte[] value = null;
        byte coder = 1;
        if (JDKUtils.UNSAFE_SUPPORT && (coder = UnsafeUtils.getStringCoder(str)) == 0) {
            value = UnsafeUtils.getStringValue(str);
        }
        if (value == null) {
            value = str.getBytes(StandardCharsets.UTF_8);
        }
        if ((minCapacity = this.off + value.length * 3 + 2) - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        boolean special = false;
        int i = 0;
        while (i + 4 <= value.length) {
            c0 = value[i];
            c1 = value[i + 1];
            byte c2 = value[i + 2];
            byte c3 = value[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c0 < 32 || c1 < 32 || c2 < 32 || c3 < 32) {
                special = true;
                break;
            }
            i += 4;
        }
        if (!special && i + 2 <= value.length) {
            c0 = value[i];
            c1 = value[i + 1];
            if (c0 == this.quote || c1 == this.quote || c0 == 92 || c1 == 92 || c0 < 32 || c1 < 32) {
                special = true;
            } else {
                i += 2;
            }
        }
        if (!special && i + 1 == value.length) {
            c0 = value[i];
            boolean bl = special = c0 == this.quote || c0 == 92 || c0 < 32;
        }
        if (!special) {
            System.arraycopy(value, 0, this.bytes, this.off, value.length);
            this.off += value.length;
        } else {
            for (i = 0; i < value.length; ++i) {
                byte ch = value[i];
                if (ch == this.quote) {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = (byte)this.quote;
                    continue;
                }
                if (ch == 92) {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 92;
                    continue;
                }
                if (ch == 10) {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 110;
                    continue;
                }
                if (ch == 13) {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 114;
                    continue;
                }
                if (ch == 12) {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 102;
                    continue;
                }
                if (ch == 8) {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 98;
                    continue;
                }
                if (ch == 9) {
                    this.bytes[this.off++] = 92;
                    this.bytes[this.off++] = 116;
                    continue;
                }
                if (coder == 0 && ch < 0) {
                    int c = ch & 0xFF;
                    this.bytes[this.off++] = (byte)(0xC0 | c >> 6);
                    this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                this.bytes[this.off++] = ch;
            }
        }
        this.bytes[this.off++] = (byte)this.quote;
    }
}

