/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONCompiler;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.modules.ObjectWriterAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.support.LambdaMiscCodec;
import com.alibaba.fastjson2.support.money.MoneySupport;
import com.alibaba.fastjson2.util.ApacheLang3Support;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.JodaSupport;
import com.alibaba.fastjson2.util.KotlinUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriter4;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterArray;
import com.alibaba.fastjson2.writer.ObjectWriterArrayFinal;
import com.alibaba.fastjson2.writer.ObjectWriterBigInteger;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterImpDecimalArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicBoolean;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicInteger;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicIntegerArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicLong;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicLongArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicReference;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplBitSet;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolean;
import com.alibaba.fastjson2.writer.ObjectWriterImplCalendar;
import com.alibaba.fastjson2.writer.ObjectWriterImplCharValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplCharacter;
import com.alibaba.fastjson2.writer.ObjectWriterImplClass;
import com.alibaba.fastjson2.writer.ObjectWriterImplCollection;
import com.alibaba.fastjson2.writer.ObjectWriterImplCurrency;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplDouble;
import com.alibaba.fastjson2.writer.ObjectWriterImplDoubleValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloat;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloatValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInstant;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt16;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt16ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplJSONP;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import com.alibaba.fastjson2.writer.ObjectWriterImplListStr;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocale;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterImplMapEntry;
import com.alibaba.fastjson2.writer.ObjectWriterImplOffsetDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplOffsetTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptional;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalDouble;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalInt;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalLong;
import com.alibaba.fastjson2.writer.ObjectWriterImplString;
import com.alibaba.fastjson2.writer.ObjectWriterImplStringArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplTimeZone;
import com.alibaba.fastjson2.writer.ObjectWriterImplToString;
import com.alibaba.fastjson2.writer.ObjectWriterImplUUID;
import com.alibaba.fastjson2.writer.ObjectWriterImplZonedDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterMisc;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import com.alibaba.fastjson2.writer.ObjectWriters;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectWriterBaseModule
implements ObjectWriterModule {
    static ObjectWriterAdapter STACK_TRACE_ELEMENT_WRITER;
    final ObjectWriterProvider provider;
    final WriterAnnotationProcessor annotationProcessor;

    public ObjectWriterBaseModule(ObjectWriterProvider provider) {
        this.provider = provider;
        this.annotationProcessor = new WriterAnnotationProcessor();
    }

    @Override
    public ObjectWriterProvider getProvider() {
        return this.provider;
    }

    @Override
    public ObjectWriterAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    ObjectWriter getExternalObjectWriter(String className, Class objectClass) {
        switch (className) {
            case "java.sql.Time": {
                return JdbcSupport.createTimeWriter(null);
            }
            case "java.sql.Timestamp": {
                return JdbcSupport.createTimestampWriter(objectClass, null);
            }
            case "org.joda.time.chrono.GregorianChronology": {
                return JodaSupport.createGregorianChronologyWriter(objectClass);
            }
            case "org.joda.time.chrono.ISOChronology": {
                return JodaSupport.createISOChronologyWriter(objectClass);
            }
            case "org.joda.time.LocalDate": {
                return JodaSupport.createLocalDateWriter(objectClass, null);
            }
            case "org.joda.time.LocalDateTime": {
                return JodaSupport.createLocalDateTimeWriter(objectClass, null);
            }
            case "org.joda.time.DateTime": {
                return new ObjectWriterImplZonedDateTime(null, null, new JodaSupport.DateTime2ZDT());
            }
        }
        if (JdbcSupport.isClob(objectClass)) {
            return JdbcSupport.createClobWriter(objectClass);
        }
        return null;
    }

    @Override
    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        String className;
        ObjectWriter externalObjectWriter;
        if (objectType == String.class) {
            return ObjectWriterImplString.INSTANCE;
        }
        if (objectClass == null) {
            objectClass = objectType instanceof Class ? (Class)objectType : TypeUtils.getMapping(objectType);
        }
        if ((externalObjectWriter = this.getExternalObjectWriter(className = objectClass.getName(), objectClass)) != null) {
            return externalObjectWriter;
        }
        switch (className) {
            case "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList": 
            case "com.google.common.collect.AbstractMapBasedMultimap$WrappedSet": {
                return null;
            }
            case "org.javamoney.moneta.internal.JDKCurrencyAdapter": {
                return ObjectWriterImplToString.INSTANCE;
            }
            case "com.fasterxml.jackson.databind.node.ObjectNode": {
                return ObjectWriterImplToString.DIRECT;
            }
            case "org.javamoney.moneta.Money": {
                return MoneySupport.createMonetaryAmountWriter();
            }
            case "org.javamoney.moneta.spi.DefaultNumberValue": {
                return MoneySupport.createNumberValueWriter();
            }
            case "net.sf.json.JSONNull": 
            case "java.net.Inet4Address": 
            case "java.net.Inet6Address": 
            case "java.net.InetSocketAddress": 
            case "java.text.SimpleDateFormat": 
            case "java.util.regex.Pattern": 
            case "com.fasterxml.jackson.databind.node.ArrayNode": {
                return ObjectWriterMisc.INSTANCE;
            }
            case "org.apache.commons.lang3.tuple.Pair": 
            case "org.apache.commons.lang3.tuple.MutablePair": 
            case "org.apache.commons.lang3.tuple.ImmutablePair": {
                return new ApacheLang3Support.PairWriter(objectClass);
            }
            case "com.carrotsearch.hppc.ByteArrayList": 
            case "com.carrotsearch.hppc.ShortArrayList": 
            case "com.carrotsearch.hppc.IntArrayList": 
            case "com.carrotsearch.hppc.IntHashSet": 
            case "com.carrotsearch.hppc.LongArrayList": 
            case "com.carrotsearch.hppc.LongHashSet": 
            case "com.carrotsearch.hppc.CharArrayList": 
            case "com.carrotsearch.hppc.CharHashSet": 
            case "com.carrotsearch.hppc.FloatArrayList": 
            case "com.carrotsearch.hppc.DoubleArrayList": 
            case "com.carrotsearch.hppc.BitSet": 
            case "gnu.trove.list.array.TByteArrayList": 
            case "gnu.trove.list.array.TCharArrayList": 
            case "gnu.trove.list.array.TShortArrayList": 
            case "gnu.trove.list.array.TIntArrayList": 
            case "gnu.trove.list.array.TLongArrayList": 
            case "gnu.trove.list.array.TFloatArrayList": 
            case "gnu.trove.list.array.TDoubleArrayList": 
            case "gnu.trove.set.hash.TByteHashSet": 
            case "gnu.trove.set.hash.TShortHashSet": 
            case "gnu.trove.set.hash.TIntHashSet": 
            case "gnu.trove.set.hash.TLongHashSet": 
            case "gnu.trove.stack.array.TByteArrayStack": 
            case "org.bson.types.Decimal128": {
                return LambdaMiscCodec.getObjectWriter(objectType, objectClass);
            }
            case "java.nio.HeapByteBuffer": 
            case "java.nio.DirectByteBuffer": {
                return new ObjectWriterImplInt8ValueArray(o -> ((ByteBuffer)o).array());
            }
            case "java.awt.Color": {
                try {
                    List<FieldWriter> fieldWriters = Arrays.asList(ObjectWriters.fieldWriter("r", objectClass.getMethod("getRed", new Class[0])), ObjectWriters.fieldWriter("g", objectClass.getMethod("getGreen", new Class[0])), ObjectWriters.fieldWriter("b", objectClass.getMethod("getBlue", new Class[0])), ObjectWriters.fieldWriter("alpha", objectClass.getMethod("getAlpha", new Class[0])));
                    return new ObjectWriter4(objectClass, null, null, 0L, fieldWriters);
                }
                catch (NoSuchMethodException fieldWriters) {
                    // empty catch block
                }
            }
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (rawType == List.class || rawType == ArrayList.class) {
                if (actualTypeArguments.length == 1 && actualTypeArguments[0] == String.class) {
                    return ObjectWriterImplListStr.INSTANCE;
                }
                objectType = rawType;
            }
            if (Map.class.isAssignableFrom(objectClass)) {
                return ObjectWriterImplMap.of(objectType, objectClass);
            }
            if (objectClass == Optional.class && actualTypeArguments.length == 1) {
                return new ObjectWriterImplOptional(actualTypeArguments[0], null, null);
            }
        }
        if (objectType == LinkedList.class) {
            return ObjectWriterImplList.INSTANCE;
        }
        if (objectType == ArrayList.class || objectType == List.class || List.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplList.INSTANCE;
        }
        if (Collection.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplCollection.INSTANCE;
        }
        if (BeanUtils.isExtendedMap(objectClass)) {
            return null;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplMap.of(objectClass);
        }
        if (Map.Entry.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplMapEntry.INSTANCE;
        }
        if (Path.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplToString.INSTANCE;
        }
        if (objectType == Integer.class) {
            return ObjectWriterImplInt32.INSTANCE;
        }
        if (objectType == AtomicInteger.class) {
            return ObjectWriterImplAtomicInteger.INSTANCE;
        }
        if (objectType == Byte.class) {
            return ObjectWriterImplInt8.INSTANCE;
        }
        if (objectType == Short.class) {
            return ObjectWriterImplInt16.INSTANCE;
        }
        if (objectType == Long.class) {
            return ObjectWriterImplInt64.INSTANCE;
        }
        if (objectType == AtomicLong.class) {
            return ObjectWriterImplAtomicLong.INSTANCE;
        }
        if (objectType == AtomicReference.class) {
            return ObjectWriterImplAtomicReference.INSTANCE;
        }
        if (objectType == Float.class) {
            return ObjectWriterImplFloat.INSTANCE;
        }
        if (objectType == Double.class) {
            return ObjectWriterImplDouble.INSTANCE;
        }
        if (objectType == BigInteger.class) {
            return ObjectWriterBigInteger.INSTANCE;
        }
        if (objectType == BigDecimal.class) {
            return ObjectWriterImplBigDecimal.INSTANCE;
        }
        if (objectType == BitSet.class) {
            return ObjectWriterImplBitSet.INSTANCE;
        }
        if (objectType == OptionalInt.class) {
            return ObjectWriterImplOptionalInt.INSTANCE;
        }
        if (objectType == OptionalLong.class) {
            return ObjectWriterImplOptionalLong.INSTANCE;
        }
        if (objectType == OptionalDouble.class) {
            return ObjectWriterImplOptionalDouble.INSTANCE;
        }
        if (objectType == Optional.class) {
            return ObjectWriterImplOptional.INSTANCE;
        }
        if (objectType == Boolean.class) {
            return ObjectWriterImplBoolean.INSTANCE;
        }
        if (objectType == AtomicBoolean.class) {
            return ObjectWriterImplAtomicBoolean.INSTANCE;
        }
        if (objectType == AtomicIntegerArray.class) {
            return ObjectWriterImplAtomicIntegerArray.INSTANCE;
        }
        if (objectType == AtomicLongArray.class) {
            return ObjectWriterImplAtomicLongArray.INSTANCE;
        }
        if (objectType == Character.class) {
            return ObjectWriterImplCharacter.INSTANCE;
        }
        if (objectType instanceof Class) {
            ObjectWriter enumWriter;
            Class clazz = (Class)objectType;
            if (TimeUnit.class.isAssignableFrom(clazz)) {
                return new ObjectWriterImplEnum(null, TimeUnit.class, null, null, 0L);
            }
            if (Enum.class.isAssignableFrom(clazz) && (enumWriter = this.createEnumWriter(clazz)) != null) {
                return enumWriter;
            }
            if (JSONPath.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplToString.INSTANCE;
            }
            if (clazz == boolean[].class) {
                return ObjectWriterImplBoolValueArray.INSTANCE;
            }
            if (clazz == char[].class) {
                return ObjectWriterImplCharValueArray.INSTANCE;
            }
            if (clazz == StringBuffer.class || clazz == StringBuilder.class) {
                return ObjectWriterImplToString.INSTANCE;
            }
            if (clazz == byte[].class) {
                return ObjectWriterImplInt8ValueArray.INSTANCE;
            }
            if (clazz == short[].class) {
                return ObjectWriterImplInt16ValueArray.INSTANCE;
            }
            if (clazz == int[].class) {
                return ObjectWriterImplInt32ValueArray.INSTANCE;
            }
            if (clazz == long[].class) {
                return ObjectWriterImplInt64ValueArray.INSTANCE;
            }
            if (clazz == float[].class) {
                return ObjectWriterImplFloatValueArray.INSTANCE;
            }
            if (clazz == double[].class) {
                return ObjectWriterImplDoubleValueArray.INSTANCE;
            }
            if (clazz == Byte[].class) {
                return ObjectWriterImplInt8Array.INSTANCE;
            }
            if (clazz == Integer[].class) {
                return ObjectWriterImplInt32Array.INSTANCE;
            }
            if (clazz == Long[].class) {
                return ObjectWriterImplInt64Array.INSTANCE;
            }
            if (String[].class == clazz) {
                return ObjectWriterImplStringArray.INSTANCE;
            }
            if (BigDecimal[].class == clazz) {
                return ObjectWriterImpDecimalArray.INSTANCE;
            }
            if (Object[].class.isAssignableFrom(clazz)) {
                if (clazz == Object[].class) {
                    return ObjectWriterArray.INSTANCE;
                }
                Class<?> componentType = clazz.getComponentType();
                if (Modifier.isFinal(componentType.getModifiers())) {
                    return new ObjectWriterArrayFinal(componentType, null);
                }
                return new ObjectWriterArray(componentType);
            }
            if (clazz == UUID.class) {
                return ObjectWriterImplUUID.INSTANCE;
            }
            if (clazz == Locale.class) {
                return ObjectWriterImplLocale.INSTANCE;
            }
            if (clazz == Currency.class) {
                return ObjectWriterImplCurrency.INSTANCE;
            }
            if (TimeZone.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplTimeZone.INSTANCE;
            }
            if (JSONPObject.class.isAssignableFrom(clazz)) {
                return new ObjectWriterImplJSONP();
            }
            if (clazz == URI.class || clazz == URL.class || clazz == File.class || ZoneId.class.isAssignableFrom(clazz) || Charset.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplToString.INSTANCE;
            }
            externalObjectWriter = this.getExternalObjectWriter(clazz.getName(), clazz);
            if (externalObjectWriter != null) {
                return externalObjectWriter;
            }
            BeanInfo beanInfo = this.provider.createBeanInfo();
            Class mixIn = this.provider.getMixIn(clazz);
            if (mixIn != null) {
                this.annotationProcessor.getBeanInfo(beanInfo, mixIn);
            }
            if (Date.class.isAssignableFrom(clazz)) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplDate(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplDate.INSTANCE;
            }
            if (Calendar.class.isAssignableFrom(clazz)) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplCalendar(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplCalendar.INSTANCE;
            }
            if (ZonedDateTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplZonedDateTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplZonedDateTime.INSTANCE;
            }
            if (OffsetDateTime.class == clazz) {
                return ObjectWriterImplOffsetDateTime.of(beanInfo.format, beanInfo.locale);
            }
            if (LocalDateTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplLocalDateTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplLocalDateTime.INSTANCE;
            }
            if (LocalDate.class == clazz) {
                return ObjectWriterImplLocalDate.of(beanInfo.format, beanInfo.locale);
            }
            if (LocalTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplLocalTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplLocalTime.INSTANCE;
            }
            if (OffsetTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplOffsetTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplOffsetTime.INSTANCE;
            }
            if (Instant.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplInstant(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplInstant.INSTANCE;
            }
            if (Duration.class == clazz || Period.class == clazz) {
                return ObjectWriterImplToString.INSTANCE;
            }
            if (StackTraceElement.class == clazz) {
                if (STACK_TRACE_ELEMENT_WRITER == null) {
                    ObjectWriterCreator creator = this.provider.getCreator();
                    STACK_TRACE_ELEMENT_WRITER = new ObjectWriterAdapter<StackTraceElement>(StackTraceElement.class, null, null, 0L, Arrays.asList(creator.createFieldWriter("fileName", String.class, BeanUtils.getDeclaredField(StackTraceElement.class, "fileName"), BeanUtils.getMethod(StackTraceElement.class, "getFileName"), StackTraceElement::getFileName), creator.createFieldWriter("lineNumber", BeanUtils.getDeclaredField(StackTraceElement.class, "lineNumber"), BeanUtils.getMethod(StackTraceElement.class, "getLineNumber"), StackTraceElement::getLineNumber), creator.createFieldWriter("className", String.class, BeanUtils.getDeclaredField(StackTraceElement.class, "declaringClass"), BeanUtils.getMethod(StackTraceElement.class, "getClassName"), StackTraceElement::getClassName), creator.createFieldWriter("methodName", String.class, BeanUtils.getDeclaredField(StackTraceElement.class, "methodName"), BeanUtils.getMethod(StackTraceElement.class, "getMethodName"), StackTraceElement::getMethodName)));
                }
                return STACK_TRACE_ELEMENT_WRITER;
            }
            if (Class.class == clazz) {
                return ObjectWriterImplClass.INSTANCE;
            }
            if (Method.class == clazz) {
                return new ObjectWriterAdapter<Method>(Method.class, null, null, 0L, Arrays.asList(ObjectWriters.fieldWriter("declaringClass", Class.class, Method::getDeclaringClass), ObjectWriters.fieldWriter("name", String.class, Method::getName), ObjectWriters.fieldWriter("parameterTypes", Class[].class, Method::getParameterTypes)));
            }
            if (Field.class == clazz) {
                return new ObjectWriterAdapter<Method>(Method.class, null, null, 0L, Arrays.asList(ObjectWriters.fieldWriter("declaringClass", Class.class, Field::getDeclaringClass), ObjectWriters.fieldWriter("name", String.class, Field::getName)));
            }
            if (ParameterizedType.class.isAssignableFrom(clazz)) {
                return ObjectWriters.objectWriter(ParameterizedType.class, ObjectWriters.fieldWriter("actualTypeArguments", Type[].class, ParameterizedType::getActualTypeArguments), ObjectWriters.fieldWriter("ownerType", Type.class, ParameterizedType::getOwnerType), ObjectWriters.fieldWriter("rawType", Type.class, ParameterizedType::getRawType));
            }
        }
        return null;
    }

    private ObjectWriter createEnumWriter(Class enumClass) {
        Member valueField;
        Class superclass;
        if (!enumClass.isEnum() && (superclass = enumClass.getSuperclass()).isEnum()) {
            enumClass = superclass;
        }
        if ((valueField = BeanUtils.getEnumValueField(enumClass, this.provider)) == null) {
            Class mixInSource = (Class)this.provider.mixInCache.get(enumClass);
            Member mixedValueField = BeanUtils.getEnumValueField(mixInSource, this.provider);
            if (mixedValueField instanceof Field) {
                try {
                    valueField = enumClass.getField(mixedValueField.getName());
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else if (mixedValueField instanceof Method) {
                try {
                    valueField = enumClass.getMethod(mixedValueField.getName(), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        BeanInfo beanInfo = this.provider.createBeanInfo();
        Class<?>[] interfaces = enumClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.annotationProcessor.getBeanInfo(beanInfo, interfaces[i]);
        }
        this.annotationProcessor.getBeanInfo(beanInfo, enumClass);
        if (beanInfo.writeEnumAsJavaBean) {
            return null;
        }
        String[] annotationNames = BeanUtils.getEnumAnnotationNames(enumClass);
        return new ObjectWriterImplEnum(null, enumClass, valueField, annotationNames, 0L);
    }

    public class WriterAnnotationProcessor
    implements ObjectWriterAnnotationProcessor {
        @Override
        public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
            Class mixInSource;
            if (objectClass != null) {
                Class<?>[] interfaces;
                Class superclass = objectClass.getSuperclass();
                if (superclass != Object.class && superclass != null && superclass != Enum.class) {
                    this.getBeanInfo(beanInfo, superclass);
                }
                for (Class<?> item : interfaces = objectClass.getInterfaces()) {
                    if (item == Serializable.class) continue;
                    this.getBeanInfo(beanInfo, item);
                }
                if (beanInfo.seeAlso != null && beanInfo.seeAlsoNames != null) {
                    for (int i = 0; i < beanInfo.seeAlso.length; ++i) {
                        String seeAlsoName;
                        Class seeAlso = beanInfo.seeAlso[i];
                        if (seeAlso != objectClass || i >= beanInfo.seeAlsoNames.length || (seeAlsoName = beanInfo.seeAlsoNames[i]) == null || seeAlsoName.length() == 0) continue;
                        beanInfo.typeName = seeAlsoName;
                        break;
                    }
                }
            }
            Annotation jsonType1x = null;
            JSONType jsonType = null;
            Annotation[] annotations = BeanUtils.getAnnotations(objectClass);
            block26: for (int i = 0; i < annotations.length; ++i) {
                JSONCompiler compiler;
                Annotation annotation = annotations[i];
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (jsonType == null) {
                    jsonType = BeanUtils.findAnnotation(annotation, JSONType.class);
                }
                if (jsonType == annotation) continue;
                if (annotationType == JSONCompiler.class && (compiler = (JSONCompiler)annotation).value() == JSONCompiler.CompilerOption.LAMBDA) {
                    beanInfo.writerFeatures |= 0x40000000000000L;
                }
                boolean useJacksonAnnotation = JSONFactory.isUseJacksonAnnotation();
                switch (annotationType.getName()) {
                    case "com.alibaba.fastjson.annotation.JSONType": {
                        jsonType1x = annotation;
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonIgnoreProperties": {
                        if (!useJacksonAnnotation) continue block26;
                        this.processJacksonJsonIgnoreProperties(beanInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonPropertyOrder": {
                        if (!useJacksonAnnotation) continue block26;
                        this.processJacksonJsonPropertyOrder(beanInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonFormat": {
                        if (!useJacksonAnnotation) continue block26;
                        BeanUtils.processJacksonJsonFormat(beanInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonInclude": {
                        if (!useJacksonAnnotation) continue block26;
                        BeanUtils.processJacksonJsonInclude(beanInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonTypeInfo": {
                        if (!useJacksonAnnotation) continue block26;
                        this.processJacksonJsonTypeInfo(beanInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.databind.annotation.JsonSerialize": {
                        if (!useJacksonAnnotation) continue block26;
                        this.processJacksonJsonSerialize(beanInfo, annotation);
                        if (beanInfo.serializer == null || !Enum.class.isAssignableFrom(objectClass)) continue block26;
                        beanInfo.writeEnumAsJavaBean = true;
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonTypeName": {
                        if (!useJacksonAnnotation) continue block26;
                        BeanUtils.processJacksonJsonTypeName(beanInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonSubTypes": {
                        if (!useJacksonAnnotation) continue block26;
                        this.processJacksonJsonSubTypes(beanInfo, annotation);
                        continue block26;
                    }
                    case "kotlin.Metadata": {
                        beanInfo.kotlin = true;
                        KotlinUtils.getConstructor(objectClass, beanInfo);
                        continue block26;
                    }
                }
            }
            if (jsonType == null && (mixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(objectClass)) != null) {
                beanInfo.mixIn = true;
                Annotation[] mixInAnnotations = BeanUtils.getAnnotations(mixInSource);
                for (int i = 0; i < mixInAnnotations.length; ++i) {
                    String annotationTypeName;
                    Annotation annotation = mixInAnnotations[i];
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    jsonType = BeanUtils.findAnnotation(annotation, JSONType.class);
                    if (jsonType == annotation || !"com.alibaba.fastjson.annotation.JSONType".equals(annotationTypeName = annotationType.getName())) continue;
                    jsonType1x = annotation;
                }
            }
            if (jsonType != null) {
                String rootName;
                String[] parts;
                String locale;
                String format;
                Class<? extends Filter>[] serializeFilters;
                Class<?> serializer;
                String[] orders;
                String[] includes;
                String typeName;
                String typeKey;
                Class<?>[] classes = jsonType.seeAlso();
                if (classes.length != 0) {
                    beanInfo.seeAlso = classes;
                }
                if (!(typeKey = jsonType.typeKey()).isEmpty()) {
                    beanInfo.typeKey = typeKey;
                }
                if (!(typeName = jsonType.typeName()).isEmpty()) {
                    beanInfo.typeName = typeName;
                }
                for (JSONWriter.Feature feature : jsonType.serializeFeatures()) {
                    beanInfo.writerFeatures |= feature.mask;
                }
                beanInfo.namingStrategy = jsonType.naming().name();
                String[] ignores = jsonType.ignores();
                if (ignores.length > 0) {
                    beanInfo.ignores = ignores;
                }
                if ((includes = jsonType.includes()).length > 0) {
                    beanInfo.includes = includes;
                }
                if ((orders = jsonType.orders()).length > 0) {
                    beanInfo.orders = orders;
                }
                if (ObjectWriter.class.isAssignableFrom(serializer = jsonType.serializer())) {
                    beanInfo.serializer = serializer;
                    beanInfo.writeEnumAsJavaBean = true;
                }
                if ((serializeFilters = jsonType.serializeFilters()).length != 0) {
                    beanInfo.serializeFilters = serializeFilters;
                }
                if (!(format = jsonType.format()).isEmpty()) {
                    beanInfo.format = format;
                }
                if (!(locale = jsonType.locale()).isEmpty() && (parts = locale.split("_")).length == 2) {
                    beanInfo.locale = new Locale(parts[0], parts[1]);
                }
                if (!jsonType.alphabetic()) {
                    beanInfo.alphabetic = false;
                }
                if (jsonType.writeEnumAsJavaBean()) {
                    beanInfo.writeEnumAsJavaBean = true;
                }
                if (!(rootName = jsonType.rootName()).isEmpty()) {
                    beanInfo.rootName = rootName;
                }
            } else if (jsonType1x != null) {
                Annotation annotation = jsonType1x;
                BeanUtils.annotationMethods(jsonType1x.annotationType(), method -> BeanUtils.processJSONType1x(beanInfo, annotation, method));
            }
            if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0 && (beanInfo.typeName == null || beanInfo.typeName.length() == 0)) {
                for (Class seeAlsoClass : beanInfo.seeAlso) {
                    if (seeAlsoClass != objectClass) continue;
                    beanInfo.typeName = objectClass.getSimpleName();
                    break;
                }
            }
        }

        @Override
        public void getFieldInfo(BeanInfo beanInfo, FieldInfo fieldInfo, Class objectClass, Field field) {
            Class serializeUsing;
            Annotation[] annotations;
            int modifiers;
            boolean isTransient;
            Class fieldClassMixInSource;
            Class mixInSource;
            if (objectClass != null && (mixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
                Field mixInField = null;
                try {
                    mixInField = mixInSource.getDeclaredField(field.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInField != null) {
                    this.getFieldInfo(beanInfo, fieldInfo, mixInSource, mixInField);
                }
            }
            if ((fieldClassMixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(field.getType())) != null) {
                fieldInfo.fieldClassMixIn = true;
            }
            if (isTransient = Modifier.isTransient(modifiers = field.getModifiers())) {
                fieldInfo.ignore = true;
            }
            JSONField jsonField = null;
            block30: for (Annotation annotation : annotations = BeanUtils.getAnnotations(field)) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (jsonField == null && (jsonField = BeanUtils.findAnnotation(annotation, JSONField.class)) == annotation) continue;
                String annotationTypeName = annotationType.getName();
                boolean useJacksonAnnotation = JSONFactory.isUseJacksonAnnotation();
                switch (annotationTypeName) {
                    case "com.fasterxml.jackson.annotation.JsonIgnore": {
                        if (!useJacksonAnnotation) continue block30;
                        BeanUtils.processJacksonJsonIgnore(fieldInfo, annotation);
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonAnyGetter": {
                        if (!useJacksonAnnotation) continue block30;
                        fieldInfo.features |= 0x2000000000000L;
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonValue": {
                        if (!useJacksonAnnotation) continue block30;
                        fieldInfo.features |= 0x1000000000000L;
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonRawValue": {
                        if (!useJacksonAnnotation) continue block30;
                        fieldInfo.features |= 0x4000000000000L;
                        continue block30;
                    }
                    case "com.alibaba.fastjson.annotation.JSONField": {
                        this.processJSONField1x(fieldInfo, annotation);
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonProperty": {
                        if (!useJacksonAnnotation) continue block30;
                        this.processJacksonJsonProperty(fieldInfo, annotation);
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonFormat": {
                        if (!useJacksonAnnotation) continue block30;
                        BeanUtils.processJacksonJsonFormat(fieldInfo, annotation);
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonInclude": {
                        if (!useJacksonAnnotation) continue block30;
                        BeanUtils.processJacksonJsonInclude(beanInfo, annotation);
                        continue block30;
                    }
                    case "com.fasterxml.jackson.databind.annotation.JsonSerialize": {
                        if (!useJacksonAnnotation) continue block30;
                        this.processJacksonJsonSerialize(fieldInfo, annotation);
                        continue block30;
                    }
                    case "com.google.gson.annotations.SerializedName": {
                        if (!JSONFactory.isUseGsonAnnotation()) continue block30;
                        BeanUtils.processGsonSerializedName(fieldInfo, annotation);
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonManagedReference": {
                        if (!useJacksonAnnotation) continue block30;
                        fieldInfo.features |= JSONWriter.Feature.ReferenceDetection.mask;
                        continue block30;
                    }
                    case "com.fasterxml.jackson.annotation.JsonBackReference": {
                        if (!useJacksonAnnotation) continue block30;
                        fieldInfo.features |= 0x2000000000000000L;
                        continue block30;
                    }
                }
            }
            if (jsonField == null) {
                return;
            }
            this.loadFieldInfo(fieldInfo, jsonField);
            Class writeUsing = jsonField.writeUsing();
            if (ObjectWriter.class.isAssignableFrom(writeUsing)) {
                fieldInfo.writeUsing = writeUsing;
            }
            if (ObjectWriter.class.isAssignableFrom(serializeUsing = jsonField.serializeUsing())) {
                fieldInfo.writeUsing = serializeUsing;
            }
            if (jsonField.jsonDirect()) {
                fieldInfo.features |= 0x4000000000000L;
            }
            if ((fieldInfo.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L && !String.class.equals(field.getType()) && fieldInfo.writeUsing == null) {
                fieldInfo.writeUsing = ObjectWriterImplToString.class;
            }
        }

        private void processJacksonJsonSubTypes(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Annotation[] value;
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    if ("value".equals(name) && (value = (Annotation[])result).length != 0) {
                        beanInfo.seeAlso = new Class[value.length];
                        beanInfo.seeAlsoNames = new String[value.length];
                        for (int i = 0; i < value.length; ++i) {
                            Annotation item = value[i];
                            BeanUtils.processJacksonJsonSubTypesType(beanInfo, i, item);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonSerialize(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "using": {
                            Class using = this.processUsing((Class)result);
                            if (using == null) break;
                            beanInfo.serializer = using;
                            break;
                        }
                        case "keyUsing": {
                            Class keyUsing = this.processUsing((Class)result);
                            if (keyUsing == null) break;
                            beanInfo.serializer = keyUsing;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private Class processUsing(Class result) {
            String noneClassName1 = "com.fasterxml.jackson.databind.JsonSerializer$None";
            String usingName = result.getName();
            if (!noneClassName1.equals(usingName) && ObjectWriter.class.isAssignableFrom(result)) {
                return result;
            }
            if ("com.fasterxml.jackson.databind.ser.std.ToStringSerializer".equals(usingName)) {
                return ObjectWriterImplToString.class;
            }
            return null;
        }

        private void processJacksonJsonTypeInfo(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    String value;
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    if ("property".equals(name) && !(value = (String)result).isEmpty()) {
                        beanInfo.typeKey = value;
                        beanInfo.writerFeatures |= JSONWriter.Feature.WriteClassName.mask;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonPropertyOrder(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            AtomicBoolean alphabetic = new AtomicBoolean(false);
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    if ("value".equals(name)) {
                        String[] value = (String[])result;
                        if (value.length != 0) {
                            beanInfo.orders = value;
                        }
                    } else if ("alphabetic".equals(name)) {
                        alphabetic.set((Boolean)result);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            if (beanInfo.orders == null || beanInfo.orders.length == 0) {
                beanInfo.alphabetic = alphabetic.get();
            }
        }

        private void processJacksonJsonSerialize(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "using": {
                            Class using = this.processUsing((Class)result);
                            if (using == null) break;
                            fieldInfo.writeUsing = using;
                            break;
                        }
                        case "keyUsing": {
                            Class keyUsing = this.processUsing((Class)result);
                            if (keyUsing == null) break;
                            fieldInfo.keyUsing = keyUsing;
                            break;
                        }
                        case "valueUsing": {
                            Class valueUsing = this.processUsing((Class)result);
                            if (valueUsing == null) break;
                            fieldInfo.valueUsing = valueUsing;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonProperty(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "value": {
                            String value = (String)result;
                            if (value.isEmpty() || fieldInfo.fieldName != null && !fieldInfo.fieldName.isEmpty()) break;
                            fieldInfo.fieldName = value;
                            break;
                        }
                        case "access": {
                            String access = ((Enum)result).name();
                            fieldInfo.ignore = "WRITE_ONLY".equals(access);
                            break;
                        }
                        case "index": {
                            int index = (Integer)result;
                            if (index == -1) break;
                            fieldInfo.ordinal = index;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonIgnoreProperties(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    String[] value;
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    if ("value".equals(name) && (value = (String[])result).length != 0) {
                        beanInfo.ignores = value;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJSONField1x(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "name": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            fieldInfo.fieldName = value;
                            break;
                        }
                        case "format": {
                            this.loadJsonFieldFormat(fieldInfo, (String)result);
                            break;
                        }
                        case "label": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            fieldInfo.label = value;
                            break;
                        }
                        case "defaultValue": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            fieldInfo.defaultValue = value;
                            break;
                        }
                        case "ordinal": {
                            int ordinal = (Integer)result;
                            if (ordinal == 0) break;
                            fieldInfo.ordinal = ordinal;
                            break;
                        }
                        case "serialize": {
                            boolean serialize = (Boolean)result;
                            if (serialize) break;
                            fieldInfo.ignore = true;
                            break;
                        }
                        case "unwrapped": {
                            if (!((Boolean)result).booleanValue()) break;
                            fieldInfo.features |= 0x2000000000000L;
                            break;
                        }
                        case "serialzeFeatures": {
                            Enum[] features = (Enum[])result;
                            this.applyFeatures(fieldInfo, features);
                            break;
                        }
                        case "serializeUsing": {
                            Class writeUsing = (Class)result;
                            if (!ObjectWriter.class.isAssignableFrom(writeUsing)) break;
                            fieldInfo.writeUsing = writeUsing;
                            break;
                        }
                        case "jsonDirect": {
                            Boolean jsonDirect = (Boolean)result;
                            if (!jsonDirect.booleanValue()) break;
                            fieldInfo.features |= 0x4000000000000L;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void applyFeatures(FieldInfo fieldInfo, Enum[] features) {
            block32: for (Enum feature : features) {
                switch (feature.name()) {
                    case "UseISO8601DateFormat": {
                        fieldInfo.format = "iso8601";
                        continue block32;
                    }
                    case "WriteMapNullValue": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNulls.mask;
                        continue block32;
                    }
                    case "WriteNullListAsEmpty": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNullListAsEmpty.mask;
                        continue block32;
                    }
                    case "WriteNullStringAsEmpty": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNullStringAsEmpty.mask;
                        continue block32;
                    }
                    case "WriteNullNumberAsZero": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNullNumberAsZero.mask;
                        continue block32;
                    }
                    case "WriteNullBooleanAsFalse": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNullBooleanAsFalse.mask;
                        continue block32;
                    }
                    case "BrowserCompatible": {
                        fieldInfo.features |= JSONWriter.Feature.BrowserCompatible.mask;
                        continue block32;
                    }
                    case "WriteClassName": {
                        fieldInfo.features |= JSONWriter.Feature.WriteClassName.mask;
                        continue block32;
                    }
                    case "WriteNonStringValueAsString": {
                        fieldInfo.features |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
                        continue block32;
                    }
                    case "WriteEnumUsingToString": {
                        fieldInfo.features |= JSONWriter.Feature.WriteEnumUsingToString.mask;
                        continue block32;
                    }
                    case "NotWriteRootClassName": {
                        fieldInfo.features |= JSONWriter.Feature.NotWriteRootClassName.mask;
                        continue block32;
                    }
                    case "IgnoreErrorGetter": {
                        fieldInfo.features |= JSONWriter.Feature.IgnoreErrorGetter.mask;
                        continue block32;
                    }
                    case "WriteBigDecimalAsPlain": {
                        fieldInfo.features |= JSONWriter.Feature.WriteBigDecimalAsPlain.mask;
                        continue block32;
                    }
                    case "DisableCircularReferenceDetect": {
                        fieldInfo.features |= 0x200000000000000L;
                        continue block32;
                    }
                }
            }
        }

        @Override
        public void getFieldInfo(BeanInfo beanInfo, FieldInfo fieldInfo, Class objectClass, Method method) {
            Field methodField;
            Class fieldClassMixInSource;
            Class mixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(objectClass);
            String methodName = method.getName();
            if ("getTargetSql".equals(methodName) && objectClass != null && objectClass.getName().startsWith("com.baomidou.mybatisplus.")) {
                fieldInfo.features |= JSONWriter.Feature.IgnoreErrorGetter.mask;
            }
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(methodName, method.getParameterTypes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(beanInfo, fieldInfo, mixInSource, mixInMethod);
                }
            }
            if ((fieldClassMixInSource = (Class)ObjectWriterBaseModule.this.provider.mixInCache.get(method.getReturnType())) != null) {
                fieldInfo.fieldClassMixIn = true;
            }
            if (JDKUtils.CLASS_TRANSIENT != null && method.getAnnotation(JDKUtils.CLASS_TRANSIENT) != null) {
                fieldInfo.ignore = true;
            }
            if (objectClass != null) {
                Class<?>[] interfaces;
                Class superclass = objectClass.getSuperclass();
                Method supperMethod = BeanUtils.getMethod(superclass, method);
                boolean ignore = fieldInfo.ignore;
                if (supperMethod != null) {
                    this.getFieldInfo(beanInfo, fieldInfo, superclass, supperMethod);
                    Field field = BeanUtils.getField(objectClass, method);
                    int supperMethodModifiers = supperMethod.getModifiers();
                    if (null != field && ignore != fieldInfo.ignore && !Modifier.isAbstract(supperMethodModifiers) && !supperMethod.equals(method)) {
                        fieldInfo.ignore = ignore;
                    }
                }
                for (Class<?> anInterface : interfaces = objectClass.getInterfaces()) {
                    Method interfaceMethod = BeanUtils.getMethod(anInterface, method);
                    if (interfaceMethod == null) continue;
                    this.getFieldInfo(beanInfo, fieldInfo, superclass, interfaceMethod);
                }
            }
            Annotation[] annotations = BeanUtils.getAnnotations(method);
            this.processAnnotations(fieldInfo, annotations);
            if (!objectClass.getName().startsWith("java.lang") && !BeanUtils.isRecord(objectClass) && (methodField = BeanUtils.getField(objectClass, method)) != null) {
                fieldInfo.features |= 0x10000000000000L;
                this.getFieldInfo(beanInfo, fieldInfo, objectClass, methodField);
            }
            if (beanInfo.kotlin && beanInfo.creatorConstructor != null && beanInfo.createParameterNames != null) {
                String fieldName = BeanUtils.getterName(method, beanInfo.kotlin, null);
                for (int i = 0; i < beanInfo.createParameterNames.length; ++i) {
                    Annotation[][] creatorConsParamAnnotations;
                    if (!fieldName.equals(beanInfo.createParameterNames[i]) || i >= (creatorConsParamAnnotations = beanInfo.creatorConstructor.getParameterAnnotations()).length) continue;
                    Annotation[] parameterAnnotations = creatorConsParamAnnotations[i];
                    this.processAnnotations(fieldInfo, parameterAnnotations);
                    break;
                }
            }
        }

        private void processAnnotations(FieldInfo fieldInfo, Annotation[] annotations) {
            block26: for (Annotation annotation : annotations) {
                String annotationTypeName;
                JSONCompiler compiler;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                JSONField jsonField = BeanUtils.findAnnotation(annotation, JSONField.class);
                if (Objects.nonNull(jsonField)) {
                    this.loadFieldInfo(fieldInfo, jsonField);
                    continue;
                }
                if (annotationType == JSONCompiler.class && (compiler = (JSONCompiler)annotation).value() == JSONCompiler.CompilerOption.LAMBDA) {
                    fieldInfo.features |= 0x40000000000000L;
                }
                boolean useJacksonAnnotation = JSONFactory.isUseJacksonAnnotation();
                switch (annotationTypeName = annotationType.getName()) {
                    case "com.fasterxml.jackson.annotation.JsonIgnore": {
                        if (!useJacksonAnnotation) continue block26;
                        BeanUtils.processJacksonJsonIgnore(fieldInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonAnyGetter": {
                        if (!useJacksonAnnotation) continue block26;
                        fieldInfo.features |= 0x2000000000000L;
                        continue block26;
                    }
                    case "com.alibaba.fastjson.annotation.JSONField": {
                        this.processJSONField1x(fieldInfo, annotation);
                        continue block26;
                    }
                    case "java.beans.Transient": {
                        fieldInfo.ignore = true;
                        fieldInfo.isTransient = true;
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonProperty": {
                        if (!useJacksonAnnotation) continue block26;
                        this.processJacksonJsonProperty(fieldInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonFormat": {
                        if (!useJacksonAnnotation) continue block26;
                        BeanUtils.processJacksonJsonFormat(fieldInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonValue": {
                        if (!useJacksonAnnotation) continue block26;
                        fieldInfo.features |= 0x1000000000000L;
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonRawValue": {
                        if (!useJacksonAnnotation) continue block26;
                        fieldInfo.features |= 0x4000000000000L;
                        continue block26;
                    }
                    case "com.fasterxml.jackson.databind.annotation.JsonSerialize": {
                        if (!useJacksonAnnotation) continue block26;
                        this.processJacksonJsonSerialize(fieldInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonInclude": {
                        if (!useJacksonAnnotation) continue block26;
                        BeanUtils.processJacksonJsonInclude(fieldInfo, annotation);
                        continue block26;
                    }
                    case "com.fasterxml.jackson.annotation.JsonUnwrapped": {
                        if (!useJacksonAnnotation) continue block26;
                        BeanUtils.processJacksonJsonUnwrapped(fieldInfo, annotation);
                        continue block26;
                    }
                }
            }
        }

        private void loadFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
            Class serializeUsing;
            boolean ignore;
            String[] parts;
            String locale;
            String defaultValue;
            String jsonFieldName = jsonField.name();
            if (!jsonFieldName.isEmpty()) {
                fieldInfo.fieldName = jsonFieldName;
            }
            if (!(defaultValue = jsonField.defaultValue()).isEmpty()) {
                fieldInfo.defaultValue = defaultValue;
            }
            this.loadJsonFieldFormat(fieldInfo, jsonField.format());
            String label = jsonField.label();
            if (!label.isEmpty()) {
                fieldInfo.label = label;
            }
            if (!(locale = jsonField.locale()).isEmpty() && (parts = locale.split("_")).length == 2) {
                fieldInfo.locale = new Locale(parts[0], parts[1]);
            }
            boolean bl = ignore = !jsonField.serialize();
            if (!fieldInfo.ignore) {
                fieldInfo.ignore = ignore;
            }
            if (jsonField.unwrapped()) {
                fieldInfo.features |= 0x2000000000000L;
            }
            for (JSONWriter.Feature feature : jsonField.serializeFeatures()) {
                fieldInfo.features |= feature.mask;
                if (!fieldInfo.ignore || ignore || feature != JSONWriter.Feature.FieldBased) continue;
                fieldInfo.ignore = false;
            }
            int ordinal = jsonField.ordinal();
            if (ordinal != 0) {
                fieldInfo.ordinal = ordinal;
            }
            if (jsonField.value()) {
                fieldInfo.features |= 0x1000000000000L;
            }
            if (jsonField.jsonDirect()) {
                fieldInfo.features |= 0x4000000000000L;
            }
            if (ObjectWriter.class.isAssignableFrom(serializeUsing = jsonField.serializeUsing())) {
                fieldInfo.writeUsing = serializeUsing;
            }
        }

        private void loadJsonFieldFormat(FieldInfo fieldInfo, String jsonFieldFormat) {
            if (!jsonFieldFormat.isEmpty()) {
                if ((jsonFieldFormat = jsonFieldFormat.trim()).indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                    jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
                }
                if (!jsonFieldFormat.isEmpty()) {
                    fieldInfo.format = jsonFieldFormat;
                }
            }
        }
    }

    static class VoidObjectWriter
    implements ObjectWriter {
        public static final VoidObjectWriter INSTANCE = new VoidObjectWriter();

        VoidObjectWriter() {
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        }
    }
}

