/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigInteger;

final class FieldWriterBigIntField<T>
extends FieldWriterImpl<T> {
    protected FieldWriterBigIntField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, (Type)((Object)BigInteger.class), BigInteger.class, field, null);
    }

    @Override
    public Object getFieldValue(T object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        BigInteger value = (BigInteger)this.getFieldValue(object);
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeBigInt(value, this.features);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        BigInteger value = (BigInteger)this.getFieldValue(object);
        jsonWriter.writeBigInt(value, this.features);
    }
}

