/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.function.impl.ToDouble;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JSONPath {
    static final JSONReader.Context PARSE_CONTEXT = JSONFactory.createReadContext();
    JSONReader.Context readerContext;
    JSONWriter.Context writerContext;
    final String path;
    static FunctionSegment FUNCTION_TYPE = new FunctionSegment(JSONPath::type);
    static FunctionSegment FUNCTION_DOUBLE = new FunctionSegment(new ToDouble(null));
    static FunctionSegment FUNCTION_FLOOR = new FunctionSegment(JSONPath::floor);
    static FunctionSegment FUNCTION_CEIL = new FunctionSegment(JSONPath::ceil);
    static FunctionSegment FUNCTION_ABS = new FunctionSegment(JSONPath::abs);
    static FunctionSegment FUNCTION_NEGATIVE = new FunctionSegment(JSONPath::negative);
    static FunctionSegment FUNCTION_EXISTS = new FunctionSegment(JSONPath::exists);

    protected JSONPath(String path) {
        this.path = path;
    }

    public boolean isPrevious() {
        return false;
    }

    public final String toString() {
        return this.path;
    }

    public static Object extract(String json, String path) {
        JSONReader jsonReader = JSONReader.of(json);
        JSONPath jsonPath = JSONPath.of(path);
        return jsonPath.extract(jsonReader);
    }

    public static Object eval(String str, String path) {
        return JSONPath.extract(str, path);
    }

    public static Object eval(Object rootObject, String path) {
        return JSONPath.of(path).eval(rootObject);
    }

    public static String set(String json, String path, Object value) {
        Object object = JSON.parse(json);
        JSONPath.of(path).set(object, value);
        return JSON.toJSONString(object);
    }

    public static boolean contains(Object rootObject, String path) {
        if (rootObject == null) {
            return false;
        }
        JSONPath jsonPath = JSONPath.of(path);
        return jsonPath.contains(rootObject);
    }

    public static Object set(Object rootObject, String path, Object value) {
        JSONPath.of(path).set(rootObject, value);
        return rootObject;
    }

    public static Object setCallback(Object rootObject, String path, Function callback) {
        JSONPath.of(path).setCallback(rootObject, callback);
        return rootObject;
    }

    public static Object setCallback(Object rootObject, String path, BiFunction callback) {
        JSONPath.of(path).setCallback(rootObject, callback);
        return rootObject;
    }

    public static String remove(String json, String path) {
        Object object = JSON.parse(json);
        JSONPath.of(path).remove(object);
        return JSON.toJSONString(object);
    }

    public static void remove(Object rootObject, String path) {
        JSONPath.of(path).remove(rootObject);
    }

    public static Map<String, Object> paths(Object javaObject) {
        IdentityHashMap<Object, String> values = new IdentityHashMap<Object, String>();
        HashMap<String, Object> paths = new HashMap<String, Object>();
        RootPath.INSTANCE.paths(values, paths, "$", javaObject);
        return paths;
    }

    void paths(Map<Object, String> values, Map<String, Object> paths, String parent, Object javaObject) {
        if (javaObject == null) {
            return;
        }
        String p = values.put(javaObject, parent);
        if (p != null) {
            boolean basicType;
            Class<?> type = javaObject.getClass();
            boolean bl = basicType = type == String.class || type == Boolean.class || type == Character.class || type == UUID.class || type.isEnum() || javaObject instanceof Number || javaObject instanceof Date;
            if (!basicType) {
                return;
            }
        }
        paths.put(parent, javaObject);
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            for (Map.Entry entryObj : map.entrySet()) {
                Map.Entry entry = entryObj;
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String path = parent + "." + key;
                this.paths(values, paths, path, entry.getValue());
            }
            return;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            int i = 0;
            for (Object item : collection) {
                String path = parent + "[" + i + "]";
                this.paths(values, paths, path, item);
                ++i;
            }
            return;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                String path = parent + "[" + i + "]";
                this.paths(values, paths, path, item);
            }
            return;
        }
        if (ObjectWriterProvider.isPrimitiveOrEnum(clazz)) {
            return;
        }
        ObjectWriter<?> serializer = this.getWriterContext().getObjectWriter(clazz);
        if (serializer instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter javaBeanSerializer = (ObjectWriterAdapter)serializer;
            try {
                Map<String, Object> fieldValues = javaBeanSerializer.toMap(javaObject);
                for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    String path = parent + "." + key;
                    this.paths(values, paths, path, entry.getValue());
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", e);
            }
        }
    }

    public abstract boolean isRef();

    public void arrayAdd(Object root, Object ... values) {
        Object result = this.eval(root);
        if (result == null) {
            this.set(root, JSONArray.of(values));
            return;
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            for (Object value : values) {
                collection.add(value);
            }
        }
    }

    public abstract boolean contains(Object var1);

    public abstract Object eval(Object var1);

    public abstract Object extract(JSONReader var1);

    public abstract String extractScalar(JSONReader var1);

    public JSONReader.Context getReaderContext() {
        if (this.readerContext == null) {
            this.readerContext = JSONFactory.createReadContext();
        }
        return this.readerContext;
    }

    public JSONPath setReaderContext(JSONReader.Context context) {
        this.readerContext = context;
        return this;
    }

    public JSONWriter.Context getWriterContext() {
        if (this.writerContext == null) {
            this.writerContext = JSONFactory.createWriteContext();
        }
        return this.writerContext;
    }

    public JSONPath setWriterContext(JSONWriter.Context writerContext) {
        this.writerContext = writerContext;
        return this;
    }

    public abstract void set(Object var1, Object var2);

    public abstract void set(Object var1, Object var2, JSONReader.Feature ... var3);

    public void setCallback(Object object, Function callback) {
        this.setCallback(object, new BiFunctionAdapter(callback));
    }

    public abstract void setCallback(Object var1, BiFunction var2);

    public abstract void setInt(Object var1, int var2);

    public abstract void setLong(Object var1, long var2);

    public abstract boolean remove(Object var1);

    public void extract(JSONReader jsonReader, ValueConsumer consumer) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            consumer.acceptNull();
            return;
        }
        if (object instanceof Number) {
            consumer.accept((Number)object);
            return;
        }
        if (object instanceof String) {
            consumer.accept((String)object);
            return;
        }
        if (object instanceof Boolean) {
            consumer.accept((Boolean)object);
            return;
        }
        if (object instanceof Map) {
            consumer.accept((Map)object);
            return;
        }
        if (object instanceof List) {
            consumer.accept((List)object);
            return;
        }
        throw new JSONException("TODO : " + object.getClass());
    }

    public void extractScalar(JSONReader jsonReader, ValueConsumer consumer) {
        String object = this.extractScalar(jsonReader);
        if (object == null) {
            consumer.acceptNull();
            return;
        }
        String str = object.toString();
        consumer.accept(str);
    }

    public Long extractInt64(JSONReader jsonReader) {
        long value = this.extractInt64Value(jsonReader);
        if (jsonReader.wasNull) {
            return null;
        }
        return value;
    }

    public long extractInt64Value(JSONReader jsonReader) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            jsonReader.wasNull = true;
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(object.getClass(), Long.TYPE);
        if (typeConvert == null) {
            throw new JSONException("can not convert to long : " + object);
        }
        Object converted = typeConvert.apply(object);
        return (Long)converted;
    }

    public Integer extractInt32(JSONReader jsonReader) {
        int intValue = this.extractInt32Value(jsonReader);
        if (jsonReader.wasNull) {
            return null;
        }
        return intValue;
    }

    public int extractInt32Value(JSONReader jsonReader) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            jsonReader.wasNull = true;
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(object.getClass(), Integer.TYPE);
        if (typeConvert == null) {
            throw new JSONException("can not convert to int : " + object);
        }
        Object converted = typeConvert.apply(object);
        return (Integer)converted;
    }

    @Deprecated
    public static JSONPath compile(String path) {
        return JSONPath.of(path);
    }

    public static JSONPath compile(String strPath, Class objectClass) {
        JSONPath path = JSONPath.of(strPath);
        JSONFactory.JSONPathCompiler compiler = JSONFactory.getDefaultJSONPathCompiler();
        return compiler.compile(objectClass, path);
    }

    public static JSONPath of(String path) {
        if ("#-1".equals(path)) {
            return PreviousPath.INSTANCE;
        }
        return new JSONPathParser(path).parse();
    }

    static Operator parseOperator(JSONReader jsonReader) {
        Operator operator;
        switch (jsonReader.ch) {
            case '<': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.LE;
                    break;
                }
                if (jsonReader.ch == '>') {
                    jsonReader.next();
                    operator = Operator.NE;
                    break;
                }
                operator = Operator.LT;
                break;
            }
            case '=': {
                jsonReader.next();
                if (jsonReader.ch == '~') {
                    jsonReader.next();
                    operator = Operator.REG_MATCH;
                    break;
                }
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.EQ;
                    break;
                }
                operator = Operator.EQ;
                break;
            }
            case '!': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.NE;
                    break;
                }
                throw new JSONException("not support operator : !" + jsonReader.ch);
            }
            case '>': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = Operator.GE;
                    break;
                }
                operator = Operator.GT;
                break;
            }
            case 'L': 
            case 'l': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("like".equalsIgnoreCase(fieldName)) {
                    operator = Operator.LIKE;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'N': 
            case 'n': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("nin".equalsIgnoreCase(fieldName)) {
                    operator = Operator.NOT_IN;
                    break;
                }
                if (!"not".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                jsonReader.readFieldNameHashCodeUnquote();
                fieldName = jsonReader.getFieldName();
                if ("like".equalsIgnoreCase(fieldName)) {
                    operator = Operator.NOT_LIKE;
                    break;
                }
                if ("rlike".equalsIgnoreCase(fieldName)) {
                    operator = Operator.NOT_RLIKE;
                    break;
                }
                if ("in".equalsIgnoreCase(fieldName)) {
                    operator = Operator.NOT_IN;
                    break;
                }
                if ("between".equalsIgnoreCase(fieldName)) {
                    operator = Operator.NOT_BETWEEN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'I': 
            case 'i': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("in".equalsIgnoreCase(fieldName)) {
                    operator = Operator.IN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'R': 
            case 'r': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("rlike".equalsIgnoreCase(fieldName)) {
                    operator = Operator.RLIKE;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'B': 
            case 'b': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("between".equalsIgnoreCase(fieldName)) {
                    operator = Operator.BETWEEN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'S': 
            case 's': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if (!"starts".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                jsonReader.readFieldNameHashCodeUnquote();
                fieldName = jsonReader.getFieldName();
                if (!"with".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                operator = Operator.STARTS_WITH;
                break;
            }
            default: {
                jsonReader.readFieldNameHashCodeUnquote();
                throw new JSONException("not support operator : " + jsonReader.getFieldName());
            }
        }
        return operator;
    }

    static String type(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Collection) {
            return "array";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof String || value instanceof UUID || value instanceof Enum) {
            return "string";
        }
        return "object";
    }

    static Object floor(Object value) {
        if (value instanceof Double) {
            return Math.floor((Double)value);
        }
        if (value instanceof Float) {
            return Math.floor(((Float)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(0, RoundingMode.FLOOR);
        }
        if (value instanceof List) {
            List list = (List)value;
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                Object item = list.get(i);
                if (item instanceof Double) {
                    list.set(i, Math.floor((Double)item));
                    continue;
                }
                if (item instanceof Float) {
                    list.set(i, Math.floor(((Float)item).floatValue()));
                    continue;
                }
                if (!(item instanceof BigDecimal)) continue;
                list.set(i, ((BigDecimal)item).setScale(0, RoundingMode.FLOOR));
            }
        }
        return value;
    }

    static Object ceil(Object value) {
        if (value instanceof Double) {
            return Math.ceil((Double)value);
        }
        if (value instanceof Float) {
            return Math.ceil(((Float)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(0, RoundingMode.CEILING);
        }
        if (value instanceof List) {
            List list = (List)value;
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                Object item = list.get(i);
                if (item instanceof Double) {
                    list.set(i, Math.floor((Double)item));
                    continue;
                }
                if (item instanceof Float) {
                    list.set(i, Math.floor(((Float)item).floatValue()));
                    continue;
                }
                if (!(item instanceof BigDecimal)) continue;
                list.set(i, ((BigDecimal)item).setScale(0, RoundingMode.FLOOR));
            }
        }
        return value;
    }

    static Object exists(Object value) {
        return value != null;
    }

    static Object negative(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof Byte) {
            return (int)(-((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return (int)(-((Short)value).shortValue());
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        if (value instanceof Float) {
            return Float.valueOf(-((Float)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof List) {
            List list = (List)value;
            JSONArray values = new JSONArray(list.size());
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                Object item = list.get(i);
                Number negativeItem = item instanceof Double ? (Number)(-((Double)item).doubleValue()) : (Number)(item instanceof Float ? (Number)Float.valueOf(-((Float)item).floatValue()) : (Number)(item instanceof BigDecimal ? ((BigDecimal)item).negate() : (item instanceof BigInteger ? ((BigInteger)item).negate() : item)));
                values.add(negativeItem);
            }
            return values;
        }
        throw new JSONException("abs not support " + value);
    }

    static Object abs(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return Math.abs((Integer)value);
        }
        if (value instanceof Long) {
            return Math.abs((Long)value);
        }
        if (value instanceof Byte) {
            return Math.abs(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return Math.abs(((Short)value).shortValue());
        }
        if (value instanceof Double) {
            return Math.abs((Double)value);
        }
        if (value instanceof Float) {
            return Float.valueOf(Math.abs(((Float)value).floatValue()));
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).abs();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).abs();
        }
        if (value instanceof List) {
            List list = (List)value;
            JSONArray values = new JSONArray(list.size());
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                Object item = list.get(i);
                Number absItem = item instanceof Double ? (Number)Math.abs((Double)item) : (Number)(item instanceof Float ? (Number)Float.valueOf(Math.abs(((Float)item).floatValue())) : (Number)(item instanceof BigDecimal ? ((BigDecimal)item).abs() : (item instanceof BigInteger ? ((BigInteger)item).abs() : item)));
                values.add(absItem);
            }
            return values;
        }
        throw new JSONException("abs not support " + value);
    }

    static final class RootPath
    extends JSONPath {
        static final RootPath INSTANCE = new RootPath();

        protected RootPath() {
            super("$");
        }

        @Override
        public boolean isRef() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public Object eval(Object object) {
            return object;
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            if (jsonReader == null) {
                return null;
            }
            return jsonReader.readAny();
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            Object any = jsonReader.readAny();
            return JSON.toJSONString(any);
        }

        @Override
        public void set(Object object, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object object, Object value, JSONReader.Feature ... readerFeatures) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCallback(Object object, BiFunction callback) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setInt(Object object, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLong(Object object, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            return false;
        }
    }

    static final class BiFunctionAdapter
    implements BiFunction {
        private final Function function;

        BiFunctionAdapter(Function function) {
            this.function = function;
        }

        public Object apply(Object o1, Object o2) {
            return this.function.apply(o2);
        }
    }

    static final class PreviousPath
    extends JSONPath {
        static final PreviousPath INSTANCE = new PreviousPath("#-1");

        PreviousPath(String path) {
            super(path);
        }

        @Override
        public boolean isRef() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPrevious() {
            return true;
        }

        @Override
        public boolean contains(Object rootObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object eval(Object rootObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object rootObject, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object rootObject, Object value, JSONReader.Feature ... readerFeatures) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCallback(Object rootObject, BiFunction callback) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setInt(Object rootObject, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLong(Object rootObject, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object rootObject) {
            throw new UnsupportedOperationException();
        }
    }

    static class JSONPathParser {
        final String path;
        final JSONReader jsonReader;
        boolean dollar;
        boolean lax;
        boolean strict;
        int segmentIndex;
        Segment first;
        Segment second;
        List<Segment> segments;
        boolean negative;

        public JSONPathParser(String str) {
            this.path = str;
            this.jsonReader = JSONReader.of(PARSE_CONTEXT, this.path);
            if (this.jsonReader.ch == 'l' && this.jsonReader.nextIfMatchIdent('l', 'a', 'x')) {
                this.lax = true;
            } else if (this.jsonReader.ch == 's' && this.jsonReader.nextIfMatchIdent('s', 't', 'r', 'i', 'c', 't')) {
                this.strict = true;
            }
            if (this.jsonReader.ch == '-') {
                this.jsonReader.next();
                this.negative = true;
            }
            if (this.jsonReader.ch == '$') {
                this.jsonReader.next();
                this.dollar = true;
            }
        }

        JSONPath parse() {
            if (this.dollar && this.jsonReader.ch == '\u001a') {
                if (this.negative) {
                    return new SingleSegmentPath(FUNCTION_NEGATIVE, this.path);
                }
                return RootPath.INSTANCE;
            }
            if (this.jsonReader.ch == 'e' && this.jsonReader.nextIfMatchIdent('e', 'x', 'i', 's', 't', 's')) {
                char ch;
                if (!this.jsonReader.nextIfMatch('(')) {
                    throw new JSONException("syntax error " + this.path);
                }
                if (this.jsonReader.ch == '@') {
                    this.jsonReader.next();
                    if (!this.jsonReader.nextIfMatch('.')) {
                        throw new JSONException("syntax error " + this.path);
                    }
                }
                if (!((ch = this.jsonReader.ch) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '@')) {
                    throw new JSONException("syntax error " + this.path);
                }
                Segment segment = this.parseProperty();
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException("syntax error " + this.path);
                }
                return new TwoSegmentPath(this.path, segment, FUNCTION_EXISTS);
            }
            while (this.jsonReader.ch != '\u001a') {
                Segment segment;
                char ch = this.jsonReader.ch;
                if (ch == '.') {
                    this.jsonReader.next();
                    segment = this.parseProperty();
                } else if (this.jsonReader.ch == '[') {
                    segment = this.parseArrayAccess();
                } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_') {
                    segment = this.parseProperty();
                } else if (ch == '?') {
                    if (this.dollar && this.segmentIndex == 0) {
                        this.first = RootSegment.INSTANCE;
                        ++this.segmentIndex;
                    }
                    this.jsonReader.next();
                    segment = this.parseFilter();
                } else if (ch == '@') {
                    this.jsonReader.next();
                    segment = SelfSegment.INSTANCE;
                } else {
                    throw new JSONException("not support " + ch);
                }
                if (this.segmentIndex == 0) {
                    this.first = segment;
                } else if (this.segmentIndex == 1) {
                    this.second = segment;
                } else if (this.segmentIndex == 2) {
                    this.segments = new ArrayList<Segment>();
                    this.segments.add(this.first);
                    this.segments.add(this.second);
                    this.segments.add(segment);
                } else {
                    this.segments.add(segment);
                }
                ++this.segmentIndex;
            }
            if (this.negative) {
                if (this.segmentIndex == 1) {
                    this.second = FUNCTION_NEGATIVE;
                } else if (this.segmentIndex == 2) {
                    this.segments = new ArrayList<Segment>();
                    this.segments.add(this.first);
                    this.segments.add(this.second);
                    this.segments.add(FUNCTION_NEGATIVE);
                } else {
                    this.segments.add(FUNCTION_NEGATIVE);
                }
                ++this.segmentIndex;
            }
            if (this.segmentIndex == 1) {
                if (this.first instanceof NameSegment) {
                    return new SingleNamePath(this.path, (NameSegment)this.first);
                }
                return new SingleSegmentPath(this.first, this.path);
            }
            if (this.segmentIndex == 2) {
                return new TwoSegmentPath(this.path, this.first, this.second);
            }
            return new MultiSegmentPath(this.path, this.segments);
        }

        private Segment parseArrayAccess() {
            Segment segment;
            this.jsonReader.next();
            switch (this.jsonReader.ch) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int index = this.jsonReader.readInt32Value();
                    boolean last = false;
                    if (this.jsonReader.ch == ':') {
                        this.jsonReader.next();
                        if (this.jsonReader.ch == ']') {
                            segment = new RangeIndexSegment(index, index >= 0 ? Integer.MAX_VALUE : 0);
                            break;
                        }
                        int end = this.jsonReader.readInt32Value();
                        segment = new RangeIndexSegment(index, end);
                        break;
                    }
                    if (this.jsonReader.isNumber() || (last = this.jsonReader.nextIfMatchIdent('l', 'a', 's', 't'))) {
                        ArrayList<Integer> list = new ArrayList<Integer>();
                        list.add(index);
                        if (last) {
                            list.add(-1);
                            this.jsonReader.nextIfMatch(',');
                        }
                        while (true) {
                            if (this.jsonReader.isNumber()) {
                                index = this.jsonReader.readInt32Value();
                                list.add(index);
                                continue;
                            }
                            if (!this.jsonReader.nextIfMatchIdent('l', 'a', 's', 't')) break;
                            list.add(-1);
                            this.jsonReader.nextIfMatch(',');
                        }
                        int[] indics = new int[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            indics[i] = (Integer)list.get(i);
                        }
                        segment = new MultiIndexSegment(indics);
                        break;
                    }
                    segment = IndexSegment.of(index);
                    break;
                }
                case '*': {
                    this.jsonReader.next();
                    segment = AllSegment.INSTANCE_ARRAY;
                    break;
                }
                case ':': {
                    int end;
                    this.jsonReader.next();
                    int n = end = this.jsonReader.ch == ']' ? 0 : this.jsonReader.readInt32Value();
                    if (end > 0) {
                        segment = new RangeIndexSegment(0, end);
                        break;
                    }
                    segment = new RangeIndexSegment(Integer.MIN_VALUE, end);
                    break;
                }
                case '\"': 
                case '\'': {
                    String name = this.jsonReader.readString();
                    if (this.jsonReader.current() == ']') {
                        segment = new NameSegment(name, Fnv.hashCode64(name));
                        break;
                    }
                    if (this.jsonReader.isString()) {
                        ArrayList<String> names = new ArrayList<String>();
                        names.add(name);
                        do {
                            names.add(this.jsonReader.readString());
                        } while (this.jsonReader.isString());
                        String[] nameArray = new String[names.size()];
                        names.toArray(nameArray);
                        segment = new MultiNameSegment(nameArray);
                        break;
                    }
                    throw new JSONException("TODO : " + this.jsonReader.current());
                }
                case '?': {
                    this.jsonReader.next();
                    segment = this.parseFilter();
                    break;
                }
                case 'r': {
                    String fieldName = this.jsonReader.readFieldNameUnquote();
                    if ("randomIndex".equals(fieldName)) {
                        if (!this.jsonReader.nextIfMatch('(') || !this.jsonReader.nextIfMatch(')') || this.jsonReader.ch != ']') {
                            throw new JSONException("not support : " + fieldName);
                        }
                        segment = RandomIndexSegment.INSTANCE;
                        break;
                    }
                    throw new JSONException("not support : " + fieldName);
                }
                case 'l': {
                    String fieldName = this.jsonReader.readFieldNameUnquote();
                    if ("last".equals(fieldName)) {
                        segment = IndexSegment.of(-1);
                        break;
                    }
                    throw new JSONException("not support : " + fieldName);
                }
                default: {
                    throw new JSONException("TODO : " + this.jsonReader.current());
                }
            }
            if (!this.jsonReader.nextIfMatch(']')) {
                throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
            }
            return segment;
        }

        private Segment parseProperty() {
            Segment segment;
            if (this.jsonReader.ch == '*') {
                this.jsonReader.next();
                segment = AllSegment.INSTANCE;
            } else if (this.jsonReader.ch == '.') {
                this.jsonReader.next();
                if (this.jsonReader.ch == '*') {
                    this.jsonReader.next();
                    segment = new CycleNameSegment("*", Fnv.hashCode64("*"));
                } else {
                    long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
                    String name = this.jsonReader.getFieldName();
                    segment = new CycleNameSegment(name, hashCode);
                }
            } else {
                boolean isNum = this.jsonReader.isNumber();
                long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
                String name = this.jsonReader.getFieldName();
                if (isNum) {
                    if (name.length() > 9) {
                        isNum = false;
                    } else {
                        for (int i = 0; i < name.length(); ++i) {
                            char ch = name.charAt(i);
                            if (ch >= '0' && ch <= '9') continue;
                            isNum = false;
                            break;
                        }
                    }
                }
                IndexSegment indexSegment = null;
                if (isNum) {
                    try {
                        int index = Integer.parseInt(name);
                        indexSegment = IndexSegment.of(index);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (indexSegment != null) {
                    segment = indexSegment;
                } else if (this.jsonReader.ch == '(') {
                    switch (name) {
                        case "length": 
                        case "size": {
                            segment = LengthSegment.INSTANCE;
                            break;
                        }
                        case "keys": {
                            segment = KeysSegment.INSTANCE;
                            break;
                        }
                        case "values": {
                            segment = ValuesSegment.INSTANCE;
                            break;
                        }
                        case "min": {
                            segment = MinSegment.INSTANCE;
                            break;
                        }
                        case "max": {
                            segment = MaxSegment.INSTANCE;
                            break;
                        }
                        case "sum": {
                            segment = SumSegment.INSTANCE;
                            break;
                        }
                        case "type": {
                            segment = FUNCTION_TYPE;
                            break;
                        }
                        case "floor": {
                            segment = FUNCTION_FLOOR;
                            break;
                        }
                        case "ceil": 
                        case "ceiling": {
                            segment = FUNCTION_CEIL;
                            break;
                        }
                        case "double": {
                            segment = FUNCTION_DOUBLE;
                            break;
                        }
                        case "abs": {
                            segment = FUNCTION_ABS;
                            break;
                        }
                        case "negative": {
                            segment = FUNCTION_NEGATIVE;
                            break;
                        }
                        default: {
                            throw new JSONException("not support syntax, path : " + this.path);
                        }
                    }
                    this.jsonReader.next();
                    if (!this.jsonReader.nextIfMatch(')')) {
                        throw new JSONException("not support syntax, path : " + this.path);
                    }
                } else {
                    segment = new NameSegment(name, hashCode);
                }
            }
            return segment;
        }

        Segment parseFilterRest(Segment segment) {
            boolean and;
            switch (this.jsonReader.ch) {
                case '&': {
                    this.jsonReader.next();
                    if (!this.jsonReader.nextIfMatch('&')) {
                        throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                    }
                    and = true;
                    break;
                }
                case '|': {
                    this.jsonReader.next();
                    if (!this.jsonReader.nextIfMatch('|')) {
                        throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                    }
                    and = false;
                    break;
                }
                case 'A': 
                case 'a': {
                    String fieldName = this.jsonReader.readFieldNameUnquote();
                    if (!"and".equalsIgnoreCase(fieldName)) {
                        throw new JSONException("syntax error : " + fieldName);
                    }
                    and = true;
                    break;
                }
                case 'O': 
                case 'o': {
                    String fieldName = this.jsonReader.readFieldNameUnquote();
                    if (!"or".equalsIgnoreCase(fieldName)) {
                        throw new JSONException("syntax error : " + fieldName);
                    }
                    and = false;
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + this.jsonReader.ch);
                }
            }
            Segment right = this.parseFilter();
            if (segment instanceof GroupFilter) {
                GroupFilter group = (GroupFilter)segment;
                if (group.and == and) {
                    group.filters.add((FilterSegment)right);
                    return group;
                }
            }
            ArrayList<FilterSegment> filters = new ArrayList<FilterSegment>();
            filters.add((FilterSegment)segment);
            filters.add((FilterSegment)right);
            return new GroupFilter(filters, and);
        }

        Segment parseFilter() {
            boolean parentheses = this.jsonReader.nextIfMatch('(');
            if (this.jsonReader.ch == '@') {
                this.jsonReader.next();
                if (this.jsonReader.ch != '.') {
                    Operator operator = JSONPath.parseOperator(this.jsonReader);
                    Segment segment = null;
                    if (this.jsonReader.isNumber()) {
                        Number number = this.jsonReader.readNumber();
                        if (number instanceof Integer || number instanceof Long) {
                            segment = new NameIntOpSegment(null, 0L, null, null, null, operator, number.longValue());
                        }
                    } else if (this.jsonReader.isString()) {
                        String string = this.jsonReader.readString();
                        switch (operator) {
                            case STARTS_WITH: {
                                segment = new StartsWithSegment(null, 0L, string);
                                break;
                            }
                            default: {
                                throw new JSONException("syntax error, " + string);
                            }
                        }
                    }
                    while (this.jsonReader.ch == '&' || this.jsonReader.ch == '|') {
                        segment = this.parseFilterRest(segment);
                    }
                    if (segment != null) {
                        if (parentheses && !this.jsonReader.nextIfMatch(')')) {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        return segment;
                    }
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                this.jsonReader.next();
                long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = this.jsonReader.getFieldName();
                if (parentheses && this.jsonReader.nextIfMatch(')')) {
                    NameExistsFilter segment = new NameExistsFilter(fieldName, hashCode);
                    return segment;
                }
                Function function = null;
                if (this.jsonReader.ch == '(') {
                    this.jsonReader.next();
                    if (!this.jsonReader.nextIfMatch(')')) {
                        throw new JSONException("syntax error, function " + fieldName);
                    }
                    switch (fieldName) {
                        case "type": {
                            fieldName = null;
                            hashCode = 0L;
                            function = TypeFunction.INSTANCE;
                            break;
                        }
                        case "size": {
                            fieldName = null;
                            hashCode = 0L;
                            function = SizeFunction.INSTANCE;
                            break;
                        }
                        default: {
                            throw new JSONException("syntax error, function not support " + fieldName);
                        }
                    }
                }
                long[] hashCode2 = null;
                String[] fieldName2 = null;
                while (this.jsonReader.ch == '.') {
                    this.jsonReader.next();
                    long hash = this.jsonReader.readFieldNameHashCodeUnquote();
                    String str = this.jsonReader.getFieldName();
                    if (hashCode2 == null) {
                        hashCode2 = new long[]{hash};
                        fieldName2 = new String[]{str};
                        continue;
                    }
                    hashCode2 = Arrays.copyOf(hashCode2, hashCode2.length + 1);
                    hashCode2[hashCode2.length - 1] = hash;
                    fieldName2 = Arrays.copyOf(fieldName2, fieldName2.length + 1);
                    fieldName2[fieldName2.length - 1] = str;
                }
                Operator operator = JSONPath.parseOperator(this.jsonReader);
                switch (operator) {
                    case REG_MATCH: 
                    case RLIKE: 
                    case NOT_RLIKE: {
                        boolean ignoreCase;
                        String regex;
                        if (this.jsonReader.isString()) {
                            regex = this.jsonReader.readString();
                            ignoreCase = false;
                        } else {
                            regex = this.jsonReader.readPattern();
                            ignoreCase = this.jsonReader.nextIfMatch('i');
                        }
                        Pattern pattern = ignoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
                        NameRLikeSegment segment = new NameRLikeSegment(fieldName, hashCode, pattern, operator == Operator.NOT_RLIKE);
                        if (!this.jsonReader.nextIfMatch(')')) {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        return segment;
                    }
                    case IN: 
                    case NOT_IN: {
                        NameFilter segment;
                        ArrayList<Object> list;
                        if (this.jsonReader.ch != '(') {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        this.jsonReader.next();
                        if (this.jsonReader.isString()) {
                            list = new ArrayList<Object>();
                            while (this.jsonReader.isString()) {
                                list.add(this.jsonReader.readString());
                            }
                            String[] strArray = new String[list.size()];
                            list.toArray(strArray);
                            segment = new NameStringInSegment(fieldName, hashCode, strArray, operator == Operator.NOT_IN);
                        } else if (this.jsonReader.isNumber()) {
                            list = new ArrayList();
                            while (this.jsonReader.isNumber()) {
                                list.add(this.jsonReader.readNumber());
                            }
                            long[] values = new long[list.size()];
                            for (int i = 0; i < list.size(); ++i) {
                                values[i] = ((Number)list.get(i)).longValue();
                            }
                            segment = new NameIntInSegment(fieldName, hashCode, fieldName2, hashCode2, function, values, operator == Operator.NOT_IN);
                        } else {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        if (!this.jsonReader.nextIfMatch(')')) {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        if (!this.jsonReader.nextIfMatch(')')) {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        return segment;
                    }
                    case BETWEEN: 
                    case NOT_BETWEEN: {
                        Number begin;
                        if (this.jsonReader.isNumber()) {
                            begin = this.jsonReader.readNumber();
                            String and = this.jsonReader.readFieldNameUnquote();
                            if (!"and".equalsIgnoreCase(and)) {
                                throw new JSONException("syntax error, " + and);
                            }
                        } else {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        Number end = this.jsonReader.readNumber();
                        NameIntBetweenSegment segment = new NameIntBetweenSegment(fieldName, hashCode, begin.longValue(), end.longValue(), operator == Operator.NOT_BETWEEN);
                        if (parentheses && !this.jsonReader.nextIfMatch(')')) {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        return segment;
                    }
                }
                Segment segment = null;
                switch (this.jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        Number number = this.jsonReader.readNumber();
                        if (number instanceof Integer || number instanceof Long) {
                            segment = new NameIntOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, operator, number.longValue());
                            break;
                        }
                        if (number instanceof BigDecimal) {
                            segment = new NameDecimalOpSegment(fieldName, hashCode, operator, (BigDecimal)number);
                            break;
                        }
                        throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                    }
                    case '\"': 
                    case '\'': {
                        String strVal = this.jsonReader.readString();
                        int p0 = strVal.indexOf(37);
                        if (p0 == -1) {
                            if (operator == Operator.LIKE) {
                                operator = Operator.EQ;
                            } else if (operator == Operator.NOT_LIKE) {
                                operator = Operator.NE;
                            }
                        }
                        if (operator == Operator.LIKE || operator == Operator.NOT_LIKE) {
                            String[] items = strVal.split("%");
                            String startsWithValue = null;
                            String endsWithValue = null;
                            String[] containsValues = null;
                            if (p0 == 0) {
                                if (strVal.charAt(strVal.length() - 1) == '%') {
                                    containsValues = new String[items.length - 1];
                                    System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                                } else {
                                    endsWithValue = items[items.length - 1];
                                    if (items.length > 2) {
                                        containsValues = new String[items.length - 2];
                                        System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                                    }
                                }
                            } else if (strVal.charAt(strVal.length() - 1) == '%') {
                                if (items.length == 1) {
                                    startsWithValue = items[0];
                                } else {
                                    containsValues = items;
                                }
                            } else if (items.length == 1) {
                                startsWithValue = items[0];
                            } else if (items.length == 2) {
                                startsWithValue = items[0];
                                endsWithValue = items[1];
                            } else {
                                startsWithValue = items[0];
                                endsWithValue = items[items.length - 1];
                                containsValues = new String[items.length - 2];
                                System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                            }
                            segment = new NameMatchFilter(fieldName, hashCode, startsWithValue, endsWithValue, containsValues, operator == Operator.NOT_LIKE);
                            break;
                        }
                        segment = new NameStringOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, operator, strVal);
                        break;
                    }
                    case 't': {
                        String ident = this.jsonReader.readFieldNameUnquote();
                        if (!"true".equalsIgnoreCase(ident)) break;
                        segment = new NameIntOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, operator, 1L);
                        break;
                    }
                    case 'f': {
                        String ident = this.jsonReader.readFieldNameUnquote();
                        if (!"false".equalsIgnoreCase(ident)) break;
                        segment = new NameIntOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, operator, 0L);
                        break;
                    }
                    case '[': {
                        JSONArray array = this.jsonReader.read(JSONArray.class);
                        segment = new NameArrayOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, operator, array);
                        break;
                    }
                    case '{': {
                        JSONObject object = this.jsonReader.read(JSONObject.class);
                        segment = new NameObjectOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, operator, object);
                        break;
                    }
                    default: {
                        throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                    }
                }
                if (this.jsonReader.ch == '&' || this.jsonReader.ch == '|' || this.jsonReader.ch == 'a' || this.jsonReader.ch == 'o') {
                    segment = this.parseFilterRest(segment);
                }
                if (parentheses && !this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                return segment;
            }
            if (this.jsonReader.nextIfMatchIdent('e', 'x', 'i', 's', 't', 's')) {
                if (!this.jsonReader.nextIfMatch('(')) {
                    throw new JSONException(this.jsonReader.info("exists"));
                }
                if (this.jsonReader.nextIfMatch('@') && this.jsonReader.nextIfMatch('.')) {
                    long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
                    String fieldName = this.jsonReader.getFieldName();
                    if (this.jsonReader.nextIfMatch(')')) {
                        if (parentheses && !this.jsonReader.nextIfMatch(')')) {
                            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                        }
                        NameExistsFilter segment = new NameExistsFilter(fieldName, hashCode);
                        return segment;
                    }
                }
                throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
            }
            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
        }
    }

    static enum Operator {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE,
        LIKE,
        NOT_LIKE,
        RLIKE,
        NOT_RLIKE,
        IN,
        NOT_IN,
        BETWEEN,
        NOT_BETWEEN,
        AND,
        OR,
        REG_MATCH,
        STARTS_WITH;

    }

    static final class FunctionSegment
    extends Segment
    implements EvalSegment {
        final Function function;

        public FunctionSegment(Function function) {
            this.function = function;
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
                context.eval = true;
            }
            this.eval(context);
        }

        @Override
        public void eval(Context context) {
            Object value = context.parent == null ? context.root : context.parent.value;
            context.value = this.function.apply(value);
        }
    }

    static class Sequence {
        final List values;

        public Sequence(List values) {
            this.values = values;
        }
    }

    static final class AllSegment
    extends Segment {
        static final AllSegment INSTANCE = new AllSegment(false);
        static final AllSegment INSTANCE_ARRAY = new AllSegment(true);
        final boolean array;

        AllSegment(boolean array) {
            this.array = array;
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                context.value = null;
                context.eval = true;
                return;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(map.size());
                for (Object value : map.values()) {
                    if (this.array && value instanceof Collection) {
                        array.addAll((Collection)value);
                        continue;
                    }
                    array.add(value);
                }
                context.value = context.next != null ? new Sequence(array) : array;
                context.eval = true;
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                JSONArray values = new JSONArray(list.size());
                if (context.next == null && !this.array) {
                    for (Object item : list) {
                        if (item instanceof Map) {
                            values.addAll(((Map)item).values());
                            continue;
                        }
                        values.add(item);
                    }
                    context.value = values;
                    context.eval = true;
                    return;
                }
                context.value = context.next != null ? new Sequence(list) : object;
                context.eval = true;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                context.eval = true;
                return;
            }
            if (object instanceof Sequence) {
                List list = ((Sequence)object).values;
                JSONArray values = new JSONArray(list.size());
                if (context.next == null && !this.array) {
                    for (Object item : list) {
                        if (item instanceof Map) {
                            values.addAll(((Map)item).values());
                            continue;
                        }
                        values.add(item);
                    }
                    context.value = values;
                    context.eval = true;
                    return;
                }
                context.value = context.next != null ? new Sequence(list) : object;
                context.eval = true;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().getProvider();
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            int size = fieldWriters.size();
            JSONArray array = new JSONArray(size);
            for (int i = 0; i < size; ++i) {
                Object fieldValue = fieldWriters.get(i).getFieldValue(object);
                array.add(fieldValue);
            }
            context.value = array;
            context.eval = true;
        }

        @Override
        public boolean remove(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                ((Map)object).clear();
                return true;
            }
            if (object instanceof Collection) {
                ((Collection)object).clear();
                return true;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent != null && context.parent.eval) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray values = new JSONArray();
                if (jsonReader.nextIfMatch((byte)-90)) {
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        if (!jsonReader.skipName()) continue;
                        Object val = jsonReader.readAny();
                        if (this.array && val instanceof Collection) {
                            values.addAll((Collection)val);
                            continue;
                        }
                        values.add(val);
                    }
                    context.value = values;
                    return;
                }
                if (jsonReader.isArray() && context.next != null) {
                    return;
                }
                throw new JSONException("TODO");
            }
            JSONArray values = new JSONArray();
            if (jsonReader.nextIfMatch('{')) {
                block10: while (true) {
                    Object val;
                    if (jsonReader.ch == '}') {
                        jsonReader.next();
                        break;
                    }
                    jsonReader.skipName();
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        case ']': {
                            jsonReader.next();
                            break block10;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val instanceof Collection) {
                        values.addAll((Collection)val);
                    } else {
                        values.add(val);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                context.value = values;
                context.eval = true;
                return;
            }
            if (jsonReader.ch == '[') {
                jsonReader.next();
                while (true) {
                    if (jsonReader.ch == ']') break;
                    Object value = jsonReader.readAny();
                    if (context.next == null && value instanceof Map) {
                        values.addAll(((Map)value).values());
                    } else {
                        values.add(value);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                jsonReader.next();
                context.value = context.next != null ? new Sequence(values) : values;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class MultiNameSegment
    extends Segment {
        final String[] names;
        final long[] nameHashCodes;
        final Set<String> nameSet;

        public MultiNameSegment(String[] names) {
            this.names = names;
            this.nameHashCodes = new long[names.length];
            this.nameSet = new HashSet<String>();
            for (int i = 0; i < names.length; ++i) {
                this.nameHashCodes[i] = Fnv.hashCode64(names[i]);
                this.nameSet.add(names[i]);
            }
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(this.names.length);
                for (String name : this.names) {
                    Object value = map.get(name);
                    array.add(value);
                }
                context.value = array;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().getProvider();
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            JSONArray array = new JSONArray(this.names.length);
            for (int i = 0; i < this.names.length; ++i) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCodes[i]);
                Object fieldValue = null;
                if (fieldWriter != null) {
                    fieldValue = fieldWriter.getFieldValue(object);
                }
                array.add(fieldValue);
            }
            context.value = array;
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof FilterSegment || context.parent.current instanceof MultiIndexSegment)) {
                this.eval(context);
                return;
            }
            Object object = jsonReader.readAny();
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(this.names.length);
                for (String name : this.names) {
                    Object value = map.get(name);
                    array.add(value);
                }
                context.value = array;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().getProvider();
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            JSONArray array = new JSONArray(this.names.length);
            for (int i = 0; i < this.names.length; ++i) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCodes[i]);
                Object fieldValue = null;
                if (fieldWriter != null) {
                    fieldValue = fieldWriter.getFieldValue(object);
                }
                array.add(fieldValue);
            }
            context.value = array;
        }
    }

    static final class MultiIndexSegment
    extends Segment {
        final int[] indexes;

        public MultiIndexSegment(int[] indexes) {
            this.indexes = indexes;
        }

        @Override
        public void eval(Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof Sequence) {
                List list = ((Sequence)object).values;
                for (Object item : list) {
                    context.value = item;
                    Context itemContext = new Context(context.path, context, context.current, context.next, context.readerFeatures);
                    this.eval(itemContext);
                    Object value = itemContext.value;
                    if (value instanceof Collection) {
                        result.addAll((Collection)value);
                        continue;
                    }
                    result.add(value);
                }
                context.value = result;
                return;
            }
            for (int index : this.indexes) {
                int itemIndex;
                Object value;
                if (object instanceof List) {
                    List list = (List)object;
                    if (index >= 0) {
                        if (index >= list.size()) continue;
                        value = list.get(index);
                    } else {
                        itemIndex = list.size() + index;
                        if (itemIndex < 0) continue;
                        value = list.get(itemIndex);
                    }
                } else {
                    if (!(object instanceof Object[])) continue;
                    Object[] array = (Object[])object;
                    if (index >= 0) {
                        if (index >= array.length) continue;
                        value = array[index];
                    } else {
                        itemIndex = array.length + index;
                        if (itemIndex < 0) continue;
                        value = array[itemIndex];
                    }
                }
                if (value instanceof Collection) {
                    result.addAll((Collection)value);
                    continue;
                }
                result.add(value);
            }
            context.value = result;
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent != null && context.parent.current instanceof CycleNameSegment && context.next == null) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (int i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                context.value = array;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = Arrays.binarySearch(this.indexes, i) >= 0;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val);
                }
                ++i;
            }
            context.value = array;
        }
    }

    static final class RangeIndexSegment
    extends Segment {
        final int begin;
        final int end;

        public RangeIndexSegment(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public void eval(Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i >= this.begin && i < this.end;
                    } else {
                        int ni = i - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    result.add(list.get(i));
                }
                context.value = result;
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                for (int i = 0; i < array.length; ++i) {
                    boolean match;
                    boolean bl = match = i >= this.begin && i <= this.end || i - array.length > this.begin && i - array.length <= this.end;
                    if (!match) continue;
                    result.add(array[i]);
                }
                context.value = result;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof CycleNameSegment && context.next == null)) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                int i;
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = this.begin < 0 || i >= this.begin && i < this.end;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                if (this.begin < 0) {
                    int size = array.size();
                    for (i = size - 1; i >= 0; --i) {
                        int ni = i - size;
                        if (ni >= this.begin && ni < this.end) continue;
                        array.remove(i);
                    }
                }
                context.value = array;
                context.eval = true;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = this.begin < 0 || i >= this.begin && i < this.end;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val);
                }
                ++i;
            }
            if (this.begin < 0) {
                int size = array.size();
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    int ni = i2 - size;
                    if (ni >= this.begin && ni < this.end) continue;
                    array.remove(i2);
                }
            }
            context.value = array;
            context.eval = true;
        }

        @Override
        public void set(Context context, Object value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i >= this.begin && i < this.end;
                    } else {
                        int ni = i - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    list.set(i, value);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public boolean remove(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                int removeCount = 0;
                int size = list.size();
                for (int i = size - 1; i >= 0; --i) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i >= this.begin && i < this.end;
                    } else {
                        int ni = i - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    list.remove(i);
                    ++removeCount;
                }
                return removeCount > 0;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }
    }

    static final class RandomIndexSegment
    extends Segment {
        public static final RandomIndexSegment INSTANCE = new RandomIndexSegment();
        Random random;

        RandomIndexSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof CycleNameSegment && context.next == null)) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (int i = 0; i < itemCnt; ++i) {
                    array.add(jsonReader.readAny());
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int index = Math.abs(this.random.nextInt()) % array.size();
                context.value = array.get(index);
                context.eval = true;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i = 0;
            while (jsonReader.ch != '\u001a') {
                Object val;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber0();
                        val = jsonReader.getNumber();
                        break;
                    }
                    case '[': {
                        val = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        val = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val = null;
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
                array.add(val);
                ++i;
            }
            if (this.random == null) {
                this.random = new Random();
            }
            int index = Math.abs(this.random.nextInt()) % array.size();
            context.value = array.get(index);
            context.eval = true;
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return;
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int randomIndex = Math.abs(this.random.nextInt()) % list.size();
                context.value = list.get(randomIndex);
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (array.length == 0) {
                    return;
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int randomIndex = this.random.nextInt() % array.length;
                context.value = array[randomIndex];
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class IndexSegment
    extends Segment {
        static final IndexSegment ZERO = new IndexSegment(0);
        static final IndexSegment ONE = new IndexSegment(1);
        static final IndexSegment TWO = new IndexSegment(2);
        static final IndexSegment LAST = new IndexSegment(-1);
        final int index;

        public IndexSegment(int index) {
            this.index = index;
        }

        static IndexSegment of(int index) {
            if (index == 0) {
                return ZERO;
            }
            if (index == 1) {
                return ONE;
            }
            if (index == 2) {
                return TWO;
            }
            if (index == -1) {
                return LAST;
            }
            return new IndexSegment(index);
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                context.eval = true;
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                if (this.index >= 0) {
                    if (this.index < list.size()) {
                        context.value = list.get(this.index);
                    }
                } else {
                    int itemIndex = list.size() + this.index;
                    if (itemIndex >= 0) {
                        context.value = list.get(itemIndex);
                    }
                }
                context.eval = true;
                return;
            }
            if (object instanceof SortedSet || object instanceof LinkedHashSet || this.index == 0 && object instanceof Collection && ((Collection)object).size() == 1) {
                Collection collection = (Collection)object;
                int i = 0;
                for (Object item : collection) {
                    if (i == this.index) {
                        context.value = item;
                        break;
                    }
                    ++i;
                }
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        context.value = array[this.index];
                    }
                } else {
                    int itemIndex = array.length + this.index;
                    if (itemIndex >= 0) {
                        context.value = array[itemIndex];
                    }
                }
                context.eval = true;
                return;
            }
            Class<?> objectClass = object.getClass();
            if (objectClass.isArray()) {
                int length = Array.getLength(object);
                if (this.index >= 0) {
                    if (this.index < length) {
                        context.value = Array.get(object, this.index);
                    }
                } else {
                    int itemIndex = length + this.index;
                    if (itemIndex >= 0) {
                        context.value = Array.get(object, itemIndex);
                    }
                }
                context.eval = true;
                return;
            }
            if (object instanceof Sequence) {
                List sequence = ((Sequence)object).values;
                JSONArray values = new JSONArray(sequence.size());
                for (int i = 0; i < sequence.size(); ++i) {
                    Object item = sequence.get(i);
                    context.value = item;
                    Context itemContext = new Context(context.path, context, context.current, context.next, context.readerFeatures);
                    this.eval(itemContext);
                    values.add(itemContext.value);
                }
                context.value = context.next != null ? new Sequence(values) : values;
                context.eval = true;
                return;
            }
            if (Map.class.isAssignableFrom(objectClass)) {
                Object value;
                context.value = value = this.eval((Map)object);
                context.eval = true;
                return;
            }
            if (this.index == 0) {
                context.value = object;
                context.eval = true;
                return;
            }
            throw new JSONException("jsonpath not support operate : " + context.path + ", objectClass" + objectClass.getName());
        }

        private Object eval(Map object) {
            Object value;
            block6: {
                Map map = object;
                value = map.get(this.index);
                if (value == null) {
                    value = map.get(Integer.toString(this.index));
                }
                if (value != null) break block6;
                int size = map.size();
                Iterator it = map.entrySet().iterator();
                if (size == 1 || map instanceof LinkedHashMap || map instanceof SortedMap) {
                    for (int i = 0; i <= this.index && i < size && it.hasNext(); ++i) {
                        Map.Entry entry = it.next();
                        Object entryKey = entry.getKey();
                        Object entryValue = entry.getValue();
                        if (entryKey instanceof Long) {
                            if (!entryKey.equals(this.index)) continue;
                            value = entryValue;
                            break;
                        }
                        if (i != this.index) continue;
                        value = entryValue;
                    }
                } else {
                    for (int i = 0; i <= this.index && i < map.size() && it.hasNext(); ++i) {
                        Map.Entry entry = it.next();
                        Object entryKey = entry.getKey();
                        Object entryValue = entry.getValue();
                        if (!(entryKey instanceof Long) || !entryKey.equals(this.index)) continue;
                        value = entryValue;
                        break;
                    }
                }
            }
            return value;
        }

        @Override
        public void set(Context context, Object value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                if (this.index >= 0) {
                    if (this.index < list.size()) {
                        list.set(this.index, value);
                    }
                } else {
                    int itemIndex = list.size() + this.index;
                    if (itemIndex >= 0) {
                        list.set(itemIndex, value);
                    }
                }
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (this.index >= 0) {
                    array[this.index] = value;
                } else {
                    array[array.length + this.index] = value;
                }
                return;
            }
            if (object != null && object.getClass().isArray()) {
                int length = Array.getLength(object);
                if (this.index >= 0) {
                    if (this.index < length) {
                        Array.set(object, this.index, value);
                    }
                } else {
                    int arrayIndex = length + this.index;
                    if (arrayIndex >= 0) {
                        Array.set(object, arrayIndex, value);
                    }
                }
                return;
            }
            throw new JSONException("UnsupportedOperation");
        }

        @Override
        public void setCallback(Context context, BiFunction callback) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                if (this.index >= 0) {
                    if (this.index < list.size()) {
                        Object value = list.get(this.index);
                        value = callback.apply(object, value);
                        list.set(this.index, value);
                    }
                } else {
                    int itemIndex = list.size() + this.index;
                    if (itemIndex >= 0) {
                        Object value = list.get(this.index);
                        value = callback.apply(object, value);
                        list.set(itemIndex, value);
                    }
                }
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        Object value = array[this.index];
                        array[this.index] = value = callback.apply(object, value);
                    }
                } else {
                    Object value = array[this.index];
                    array[array.length + this.index] = value = callback.apply(object, value);
                }
                return;
            }
            if (object != null && object.getClass().isArray()) {
                int length = Array.getLength(object);
                if (this.index >= 0) {
                    if (this.index < length) {
                        Object value = Array.get(object, this.index);
                        value = callback.apply(object, value);
                        Array.set(object, this.index, value);
                    }
                } else {
                    int arrayIndex = length + this.index;
                    if (arrayIndex >= 0) {
                        Object value = Array.get(object, this.index);
                        value = callback.apply(object, value);
                        Array.set(object, arrayIndex, value);
                    }
                }
                return;
            }
            throw new JSONException("UnsupportedOperation");
        }

        @Override
        public boolean remove(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                if (this.index >= 0) {
                    if (this.index < list.size()) {
                        list.remove(this.index);
                        return true;
                    }
                } else {
                    int itemIndex = list.size() + this.index;
                    if (itemIndex >= 0) {
                        list.remove(itemIndex);
                        return true;
                    }
                }
                return false;
            }
            throw new JSONException("UnsupportedOperation");
        }

        @Override
        public void setInt(Context context, int value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof int[]) {
                int[] array = (int[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = value;
                    }
                }
                return;
            }
            if (object instanceof long[]) {
                long[] array = (long[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = value;
                    }
                }
                return;
            }
            this.set(context, value);
        }

        @Override
        public void setLong(Context context, long value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof int[]) {
                int[] array = (int[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = (int)value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = (int)value;
                    }
                }
                return;
            }
            if (object instanceof long[]) {
                long[] array = (long[])object;
                if (this.index >= 0) {
                    if (this.index < array.length) {
                        array[this.index] = value;
                    }
                } else {
                    int arrayIndex = array.length + this.index;
                    if (arrayIndex >= 0) {
                        array[arrayIndex] = value;
                    }
                }
                return;
            }
            this.set(context, value);
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof CycleNameSegment && context.next == null)) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                int itemCnt = jsonReader.startArray();
                for (int i = 0; i < itemCnt; ++i) {
                    boolean match;
                    boolean bl = match = this.index == i;
                    if (match) {
                        if ((jsonReader.isArray() || jsonReader.isObject()) && context.next != null) break;
                        context.value = jsonReader.readAny();
                        context.eval = true;
                        break;
                    }
                    jsonReader.skipValue();
                }
                return;
            }
            if (jsonReader.ch == '{') {
                Map<String, Object> object = jsonReader.readObject();
                context.value = this.eval(object);
                context.eval = true;
                return;
            }
            jsonReader.next();
            int i = 0;
            block9: while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = this.index == -1 || this.index == i;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Map<String, Object> val;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            if (context.next != null && !(context.next instanceof EvalSegment)) break block9;
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            if (context.next != null && !(context.next instanceof EvalSegment)) break block9;
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (this.index == -1) {
                        if (jsonReader.ch == ']') {
                            context.value = val;
                        }
                    } else {
                        context.value = val;
                    }
                }
                ++i;
            }
        }

        public String toString() {
            int size = this.index < 0 ? IOUtils.stringSize(-this.index) + 1 : IOUtils.stringSize(this.index);
            byte[] bytes = new byte[size + 2];
            bytes[0] = 91;
            IOUtils.getChars(this.index, bytes.length - 1, bytes);
            bytes[bytes.length - 1] = 93;
            String str = JDKUtils.UNSAFE_ASCII_CREATOR != null ? (String)JDKUtils.UNSAFE_ASCII_CREATOR.apply(bytes) : new String(bytes, StandardCharsets.US_ASCII);
            return str;
        }
    }

    static final class CycleNameSegment
    extends Segment {
        static final long HASH_STAR = Fnv.hashCode64("*");
        final String name;
        final long nameHashCode;

        public CycleNameSegment(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        public String toString() {
            return ".." + this.name;
        }

        @Override
        public boolean remove(Context context) {
            this.set(context, null);
            context.eval = true;
            return true;
        }

        @Override
        public void eval(Context context) {
            ObjectWriter<?> objectWriter;
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray values = new JSONArray();
            MapLoop action = new MapLoop(context, values);
            if (object instanceof Map) {
                Map map = (Map)object;
                map.forEach(action);
            } else if (object instanceof Collection) {
                ((Collection)object).forEach(action);
            } else if (object != null && (objectWriter = context.path.getWriterContext().getObjectWriter(object.getClass())) instanceof ObjectWriterAdapter) {
                action.accept(object);
            }
            context.value = values.size() == 1 && values.get(0) instanceof Collection ? values.get(0) : values;
            context.eval = true;
        }

        @Override
        public void set(Context context, Object value) {
            Object object = context.parent == null ? context.root : context.parent.value;
            LoopSet action = new LoopSet(context, value);
            action.accept(object);
        }

        @Override
        public void setCallback(Context context, BiFunction callback) {
            Object object = context.parent == null ? context.root : context.parent.value;
            LoopCallback action = new LoopCallback(context, callback);
            action.accept(object);
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            JSONArray values = new JSONArray();
            this.accept(jsonReader, context, values);
            context.value = values;
            context.eval = true;
        }

        public void accept(JSONReader jsonReader, Context context, List<Object> values) {
            if (jsonReader.isJSONB()) {
                if (jsonReader.nextIfMatch((byte)-90)) {
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        boolean match;
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        if (nameHashCode == 0L) continue;
                        boolean bl = match = nameHashCode == this.nameHashCode;
                        if (match) {
                            if (jsonReader.isArray()) {
                                values.addAll(jsonReader.readArray());
                                continue;
                            }
                            values.add(jsonReader.readAny());
                            continue;
                        }
                        if (jsonReader.isObject() || jsonReader.isArray()) {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                    return;
                }
                if (jsonReader.isArray()) {
                    int itemCnt = jsonReader.startArray();
                    for (int i = 0; i < itemCnt; ++i) {
                        if (jsonReader.isObject() || jsonReader.isArray()) {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                } else {
                    jsonReader.skipValue();
                }
                return;
            }
            if (jsonReader.ch == '{') {
                jsonReader.next();
                block9: while (true) {
                    Object val;
                    if (jsonReader.ch == '}') break;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean match = nameHashCode == this.nameHashCode;
                    char ch = jsonReader.ch;
                    if (!match && ch != '{' && ch != '[') {
                        jsonReader.skipValue();
                        continue;
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': 
                        case '{': {
                            if (match) {
                                val = ch == '[' ? jsonReader.readArray() : jsonReader.readObject();
                                break;
                            }
                            this.accept(jsonReader, context, values);
                            continue block9;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val instanceof Collection) {
                        values.addAll((Collection)val);
                    } else {
                        values.add(val);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                jsonReader.next();
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else if (jsonReader.ch == '[') {
                block31: {
                    jsonReader.next();
                    do {
                        if (jsonReader.ch == ']') {
                            jsonReader.next();
                            break block31;
                        }
                        if (jsonReader.ch == '{' || jsonReader.ch == '[') {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    } while (jsonReader.ch != ',');
                    jsonReader.next();
                }
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else {
                jsonReader.skipValue();
            }
        }

        class MapLoop
        implements BiConsumer,
        Consumer {
            final Context context;
            final List values;

            public MapLoop(Context context, List values) {
                this.context = context;
                this.values = values;
            }

            public void accept(Object key, Object value) {
                if (CycleNameSegment.this.name.equals(key)) {
                    this.values.add(value);
                    return;
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                } else if (CycleNameSegment.this.nameHashCode == HASH_STAR) {
                    this.values.add(value);
                }
            }

            public void accept(Object value) {
                if (value == null) {
                    return;
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                } else {
                    ObjectWriter<?> objectWriter = this.context.path.getWriterContext().getObjectWriter(value.getClass());
                    if (objectWriter instanceof ObjectWriterAdapter) {
                        FieldWriter fieldWriter = objectWriter.getFieldWriter(CycleNameSegment.this.nameHashCode);
                        if (fieldWriter != null) {
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            if (fieldValue != null) {
                                this.values.add(fieldValue);
                            }
                            return;
                        }
                        for (int i = 0; i < objectWriter.getFieldWriters().size(); ++i) {
                            fieldWriter = objectWriter.getFieldWriters().get(i);
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            this.accept(fieldValue);
                        }
                        return;
                    }
                    if (CycleNameSegment.this.nameHashCode == HASH_STAR) {
                        this.values.add(value);
                    }
                }
            }
        }

        class LoopSet {
            final Context context;
            final Object value;

            public LoopSet(Context context, Object value) {
                this.context = context;
                this.value = value;
            }

            public void accept(Object object) {
                if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        if (CycleNameSegment.this.name.equals(entry.getKey())) {
                            entry.setValue(this.value);
                            this.context.eval = true;
                            continue;
                        }
                        Object entryValue = entry.getValue();
                        if (entryValue == null) continue;
                        this.accept(entryValue);
                    }
                } else if (object instanceof Collection) {
                    for (Object e : (List)object) {
                        this.accept(e);
                    }
                } else {
                    FieldReader fieldReader;
                    Class<?> entryValueClass = object.getClass();
                    ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(entryValueClass);
                    if (objectReader instanceof ObjectReaderBean && (fieldReader = objectReader.getFieldReader(CycleNameSegment.this.nameHashCode)) != null) {
                        fieldReader.accept(object, this.value);
                        this.context.eval = true;
                        return;
                    }
                    ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(entryValueClass);
                    List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
                    for (FieldWriter fieldWriter : fieldWriters) {
                        Object fieldValue = fieldWriter.getFieldValue(object);
                        this.accept(fieldValue);
                    }
                }
            }
        }

        class LoopCallback {
            final Context context;
            final BiFunction callback;

            public LoopCallback(Context context, BiFunction callback) {
                this.context = context;
                this.callback = callback;
            }

            public void accept(Object object) {
                if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        Object entryValue = entry.getValue();
                        if (CycleNameSegment.this.name.equals(entry.getKey())) {
                            Object applyValue = this.callback.apply(object, entryValue);
                            entry.setValue(applyValue);
                            this.context.eval = true;
                            continue;
                        }
                        if (entryValue == null) continue;
                        this.accept(entryValue);
                    }
                } else if (object instanceof Collection) {
                    for (Object e : (List)object) {
                        this.accept(e);
                    }
                } else {
                    Class<?> entryValueClass = object.getClass();
                    ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(entryValueClass);
                    ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(entryValueClass);
                    if (objectReader instanceof ObjectReaderBean) {
                        FieldReader fieldReader = objectReader.getFieldReader(CycleNameSegment.this.nameHashCode);
                        FieldWriter fieldWriter = objectWriter.getFieldWriter(CycleNameSegment.this.nameHashCode);
                        if (fieldWriter != null && fieldReader != null) {
                            Object fieldValue = fieldWriter.getFieldValue(object);
                            fieldValue = this.callback.apply(object, fieldValue);
                            fieldReader.accept(object, fieldValue);
                            this.context.eval = true;
                            return;
                        }
                    }
                    List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
                    for (FieldWriter fieldWriter : fieldWriters) {
                        Object fieldValue = fieldWriter.getFieldValue(object);
                        this.accept(fieldValue);
                    }
                }
            }
        }
    }

    static class NameSegment
    extends Segment {
        static final long HASH_NAME = Fnv.hashCode64("name");
        static final long HASH_ORDINAL = Fnv.hashCode64("ordinal");
        final String name;
        final long nameHashCode;

        public NameSegment(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        @Override
        public boolean remove(Context context) {
            this.set(context, null);
            context.eval = true;
            return true;
        }

        @Override
        public boolean contains(Context context) {
            FieldWriter fieldWriter;
            ObjectWriter<?> objectWriter;
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                return false;
            }
            if (object instanceof Map) {
                return ((Map)object).containsKey(this.name);
            }
            if (object instanceof Collection) {
                for (Object item : (Collection)object) {
                    FieldWriter fieldWriter2;
                    if (item == null) continue;
                    if (item instanceof Map && ((Map)item).get(this.name) != null) {
                        return true;
                    }
                    ObjectWriter<?> objectWriter2 = context.path.getWriterContext().getObjectWriter(item.getClass());
                    if (!(objectWriter2 instanceof ObjectWriterAdapter) || (fieldWriter2 = objectWriter2.getFieldWriter(this.nameHashCode)) == null || fieldWriter2.getFieldValue(item) == null) continue;
                    return true;
                }
                return false;
            }
            if (object instanceof Sequence) {
                Sequence sequence = (Sequence)object;
                for (Object item : sequence.values) {
                    FieldWriter fieldWriter3;
                    if (item == null) continue;
                    if (item instanceof Map && ((Map)item).get(this.name) != null) {
                        return true;
                    }
                    ObjectWriter<?> objectWriter3 = context.path.getWriterContext().getObjectWriter(item.getClass());
                    if (!(objectWriter3 instanceof ObjectWriterAdapter) || (fieldWriter3 = objectWriter3.getFieldWriter(this.nameHashCode)) == null || fieldWriter3.getFieldValue(item) == null) continue;
                    return true;
                }
                return false;
            }
            if (object instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])object) {
                    FieldWriter fieldWriter4;
                    if (item == null) continue;
                    if (item instanceof Map && ((Map)item).get(this.name) != null) {
                        return true;
                    }
                    ObjectWriter<?> objectWriter4 = context.path.getWriterContext().getObjectWriter(item.getClass());
                    if (!(objectWriter4 instanceof ObjectWriterAdapter) || (fieldWriter4 = objectWriter4.getFieldWriter(this.nameHashCode)) == null || fieldWriter4.getFieldValue(item) == null) continue;
                    return true;
                }
            }
            if ((objectWriter = context.path.getWriterContext().getObjectWriter(object.getClass())) instanceof ObjectWriterAdapter && (fieldWriter = objectWriter.getFieldWriter(this.nameHashCode)) != null) {
                return fieldWriter.getFieldValue(object) != null;
            }
            return false;
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                return;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                Object value = map.get(this.name);
                if (value == null) {
                    boolean isNum = IOUtils.isNumber(this.name);
                    Long longValue = null;
                    for (Map.Entry o : map.entrySet()) {
                        Map.Entry entry = o;
                        Object entryKey = entry.getKey();
                        if (entryKey instanceof Enum && ((Enum)entryKey).name().equals(this.name)) {
                            value = entry.getValue();
                            break;
                        }
                        if (!(entryKey instanceof Long)) continue;
                        if (longValue == null && isNum) {
                            longValue = Long.parseLong(this.name);
                        }
                        if (!entryKey.equals(longValue)) continue;
                        value = entry.getValue();
                        break;
                    }
                }
                context.value = value;
                return;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int size = collection.size();
                Collection values = null;
                for (Object item : collection) {
                    Object val;
                    if (!(item instanceof Map) || (val = ((Map)item).get(this.name)) == null) continue;
                    if (val instanceof Collection) {
                        if (size == 1) {
                            values = (Collection)val;
                            continue;
                        }
                        if (values == null) {
                            values = new JSONArray(size);
                        }
                        values.addAll((Collection)val);
                        continue;
                    }
                    if (values == null) {
                        values = new JSONArray(size);
                    }
                    values.add(val);
                }
                context.value = values;
                return;
            }
            if (object instanceof Sequence) {
                List sequence = ((Sequence)object).values;
                JSONArray values = new JSONArray(sequence.size());
                for (int i = 0; i < sequence.size(); ++i) {
                    Object item = sequence.get(i);
                    context.value = item;
                    Context itemContext = new Context(context.path, context, context.current, context.next, context.readerFeatures);
                    this.eval(itemContext);
                    Object val = itemContext.value;
                    if (val == null) continue;
                    if (val instanceof Collection) {
                        values.addAll((Collection)val);
                        continue;
                    }
                    values.add(val);
                }
                context.value = context.next != null ? new Sequence(values) : values;
                context.eval = true;
                return;
            }
            JSONWriter.Context writerContext = context.path.getWriterContext();
            ObjectWriter<?> objectWriter = writerContext.getObjectWriter(object.getClass());
            if (objectWriter instanceof ObjectWriterAdapter) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
                if (fieldWriter != null) {
                    context.value = fieldWriter.getFieldValue(object);
                }
                return;
            }
            if (this.nameHashCode == HASH_NAME && object instanceof Enum) {
                context.value = ((Enum)object).name();
                return;
            }
            if (this.nameHashCode == HASH_ORDINAL && object instanceof Enum) {
                context.value = ((Enum)object).ordinal();
                return;
            }
            if (object instanceof String) {
                String str = (String)object;
                if (!str.isEmpty() && str.charAt(0) == '{') {
                    context.value = JSONPath.of("$." + this.name).extract(JSONReader.of(str));
                    return;
                }
                context.value = null;
                return;
            }
            if (object instanceof Number || object instanceof Boolean) {
                context.value = null;
                return;
            }
            throw new JSONException("not support : " + object.getClass());
        }

        @Override
        public void set(Context context, Object value) {
            Function typeConvert;
            Class fieldClass;
            Class<?> valueClass;
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                Object origin = map.put(this.name, value);
                if (origin != null && (context.readerFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value);
                        map.put(this.name, value);
                    } else {
                        JSONArray array = JSONArray.of(origin, value);
                        map.put(this.name, array);
                    }
                }
                return;
            }
            ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(object.getClass());
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            if (fieldReader == null) {
                return;
            }
            if (value != null && (valueClass = value.getClass()) != (fieldClass = fieldReader.getFieldClass()) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                value = typeConvert.apply(value);
            }
            fieldReader.accept(object, value);
        }

        @Override
        public void setCallback(Context context, BiFunction callback) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                Object origin = map.get(this.name);
                if (origin != null) {
                    Object applyValue = callback.apply(map, origin);
                    map.put(this.name, applyValue);
                }
                return;
            }
            ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(object.getClass());
            ObjectWriter objectWriter = context.path.getWriterContext().getProvider().getObjectWriter(object.getClass());
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldReader == null || fieldWriter == null) {
                return;
            }
            Object fieldValue = fieldWriter.getFieldValue(object);
            Object applyValue = callback.apply(object, fieldValue);
            fieldReader.accept(object, applyValue);
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            block43: {
                block45: {
                    Map<String, Object> val;
                    if (context.parent != null && (context.parent.eval || context.parent.current instanceof FilterSegment || context.parent.current instanceof MultiIndexSegment)) {
                        this.eval(context);
                        return;
                    }
                    if (jsonReader.isJSONB()) {
                        if (jsonReader.nextIfObjectStart()) {
                            int i = 0;
                            while (!jsonReader.nextIfObjectEnd()) {
                                long nameHashCode = jsonReader.readFieldNameHashCode();
                                if (nameHashCode != 0L) {
                                    boolean match;
                                    boolean bl = match = nameHashCode == this.nameHashCode;
                                    if (!match) {
                                        jsonReader.skipValue();
                                    } else {
                                        if ((jsonReader.isArray() || jsonReader.isObject()) && context.next != null) break;
                                        context.value = jsonReader.readAny();
                                        context.eval = true;
                                        break;
                                    }
                                }
                                ++i;
                            }
                            return;
                        }
                        if (jsonReader.isArray() && context.parent != null && context.parent.current instanceof AllSegment) {
                            JSONArray values = new JSONArray();
                            int itemCnt = jsonReader.startArray();
                            block17: for (int i = 0; i < itemCnt; ++i) {
                                if (jsonReader.nextIfMatch((byte)-90)) {
                                    int j = 0;
                                    while (!jsonReader.nextIfMatch((byte)-91)) {
                                        boolean match;
                                        long nameHashCode = jsonReader.readFieldNameHashCode();
                                        boolean bl = match = nameHashCode == this.nameHashCode;
                                        if (!match) {
                                            jsonReader.skipValue();
                                        } else {
                                            if ((jsonReader.isArray() || jsonReader.isObject()) && context.next != null) continue block17;
                                            values.add(jsonReader.readAny());
                                        }
                                        ++j;
                                    }
                                    continue;
                                }
                                jsonReader.skipValue();
                            }
                            context.value = values;
                            context.eval = true;
                            return;
                        }
                        throw new JSONException("TODO");
                    }
                    if (!jsonReader.nextIfObjectStart()) break block45;
                    if (jsonReader.ch == '}') {
                        jsonReader.next();
                    }
                    while (true) {
                        boolean match;
                        if (jsonReader.nextIfObjectEnd()) {
                            jsonReader.next();
                            break block43;
                        }
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        boolean bl = match = nameHashCode == this.nameHashCode;
                        if (match) break;
                        jsonReader.skipValue();
                        if (jsonReader.ch != ',') continue;
                        jsonReader.next();
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            if (context.next == null || context.next instanceof EvalSegment || context.next instanceof NameSegment || context.next instanceof AllSegment) {
                                val = jsonReader.readArray();
                                context.eval = true;
                                break;
                            }
                            break block43;
                        }
                        case '{': {
                            if (context.next == null || context.next instanceof EvalSegment || context.next instanceof AllSegment) {
                                val = jsonReader.readObject();
                                context.eval = true;
                                break;
                            }
                            break block43;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    context.value = val;
                    break block43;
                }
                if (jsonReader.ch == '[' && context.parent != null && context.parent.current instanceof AllSegment) {
                    jsonReader.next();
                    JSONArray values = new JSONArray();
                    while (jsonReader.ch != '\u001a') {
                        block44: {
                            if (jsonReader.ch == ']') {
                                jsonReader.next();
                                break;
                            }
                            if (jsonReader.ch == '{') {
                                jsonReader.next();
                                while (true) {
                                    Map<String, Object> val;
                                    boolean match;
                                    if (jsonReader.ch == '}') {
                                        jsonReader.next();
                                        break block44;
                                    }
                                    long nameHashCode = jsonReader.readFieldNameHashCode();
                                    boolean bl = match = nameHashCode == this.nameHashCode;
                                    if (!match) {
                                        jsonReader.skipValue();
                                        if (jsonReader.ch != ',') continue;
                                        jsonReader.next();
                                        continue;
                                    }
                                    switch (jsonReader.ch) {
                                        case '+': 
                                        case '-': 
                                        case '.': 
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': 
                                        case '4': 
                                        case '5': 
                                        case '6': 
                                        case '7': 
                                        case '8': 
                                        case '9': {
                                            jsonReader.readNumber0();
                                            val = jsonReader.getNumber();
                                            break;
                                        }
                                        case '[': {
                                            if (context.next == null) {
                                                val = jsonReader.readArray();
                                                break;
                                            }
                                            break block44;
                                        }
                                        case '{': {
                                            if (context.next == null) {
                                                val = jsonReader.readObject();
                                                break;
                                            }
                                            break block44;
                                        }
                                        case '\"': 
                                        case '\'': {
                                            val = jsonReader.readString();
                                            break;
                                        }
                                        case 'f': 
                                        case 't': {
                                            val = jsonReader.readBoolValue();
                                            break;
                                        }
                                        case 'n': {
                                            jsonReader.readNull();
                                            val = null;
                                            break;
                                        }
                                        default: {
                                            throw new JSONException("TODO : " + jsonReader.ch);
                                        }
                                    }
                                    values.add(val);
                                }
                            }
                            jsonReader.skipValue();
                        }
                        if (jsonReader.ch != ',') continue;
                        jsonReader.next();
                    }
                    context.value = values;
                }
            }
        }

        public String toString() {
            return this.name;
        }
    }

    static final class RootSegment
    extends Segment {
        static final RootSegment INSTANCE = new RootSegment();

        protected RootSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent != null) {
                throw new JSONException("not support operation");
            }
            context.value = jsonReader.readAny();
            context.eval = true;
        }

        @Override
        public void eval(Context context) {
            Object object;
            context.value = object = context.parent == null ? context.root : context.parent.root;
        }
    }

    static final class SelfSegment
    extends Segment {
        static final SelfSegment INSTANCE = new SelfSegment();

        protected SelfSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            context.value = jsonReader.readAny();
            context.eval = true;
        }

        @Override
        public void eval(Context context) {
            Object object;
            context.value = object = context.parent == null ? context.root : context.parent.value;
        }
    }

    static final class SumSegment
    extends Segment
    implements EvalSegment {
        static final SumSegment INSTANCE = new SumSegment();

        SumSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            this.eval(context);
        }

        static Number add(Number a, Number b) {
            boolean bIsInt;
            boolean aIsInt = a instanceof Byte || a instanceof Short || a instanceof Integer || a instanceof Long;
            boolean bl = bIsInt = b instanceof Byte || b instanceof Short || b instanceof Integer || b instanceof Long;
            if (aIsInt && bIsInt) {
                return a.longValue() + b.longValue();
            }
            throw new JSONException("not support operation");
        }

        @Override
        public void eval(Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Number sum = 0;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else if (value instanceof Sequence) {
                for (Object item : ((Sequence)value).values) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = sum;
            context.eval = true;
        }
    }

    static final class MaxSegment
    extends Segment
    implements EvalSegment {
        static final MaxSegment INSTANCE = new MaxSegment();

        MaxSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            this.eval(context);
        }

        @Override
        public void eval(Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Object max = null;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else if (value instanceof Sequence) {
                for (Object item : ((Sequence)value).values) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = max;
            context.eval = true;
        }
    }

    static final class MinSegment
    extends Segment
    implements EvalSegment {
        static final MinSegment INSTANCE = new MinSegment();

        MinSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            this.eval(context);
        }

        @Override
        public void eval(Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Object min = null;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else if (value instanceof Sequence) {
                for (Object item : ((Sequence)value).values) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = min;
            context.eval = true;
        }
    }

    static final class LengthSegment
    extends Segment
    implements EvalSegment {
        static final LengthSegment INSTANCE = new LengthSegment();

        LengthSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
                context.eval = true;
            }
            this.eval(context);
        }

        @Override
        public void eval(Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            int length = 1;
            if (value instanceof Collection) {
                length = ((Collection)value).size();
            } else if (value.getClass().isArray()) {
                length = Array.getLength(value);
            } else if (value instanceof Map) {
                length = ((Map)value).size();
            } else if (value instanceof String) {
                length = ((String)value).length();
            } else if (value instanceof Sequence) {
                length = ((Sequence)value).values.size();
            }
            context.value = length;
        }
    }

    static final class ValuesSegment
    extends Segment
    implements EvalSegment {
        static final ValuesSegment INSTANCE = new ValuesSegment();

        ValuesSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            this.eval(context);
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                context.value = null;
                context.eval = true;
                return;
            }
            if (object instanceof Map) {
                context.value = new JSONArray((Collection<?>)((Map)object).values());
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class KeysSegment
    extends Segment
    implements EvalSegment {
        static final KeysSegment INSTANCE = new KeysSegment();

        KeysSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (jsonReader.isObject()) {
                jsonReader.next();
                JSONArray array = new JSONArray();
                while (!jsonReader.nextIfObjectEnd()) {
                    String fieldName = jsonReader.readFieldName();
                    array.add(fieldName);
                    jsonReader.skipValue();
                }
                context.value = array;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                context.value = new JSONArray((Collection<?>)((Map)object).keySet());
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static abstract class Segment {
        Segment() {
        }

        public abstract void accept(JSONReader var1, Context var2);

        public abstract void eval(Context var1);

        public boolean contains(Context context) {
            this.eval(context);
            return context.value != null;
        }

        public boolean remove(Context context) {
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        public void set(Context context, Object value) {
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        public void setCallback(Context context, BiFunction callback) {
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        public void setInt(Context context, int value) {
            this.set(context, value);
        }

        public void setLong(Context context, long value) {
            this.set(context, value);
        }
    }

    static final class Context {
        final JSONPath path;
        final Context parent;
        final Segment current;
        final Segment next;
        final long readerFeatures;
        Object root;
        Object value;
        boolean eval;

        Context(JSONPath path, Context parent, Segment current, Segment next, long readerFeatures) {
            this.path = path;
            this.current = current;
            this.next = next;
            this.parent = parent;
            this.readerFeatures = readerFeatures;
        }
    }

    static final class MultiSegmentPath
    extends JSONPath {
        final List<Segment> segments;
        final boolean ref;

        private MultiSegmentPath(String path, List<Segment> segments) {
            super(path);
            this.segments = segments;
            boolean ref = true;
            int l = segments.size();
            for (int i = 0; i < l; ++i) {
                Segment segment = segments.get(i);
                if (segment instanceof IndexSegment || segment instanceof NameSegment) continue;
                ref = false;
                break;
            }
            this.ref = ref;
        }

        @Override
        public boolean remove(Object root) {
            Context context = null;
            int size = this.segments.size();
            if (size == 0) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, 0L);
                if (i == 0) {
                    context.root = root;
                }
                if (i == size - 1) {
                    return segment.remove(context);
                }
                segment.eval(context);
                if (context.value != null) continue;
                return false;
            }
            return false;
        }

        @Override
        public boolean contains(Object root) {
            Context context = null;
            int size = this.segments.size();
            if (size == 0) {
                return root != null;
            }
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, 0L);
                if (i == 0) {
                    context.root = root;
                }
                if (i == size - 1) {
                    return segment.contains(context);
                }
                segment.eval(context);
            }
            return false;
        }

        @Override
        public boolean isRef() {
            return this.ref;
        }

        @Override
        public Object eval(Object root) {
            Context context = null;
            int size = this.segments.size();
            if (size == 0) {
                return root;
            }
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, 0L);
                if (i == 0) {
                    context.root = root;
                }
                segment.eval(context);
            }
            return context.value;
        }

        @Override
        public void set(Object root, Object value) {
            Context context = null;
            int size = this.segments.size();
            for (int i = 0; i < size - 1; ++i) {
                FieldReader fieldReader;
                Cloneable emptyValue;
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, 0L);
                if (i == 0) {
                    context.root = root;
                }
                segment.eval(context);
                if (context.value != null || nextSegment == null) continue;
                if (value == null) {
                    return;
                }
                Object parentObject = i == 0 ? root : context.parent.value;
                if (nextSegment instanceof IndexSegment) {
                    emptyValue = new JSONArray();
                } else if (nextSegment instanceof NameSegment) {
                    emptyValue = new JSONObject();
                } else {
                    return;
                }
                context.value = emptyValue;
                if (parentObject instanceof Map && segment instanceof NameSegment) {
                    ((Map)parentObject).put(((NameSegment)segment).name, emptyValue);
                    continue;
                }
                if (parentObject instanceof List && segment instanceof IndexSegment) {
                    int index = ((IndexSegment)segment).index;
                    List list = (List)parentObject;
                    if (index == list.size()) {
                        list.add(emptyValue);
                        continue;
                    }
                    list.set(index, emptyValue);
                    continue;
                }
                if (parentObject == null) continue;
                Class<?> parentObjectClass = parentObject.getClass();
                JSONReader.Context readerContext = this.getReaderContext();
                ObjectReader objectReader = readerContext.getObjectReader(parentObjectClass);
                if (!(segment instanceof NameSegment) || (fieldReader = objectReader.getFieldReader(((NameSegment)segment).nameHashCode)) == null) continue;
                ObjectReader fieldObjectReader = fieldReader.getObjectReader(readerContext);
                Object fieldValue = fieldObjectReader.createInstance();
                fieldReader.accept(parentObject, fieldValue);
                context.value = fieldValue;
            }
            context = new Context(this, context, this.segments.get(0), null, 0L);
            context.root = root;
            Segment segment = this.segments.get(size - 1);
            segment.set(context, value);
        }

        @Override
        public void set(Object root, Object value, JSONReader.Feature ... readerFeatures) {
            long features = 0L;
            for (JSONReader.Feature feature : readerFeatures) {
                features |= feature.mask;
            }
            Context context = null;
            int size = this.segments.size();
            for (int i = 0; i < size - 1; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, features);
                if (i == 0) {
                    context.root = root;
                }
                segment.eval(context);
            }
            context = new Context(this, context, this.segments.get(0), null, features);
            context.root = root;
            Segment segment = this.segments.get(size - 1);
            segment.set(context, value);
        }

        @Override
        public void setCallback(Object root, BiFunction callback) {
            Context context = null;
            int size = this.segments.size();
            for (int i = 0; i < size - 1; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, 0L);
                if (i == 0) {
                    context.root = root;
                }
                segment.eval(context);
            }
            context = new Context(this, context, this.segments.get(0), null, 0L);
            context.root = root;
            Segment segment = this.segments.get(size - 1);
            segment.setCallback(context, callback);
        }

        @Override
        public void setInt(Object rootObject, int value) {
            this.set(rootObject, value);
        }

        @Override
        public void setLong(Object rootObject, long value) {
            this.set(rootObject, value);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            Object value;
            if (jsonReader == null) {
                return null;
            }
            int size = this.segments.size();
            if (size == 0) {
                return null;
            }
            boolean eval = false;
            Context context = null;
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, 0L);
                if (eval) {
                    segment.eval(context);
                } else {
                    segment.accept(jsonReader, context);
                }
                if (!context.eval) continue;
                eval = true;
                if (context.value == null) break;
            }
            if ((value = context.value) instanceof Sequence) {
                value = ((Sequence)value).values;
            }
            return value;
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            int size = this.segments.size();
            if (size == 0) {
                return null;
            }
            boolean eval = false;
            Context context = null;
            for (int i = 0; i < size; ++i) {
                Segment segment = this.segments.get(i);
                Segment nextSegment = null;
                int nextIndex = i + 1;
                if (nextIndex < size) {
                    nextSegment = this.segments.get(nextIndex);
                }
                context = new Context(this, context, segment, nextSegment, 0L);
                if (eval) {
                    segment.eval(context);
                } else {
                    segment.accept(jsonReader, context);
                }
                if (!context.eval) continue;
                eval = true;
                if (context.value == null) break;
            }
            return JSON.toJSONString(context.value);
        }
    }

    static class TwoSegmentPath
    extends JSONPath {
        final Segment first;
        final Segment second;
        final boolean ref;

        public TwoSegmentPath(String path, Segment first, Segment second) {
            super(path);
            this.first = first;
            this.second = second;
            this.ref = !(!(first instanceof IndexSegment) && !(first instanceof NameSegment) || !(second instanceof IndexSegment) && !(second instanceof NameSegment));
        }

        @Override
        public boolean remove(Object root) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                return false;
            }
            Context context1 = new Context(this, context0, this.second, null, 0L);
            return this.second.remove(context1);
        }

        @Override
        public boolean contains(Object root) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                return false;
            }
            Context context1 = new Context(this, context0, this.second, null, 0L);
            return this.second.contains(context1);
        }

        @Override
        public boolean isRef() {
            return this.ref;
        }

        @Override
        public Object eval(Object root) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                return null;
            }
            Context context1 = new Context(this, context0, this.second, null, 0L);
            this.second.eval(context1);
            return context1.value;
        }

        @Override
        public void set(Object root, Object value) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                Cloneable emptyValue;
                if (this.second instanceof IndexSegment) {
                    emptyValue = new JSONArray();
                } else if (this.second instanceof NameSegment) {
                    emptyValue = new JSONObject();
                } else {
                    return;
                }
                context0.value = emptyValue;
                if (root instanceof Map && this.first instanceof NameSegment) {
                    ((Map)root).put(((NameSegment)this.first).name, emptyValue);
                } else if (root instanceof List && this.first instanceof IndexSegment) {
                    ((List)root).set(((IndexSegment)this.first).index, emptyValue);
                } else if (root != null) {
                    FieldReader fieldReader;
                    Class<?> parentObjectClass = root.getClass();
                    JSONReader.Context readerContext = this.getReaderContext();
                    ObjectReader objectReader = readerContext.getObjectReader(parentObjectClass);
                    if (this.first instanceof NameSegment && (fieldReader = objectReader.getFieldReader(((NameSegment)this.first).nameHashCode)) != null) {
                        ObjectReader fieldObjectReader = fieldReader.getObjectReader(readerContext);
                        Object fieldValue = fieldObjectReader.createInstance();
                        fieldReader.accept(root, fieldValue);
                        context0.value = fieldValue;
                    }
                }
            }
            Context context1 = new Context(this, context0, this.second, null, 0L);
            this.second.set(context1, value);
        }

        @Override
        public void set(Object root, Object value, JSONReader.Feature ... readerFeatures) {
            long features = 0L;
            for (JSONReader.Feature feature : readerFeatures) {
                features |= feature.mask;
            }
            Context context0 = new Context(this, null, this.first, this.second, features);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                return;
            }
            Context context1 = new Context(this, context0, this.second, null, features);
            this.second.set(context1, value);
        }

        @Override
        public void setCallback(Object root, BiFunction callback) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                return;
            }
            Context context1 = new Context(this, context0, this.second, null, 0L);
            this.second.setCallback(context1, callback);
        }

        @Override
        public void setInt(Object root, int value) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                return;
            }
            Context context1 = new Context(this, context0, this.second, null, 0L);
            this.second.setInt(context1, value);
        }

        @Override
        public void setLong(Object root, long value) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            context0.root = root;
            this.first.eval(context0);
            if (context0.value == null) {
                return;
            }
            Context context1 = new Context(this, context0, this.second, null, 0L);
            this.second.setLong(context1, value);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            if (jsonReader == null) {
                return null;
            }
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            this.first.accept(jsonReader, context0);
            Context context1 = new Context(this, context0, this.second, null, 0L);
            if (context0.eval) {
                this.second.eval(context1);
            } else {
                this.second.accept(jsonReader, context1);
            }
            return context1.value;
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            Context context0 = new Context(this, null, this.first, this.second, 0L);
            this.first.accept(jsonReader, context0);
            Context context1 = new Context(this, context0, this.second, null, 0L);
            this.second.accept(jsonReader, context1);
            return JSON.toJSONString(context1.value);
        }
    }

    static final class SingleSegmentPath
    extends JSONPath {
        final Segment segment;
        final boolean ref;

        public SingleSegmentPath(Segment segment, String path) {
            super(path);
            this.segment = segment;
            this.ref = segment instanceof IndexSegment || segment instanceof NameSegment;
        }

        @Override
        public boolean remove(Object root) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            return this.segment.remove(context);
        }

        @Override
        public boolean contains(Object root) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            return this.segment.contains(context);
        }

        @Override
        public boolean isRef() {
            return this.ref;
        }

        @Override
        public Object eval(Object root) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            this.segment.eval(context);
            return context.value;
        }

        @Override
        public void set(Object root, Object value) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            this.segment.set(context, value);
        }

        @Override
        public void set(Object root, Object value, JSONReader.Feature ... readerFeatures) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            this.segment.set(context, value);
        }

        @Override
        public void setCallback(Object root, BiFunction callback) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            this.segment.setCallback(context, callback);
        }

        @Override
        public void setInt(Object root, int value) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            this.segment.setInt(context, value);
        }

        @Override
        public void setLong(Object root, long value) {
            Context context = new Context(this, null, this.segment, null, 0L);
            context.root = root;
            this.segment.setLong(context, value);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            Context context = new Context(this, null, this.segment, null, 0L);
            if (this.segment instanceof EvalSegment) {
                context.root = jsonReader.readAny();
                this.segment.eval(context);
            } else {
                this.segment.accept(jsonReader, context);
            }
            return context.value;
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            Context context = new Context(this, null, this.segment, null, 0L);
            this.segment.accept(jsonReader, context);
            return JSON.toJSONString(context.value);
        }
    }

    static final class SingleNamePath
    extends JSONPath {
        final long nameHashCode;
        final String name;

        public SingleNamePath(String path, NameSegment segment) {
            super(path);
            this.name = segment.name;
            this.nameHashCode = segment.nameHashCode;
        }

        @Override
        public Object eval(Object root) {
            if (root instanceof Map) {
                Map map = (Map)root;
                Object value = map.get(this.name);
                if (value == null) {
                    boolean isNum = IOUtils.isNumber(this.name);
                    Long longValue = null;
                    for (Map.Entry o : map.entrySet()) {
                        Map.Entry entry = o;
                        Object entryKey = entry.getKey();
                        if (entryKey instanceof Enum && ((Enum)entryKey).name().equals(this.name)) {
                            value = entry.getValue();
                            break;
                        }
                        if (!(entryKey instanceof Long)) continue;
                        if (longValue == null && isNum) {
                            longValue = Long.parseLong(this.name);
                        }
                        if (!entryKey.equals(longValue)) continue;
                        value = entry.getValue();
                        break;
                    }
                }
                return value;
            }
            JSONWriter.Context writerContext = this.getWriterContext();
            ObjectWriter<?> objectWriter = writerContext.getObjectWriter(root.getClass());
            if (objectWriter == null) {
                return null;
            }
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldWriter == null) {
                return null;
            }
            return fieldWriter.getFieldValue(root);
        }

        @Override
        public boolean remove(Object root) {
            if (root == null) {
                return false;
            }
            if (root instanceof Map) {
                return ((Map)root).remove(this.name) != null;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(root.getClass());
            if (objectReader == null) {
                return false;
            }
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            if (fieldReader == null) {
                return false;
            }
            try {
                fieldReader.accept(root, null);
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        @Override
        public boolean isRef() {
            return true;
        }

        @Override
        public boolean contains(Object root) {
            if (root instanceof Map) {
                return ((Map)root).containsKey(this.name);
            }
            ObjectWriterProvider provider = this.getWriterContext().getProvider();
            ObjectWriter objectWriter = provider.getObjectWriter(root.getClass());
            if (objectWriter == null) {
                return false;
            }
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldWriter == null) {
                return false;
            }
            return fieldWriter.getFieldValue(root) != null;
        }

        @Override
        public void set(Object rootObject, Object value) {
            Function typeConvert;
            Class fieldClass;
            Class<?> valueClass;
            if (rootObject instanceof Map) {
                Map map = (Map)rootObject;
                map.put(this.name, value);
                return;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(rootObject.getClass());
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            if (value != null && (valueClass = value.getClass()) != (fieldClass = fieldReader.getFieldClass()) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                value = typeConvert.apply(value);
            }
            fieldReader.accept(rootObject, value);
        }

        @Override
        public void set(Object rootObject, Object value, JSONReader.Feature ... readerFeatures) {
            Function typeConvert;
            Class fieldClass;
            Class<?> valueClass;
            if (rootObject instanceof Map) {
                Map map = (Map)rootObject;
                Object origin = map.put(this.name, value);
                if (origin != null) {
                    boolean duplicateKeyValueAsArray = false;
                    for (JSONReader.Feature feature : readerFeatures) {
                        if (feature != JSONReader.Feature.DuplicateKeyValueAsArray) continue;
                        duplicateKeyValueAsArray = true;
                        break;
                    }
                    if (duplicateKeyValueAsArray) {
                        if (origin instanceof Collection) {
                            ((Collection)origin).add(value);
                            map.put(this.name, value);
                        } else {
                            JSONArray array = JSONArray.of(origin, value);
                            map.put(this.name, array);
                        }
                    }
                }
                return;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(rootObject.getClass());
            FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
            if (value != null && (valueClass = value.getClass()) != (fieldClass = fieldReader.getFieldClass()) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                value = typeConvert.apply(value);
            }
            fieldReader.accept(rootObject, value);
        }

        @Override
        public void setCallback(Object object, BiFunction callback) {
            if (object instanceof Map) {
                Map map = (Map)object;
                Object originValue = map.get(this.name);
                if (originValue != null || map.containsKey(this.name)) {
                    map.put(this.name, callback.apply(map, originValue));
                }
                return;
            }
            Class<?> objectClass = object.getClass();
            if (this.readerContext == null) {
                this.readerContext = JSONFactory.createReadContext();
            }
            FieldReader fieldReader = this.readerContext.provider.getObjectReader(objectClass).getFieldReader(this.nameHashCode);
            if (this.writerContext == null) {
                this.writerContext = JSONFactory.createWriteContext();
            }
            FieldWriter fieldWriter = this.writerContext.provider.getObjectWriter(objectClass).getFieldWriter(this.nameHashCode);
            if (fieldReader != null && fieldWriter != null) {
                Object fieldValue = fieldWriter.getFieldValue(object);
                Object value = callback.apply(object, fieldValue);
                fieldReader.accept(object, value);
            }
        }

        @Override
        public void setInt(Object obejct, int value) {
            if (obejct instanceof Map) {
                ((Map)obejct).put(this.name, value);
                return;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(obejct.getClass());
            objectReader.setFieldValue(obejct, this.name, this.nameHashCode, value);
        }

        @Override
        public void setLong(Object object, long value) {
            if (object instanceof Map) {
                ((Map)object).put(this.name, value);
                return;
            }
            ObjectReaderProvider provider = this.getReaderContext().getProvider();
            ObjectReader objectReader = provider.getObjectReader(object.getClass());
            objectReader.setFieldValue(object, this.name, this.nameHashCode, value);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            if (jsonReader.isJSONB()) {
                if (jsonReader.isObject()) {
                    jsonReader.nextIfObjectStart();
                    while (!jsonReader.nextIfObjectEnd()) {
                        boolean match;
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        if (nameHashCode == 0L) continue;
                        boolean bl = match = nameHashCode == this.nameHashCode;
                        if (!(match || jsonReader.isObject() || jsonReader.isArray())) {
                            jsonReader.skipValue();
                            continue;
                        }
                        if (jsonReader.isNumber()) {
                            return jsonReader.readNumber();
                        }
                        throw new JSONException("TODO");
                    }
                }
                return null;
            }
            if (jsonReader.nextIfObjectStart()) {
                while (!jsonReader.nextIfObjectEnd()) {
                    Object val;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean match = nameHashCode == this.nameHashCode;
                    char ch = jsonReader.ch;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            return jsonReader.readNumber();
                        }
                        case '[': {
                            return jsonReader.readArray();
                        }
                        case '{': {
                            return jsonReader.readObject();
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    return val;
                }
            }
            return null;
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            block11: {
                if (jsonReader.nextIfObjectStart()) {
                    Object val;
                    while (true) {
                        if (jsonReader.ch == '}') {
                            jsonReader.next();
                            break block11;
                        }
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        boolean match = nameHashCode == this.nameHashCode;
                        char ch = jsonReader.ch;
                        if (match || ch == '{' || ch == '[') break;
                        jsonReader.skipValue();
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            val = jsonReader.readNumber();
                            break;
                        }
                        case '[': {
                            val = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    return JSON.toJSONString(val);
                }
            }
            return null;
        }

        @Override
        public long extractInt64Value(JSONReader jsonReader) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        jsonReader.wasNull = true;
                        return 0L;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return jsonReader.readInt64Value();
                    }
                    case '[': 
                    case '{': {
                        Map<String, Object> object = jsonReader.readObject();
                        return jsonReader.toLong(object);
                    }
                    case '\"': 
                    case '\'': {
                        String str = jsonReader.readString();
                        return Long.parseLong(str);
                    }
                    case 'f': 
                    case 't': {
                        boolean booleanValue = jsonReader.readBoolValue();
                        return booleanValue ? 1L : 0L;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        jsonReader.wasNull = true;
                        return 0L;
                    }
                    case ']': {
                        jsonReader.next();
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
            }
            jsonReader.wasNull = true;
            return 0L;
        }

        @Override
        public int extractInt32Value(JSONReader jsonReader) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        jsonReader.wasNull = true;
                        return 0;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return jsonReader.readInt32Value();
                    }
                    case '\"': 
                    case '\'': {
                        String str = jsonReader.readString();
                        return Integer.parseInt(str);
                    }
                    case 'f': 
                    case 't': {
                        boolean booleanValue = jsonReader.readBoolValue();
                        return booleanValue ? 1 : 0;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        jsonReader.wasNull = true;
                        return 0;
                    }
                    case ']': {
                        jsonReader.next();
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
            }
            jsonReader.wasNull = true;
            return 0;
        }

        @Override
        public void extractScalar(JSONReader jsonReader, ValueConsumer consumer) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        consumer.acceptNull();
                        return;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber(consumer, false);
                        return;
                    }
                    case '[': {
                        List array = jsonReader.readArray();
                        consumer.accept(array);
                        return;
                    }
                    case '{': {
                        Map<String, Object> object = jsonReader.readObject();
                        consumer.accept(object);
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        jsonReader.readString(consumer, false);
                        return;
                    }
                    case 'f': 
                    case 't': {
                        consumer.accept(jsonReader.readBoolValue());
                        return;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        consumer.acceptNull();
                        return;
                    }
                    case ']': {
                        jsonReader.next();
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
            }
            consumer.acceptNull();
        }

        @Override
        public void extract(JSONReader jsonReader, ValueConsumer consumer) {
            if (jsonReader.nextIfObjectStart()) {
                while (true) {
                    boolean match;
                    if (jsonReader.ch == '}') {
                        consumer.acceptNull();
                        return;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber(consumer, true);
                        return;
                    }
                    case '[': {
                        List array = jsonReader.readArray();
                        consumer.accept(array);
                        return;
                    }
                    case '{': {
                        Map<String, Object> object = jsonReader.readObject();
                        consumer.accept(object);
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        jsonReader.readString(consumer, true);
                        return;
                    }
                    case 'f': 
                    case 't': {
                        consumer.accept(jsonReader.readBoolValue());
                        return;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        consumer.acceptNull();
                        return;
                    }
                }
                throw new JSONException("TODO : " + jsonReader.ch);
            }
            consumer.acceptNull();
        }
    }

    static final class NameExistsFilter
    extends FilterSegment {
        final String name;
        final long nameHashCode;

        public NameExistsFilter(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        @Override
        public void eval(Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray array = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                int l = list.size();
                for (int i = 0; i < l; ++i) {
                    Object item = list.get(i);
                    if (!(item instanceof Map) || !((Map)item).containsKey(this.name)) continue;
                    array.add(item);
                }
                context.value = array;
                return;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                Object value = map.get(this.name);
                context.value = value != null ? object : null;
                return;
            }
            if (object instanceof Sequence) {
                List list = ((Sequence)object).values;
                int l = list.size();
                for (int i = 0; i < l; ++i) {
                    Object item = list.get(i);
                    if (!(item instanceof Map) || !((Map)item).containsKey(this.name)) continue;
                    array.add(item);
                }
                context.value = new Sequence(array);
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            this.eval(context);
        }

        public String toString() {
            return '?' + this.name;
        }

        @Override
        public boolean apply(Context context, Object object) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NameMatchFilter
    extends NameFilter {
        final String startsWithValue;
        final String endsWithValue;
        final String[] containsValues;
        final int minLength;
        final boolean not;

        public NameMatchFilter(String fieldName, long fieldNameNameHash, String startsWithValue, String endsWithValue, String[] containsValues, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.startsWithValue = startsWithValue;
            this.endsWithValue = endsWithValue;
            this.containsValues = containsValues;
            this.not = not;
            int len = 0;
            if (startsWithValue != null) {
                len += startsWithValue.length();
            }
            if (endsWithValue != null) {
                len += endsWithValue.length();
            }
            if (containsValues != null) {
                for (String item : containsValues) {
                    len += item.length();
                }
            }
            this.minLength = len;
        }

        @Override
        boolean apply(Object arg) {
            if (!(arg instanceof String)) {
                return false;
            }
            String fieldValue = (String)arg;
            if (fieldValue.length() < this.minLength) {
                return this.not;
            }
            int start = 0;
            if (this.startsWithValue != null) {
                if (!fieldValue.startsWith(this.startsWithValue)) {
                    return this.not;
                }
                start += this.startsWithValue.length();
            }
            if (this.containsValues != null) {
                for (String containsValue : this.containsValues) {
                    int index = fieldValue.indexOf(containsValue, start);
                    if (index == -1) {
                        return this.not;
                    }
                    start = index + containsValue.length();
                }
            }
            if (this.endsWithValue != null && !fieldValue.endsWith(this.endsWithValue)) {
                return this.not;
            }
            return !this.not;
        }
    }

    static final class NameStringInSegment
    extends NameFilter {
        private final String[] values;
        private final boolean not;

        public NameStringInSegment(String fieldName, long fieldNameNameHash, String[] values, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.values = values;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            for (String value : this.values) {
                if (value == fieldValue) {
                    return !this.not;
                }
                if (value == null || !value.equals(fieldValue)) continue;
                return !this.not;
            }
            return this.not;
        }
    }

    static final class NameObjectOpSegment
    extends NameFilter {
        final Operator operator;
        final JSONObject object;

        public NameObjectOpSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function function, Operator operator, JSONObject object) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, function);
            this.operator = operator;
            this.object = object;
        }

        @Override
        boolean apply(Object fieldValue) {
            switch (this.operator) {
                case EQ: {
                    return this.object.equals(fieldValue);
                }
            }
            throw new JSONException("not support operator : " + (Object)((Object)this.operator));
        }
    }

    static final class NameArrayOpSegment
    extends NameFilter {
        final Operator operator;
        final JSONArray array;

        public NameArrayOpSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function function, Operator operator, JSONArray array) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, function);
            this.operator = operator;
            this.array = array;
        }

        @Override
        boolean apply(Object fieldValue) {
            switch (this.operator) {
                case EQ: {
                    return this.array.equals(fieldValue);
                }
            }
            throw new JSONException("not support operator : " + (Object)((Object)this.operator));
        }
    }

    static final class NameStringOpSegment
    extends NameFilter {
        final Operator operator;
        final String value;

        public NameStringOpSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function expr, Operator operator, String value) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, expr);
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (!(fieldValue instanceof String)) {
                return false;
            }
            int cmp = ((String)fieldValue).compareTo(this.value);
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static abstract class NameFilter
    extends FilterSegment {
        final String fieldName;
        final long fieldNameNameHash;
        final String[] fieldName2;
        final long[] fieldNameNameHash2;
        final Function function;

        public NameFilter(String fieldName, long fieldNameNameHash) {
            this.fieldName = fieldName;
            this.fieldNameNameHash = fieldNameNameHash;
            this.fieldName2 = null;
            this.fieldNameNameHash2 = null;
            this.function = null;
        }

        public NameFilter(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function function) {
            this.fieldName = fieldName;
            this.fieldNameNameHash = fieldNameNameHash;
            this.fieldName2 = fieldName2;
            this.fieldNameNameHash2 = fieldNameNameHash2;
            this.function = function;
        }

        abstract boolean apply(Object var1);

        @Override
        public final void accept(JSONReader jsonReader, Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
            }
            this.eval(context);
        }

        @Override
        public boolean remove(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                for (int i = list.size() - 1; i >= 0; --i) {
                    Object item = list.get(i);
                    if (!this.apply(context, item)) continue;
                    list.remove(i);
                }
                return true;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public final void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                JSONArray array = new JSONArray(list.size());
                int l = list.size();
                for (int i = 0; i < l; ++i) {
                    Object item = list.get(i);
                    if (!this.apply(context, item)) continue;
                    array.add(item);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] list = (Object[])object;
                JSONArray array = new JSONArray(list.length);
                for (Object item : list) {
                    if (!this.apply(context, item)) continue;
                    array.add(item);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            if (object instanceof Sequence) {
                Sequence sequence = (Sequence)object;
                JSONArray array = new JSONArray();
                for (Object value : sequence.values) {
                    if (value instanceof Collection) {
                        for (Object valueItem : (Collection)value) {
                            if (!this.apply(context, valueItem)) continue;
                            array.add(valueItem);
                        }
                        continue;
                    }
                    if (!this.apply(context, value)) continue;
                    array.add(value);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            if (this.apply(context, object)) {
                context.value = object;
                context.eval = true;
            }
        }

        @Override
        public final boolean apply(Context context, Object object) {
            if (object == null) {
                return false;
            }
            JSONWriter.Context writerContext = context.path.getWriterContext();
            if (object instanceof Map) {
                Object fieldValue;
                Object object2 = fieldValue = this.fieldName == null ? object : ((Map)object).get(this.fieldName);
                if (fieldValue == null) {
                    return false;
                }
                if (this.fieldName2 != null) {
                    for (int i = 0; i < this.fieldName2.length; ++i) {
                        String name = this.fieldName2[i];
                        if (fieldValue instanceof Map) {
                            fieldValue = ((Map)fieldValue).get(name);
                        } else {
                            ObjectWriter<?> objectWriter2 = writerContext.getObjectWriter(fieldValue.getClass());
                            if (objectWriter2 instanceof ObjectWriterAdapter) {
                                FieldWriter fieldWriter2 = objectWriter2.getFieldWriter(this.fieldNameNameHash2[i]);
                                if (fieldWriter2 == null) {
                                    return false;
                                }
                                fieldValue = fieldWriter2.getFieldValue(fieldValue);
                            } else {
                                return false;
                            }
                        }
                        if (fieldValue != null) continue;
                        return false;
                    }
                }
                if (this.function != null) {
                    fieldValue = this.function.apply(fieldValue);
                }
                return this.apply(fieldValue);
            }
            ObjectWriter<?> objectWriter = writerContext.getObjectWriter(object.getClass());
            if (objectWriter instanceof ObjectWriterAdapter) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.fieldNameNameHash);
                Object fieldValue = fieldWriter.getFieldValue(object);
                if (fieldValue == null) {
                    return false;
                }
                if (this.fieldName2 != null) {
                    for (int i = 0; i < this.fieldName2.length; ++i) {
                        String name = this.fieldName2[i];
                        if (fieldValue instanceof Map) {
                            fieldValue = ((Map)fieldValue).get(name);
                        } else {
                            ObjectWriter<?> objectWriter2 = writerContext.getObjectWriter(fieldValue.getClass());
                            if (objectWriter2 instanceof ObjectWriterAdapter) {
                                FieldWriter fieldWriter2 = objectWriter2.getFieldWriter(this.fieldNameNameHash2[i]);
                                if (fieldWriter2 == null) {
                                    return false;
                                }
                                fieldValue = fieldWriter2.getFieldValue(fieldValue);
                            } else {
                                return false;
                            }
                        }
                        if (fieldValue != null) continue;
                        return false;
                    }
                }
                if (this.function != null) {
                    fieldValue = this.function.apply(fieldValue);
                }
                return this.apply(fieldValue);
            }
            if (this.function != null) {
                Object fieldValue = this.function.apply(object);
                return this.apply(fieldValue);
            }
            if (this.fieldName == null) {
                return this.apply(object);
            }
            return false;
        }
    }

    static final class SizeFunction
    implements Function {
        static final SizeFunction INSTANCE = new SizeFunction();

        SizeFunction() {
        }

        public Object apply(Object value) {
            if (value == null) {
                return -1;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size();
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value);
            }
            if (value instanceof Map) {
                return ((Map)value).size();
            }
            if (value instanceof Sequence) {
                return ((Sequence)value).values.size();
            }
            return 1;
        }
    }

    static final class TypeFunction
    implements Function {
        static final TypeFunction INSTANCE = new TypeFunction();

        TypeFunction() {
        }

        public Object apply(Object object) {
            return JSONPath.type(object);
        }
    }

    static final class NameIntBetweenSegment
    extends NameFilter {
        private final long begin;
        private final long end;
        private final boolean not;

        public NameIntBetweenSegment(String fieldName, long fieldNameNameHash, long begin, long end, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.begin = begin;
            this.end = end;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                long fieldValueLong = ((Number)fieldValue).longValue();
                if (fieldValueLong >= this.begin && fieldValueLong <= this.end) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof Float || fieldValue instanceof Double) {
                double fieldValueDouble = ((Number)fieldValue).doubleValue();
                if (fieldValueDouble >= (double)this.begin && fieldValueDouble <= (double)this.end) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)fieldValue;
                int cmpBegin = decimal.compareTo(BigDecimal.valueOf(this.begin));
                int cmpEnd = decimal.compareTo(BigDecimal.valueOf(this.end));
                if (cmpBegin >= 0 && cmpEnd <= 0) {
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigInteger) {
                BigInteger bigInt = (BigInteger)fieldValue;
                int cmpBegin = bigInt.compareTo(BigInteger.valueOf(this.begin));
                int cmpEnd = bigInt.compareTo(BigInteger.valueOf(this.end));
                if (cmpBegin >= 0 && cmpEnd <= 0) {
                    return !this.not;
                }
                return this.not;
            }
            return this.not;
        }
    }

    static final class NameIntInSegment
    extends NameFilter {
        private final long[] values;
        private final boolean not;

        public NameIntInSegment(String fieldName, long fieldNameNameHash, String[] fieldName2, long[] fieldNameNameHash2, Function expr, long[] values, boolean not) {
            super(fieldName, fieldNameNameHash, fieldName2, fieldNameNameHash2, expr);
            this.values = values;
            this.not = not;
        }

        @Override
        public boolean apply(Object fieldValue) {
            if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                long fieldValueLong = ((Number)fieldValue).longValue();
                for (long value : this.values) {
                    if (value != fieldValueLong) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof Float || fieldValue instanceof Double) {
                double fieldValueDouble = ((Number)fieldValue).doubleValue();
                for (long value : this.values) {
                    if ((double)value != fieldValueDouble) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)fieldValue;
                long longValue = decimal.longValue();
                for (long value : this.values) {
                    if (value != longValue || !decimal.equals(BigDecimal.valueOf(value))) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (fieldValue instanceof BigInteger) {
                BigInteger bigiInt = (BigInteger)fieldValue;
                long longValue = bigiInt.longValue();
                for (long value : this.values) {
                    if (value != longValue || !bigiInt.equals(BigInteger.valueOf(value))) continue;
                    return !this.not;
                }
                return this.not;
            }
            return this.not;
        }
    }

    static final class GroupFilter
    extends Segment
    implements EvalSegment {
        final boolean and;
        final List<FilterSegment> filters;

        public GroupFilter(List<FilterSegment> filters, boolean and) {
            this.and = and;
            this.filters = filters;
        }

        @Override
        public void accept(JSONReader jsonReader, Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
            }
            this.eval(context);
        }

        @Override
        public void eval(Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                JSONArray array = new JSONArray(list.size());
                int l = list.size();
                for (int i = 0; i < l; ++i) {
                    Object item = list.get(i);
                    boolean match = this.and;
                    for (FilterSegment filter : this.filters) {
                        boolean result = filter.apply(context, item);
                        if (this.and) {
                            if (result) continue;
                            match = false;
                            break;
                        }
                        if (!result) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    array.add(item);
                }
                context.value = array;
                context.eval = true;
                return;
            }
            boolean match = this.and;
            for (FilterSegment filter : this.filters) {
                boolean result = filter.apply(context, object);
                if (this.and) {
                    if (result) continue;
                    match = false;
                    break;
                }
                if (!result) continue;
                match = true;
                break;
            }
            if (match) {
                context.value = object;
            }
            context.eval = true;
        }
    }

    static final class StartsWithSegment
    extends NameFilter {
        final String prefix;

        public StartsWithSegment(String fieldName, long fieldNameNameHash, String prefix) {
            super(fieldName, fieldNameNameHash);
            this.prefix = prefix;
        }

        @Override
        boolean apply(Object fieldValue) {
            String propertyValue = fieldValue.toString();
            return propertyValue != null && propertyValue.startsWith(this.prefix);
        }
    }

    static final class NameRLikeSegment
    extends NameFilter {
        final Pattern pattern;
        final boolean not;

        public NameRLikeSegment(String fieldName, long fieldNameNameHash, Pattern pattern, boolean not) {
            super(fieldName, fieldNameNameHash);
            this.pattern = pattern;
            this.not = not;
        }

        @Override
        boolean apply(Object fieldValue) {
            String strPropertyValue = fieldValue.toString();
            Matcher m = this.pattern.matcher(strPropertyValue);
            boolean match = m.matches();
            if (this.not) {
                match = !match;
            }
            return match;
        }
    }

    static final class NameDecimalOpSegment
    extends NameFilter {
        final Operator operator;
        final BigDecimal value;

        public NameDecimalOpSegment(String name, long nameHashCode, Operator operator, BigDecimal value) {
            super(name, nameHashCode);
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean apply(Object fieldValue) {
            BigDecimal fieldValueDecimal;
            if (fieldValue == null) {
                return false;
            }
            if (fieldValue instanceof Boolean) {
                fieldValueDecimal = (Boolean)fieldValue != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long) {
                fieldValueDecimal = BigDecimal.valueOf(((Number)fieldValue).longValue());
            } else if (fieldValue instanceof BigDecimal) {
                fieldValueDecimal = (BigDecimal)fieldValue;
            } else if (fieldValue instanceof BigInteger) {
                fieldValueDecimal = new BigDecimal((BigInteger)fieldValue);
            } else {
                throw new UnsupportedOperationException();
            }
            int cmp = fieldValueDecimal.compareTo(this.value);
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static final class NameIntOpSegment
    extends NameFilter {
        final Operator operator;
        final long value;

        public NameIntOpSegment(String name, long nameHashCode, String[] fieldName2, long[] fieldNameNameHash2, Function expr, Operator operator, long value) {
            super(name, nameHashCode, fieldName2, fieldNameNameHash2, expr);
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean apply(Object fieldValue) {
            int cmp;
            boolean objInt;
            boolean bl = objInt = fieldValue instanceof Boolean || fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Integer || fieldValue instanceof Long;
            if (objInt) {
                long fieldValueInt = fieldValue instanceof Boolean ? ((Boolean)fieldValue != false ? 1L : 0L) : ((Number)fieldValue).longValue();
                switch (this.operator) {
                    case LT: {
                        return fieldValueInt < this.value;
                    }
                    case LE: {
                        return fieldValueInt <= this.value;
                    }
                    case EQ: {
                        return fieldValueInt == this.value;
                    }
                    case NE: {
                        return fieldValueInt != this.value;
                    }
                    case GT: {
                        return fieldValueInt > this.value;
                    }
                    case GE: {
                        return fieldValueInt >= this.value;
                    }
                }
                throw new UnsupportedOperationException();
            }
            if (fieldValue instanceof BigDecimal) {
                cmp = ((BigDecimal)fieldValue).compareTo(BigDecimal.valueOf(this.value));
            } else if (fieldValue instanceof BigInteger) {
                cmp = ((BigInteger)fieldValue).compareTo(BigInteger.valueOf(this.value));
            } else if (fieldValue instanceof Float) {
                cmp = ((Float)fieldValue).compareTo(Float.valueOf(this.value));
            } else if (fieldValue instanceof Double) {
                cmp = ((Double)fieldValue).compareTo(Double.valueOf(this.value));
            } else if (fieldValue instanceof String) {
                String fieldValueStr = (String)fieldValue;
                if (IOUtils.isNumber(fieldValueStr)) {
                    try {
                        cmp = Long.valueOf(Long.parseLong(fieldValueStr)).compareTo(this.value);
                    }
                    catch (Exception ignored) {
                        cmp = fieldValueStr.compareTo(Long.toString(this.value));
                    }
                } else {
                    cmp = fieldValueStr.compareTo(Long.toString(this.value));
                }
            } else {
                throw new UnsupportedOperationException();
            }
            switch (this.operator) {
                case LT: {
                    return cmp < 0;
                }
                case LE: {
                    return cmp <= 0;
                }
                case EQ: {
                    return cmp == 0;
                }
                case NE: {
                    return cmp != 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GE: {
                    return cmp >= 0;
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Context context, Object value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!this.apply(context, item)) continue;
                    list.set(i, value);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation ");
        }
    }

    static interface EvalSegment {
    }

    static abstract class FilterSegment
    extends Segment
    implements EvalSegment {
        FilterSegment() {
        }

        abstract boolean apply(Context var1, Object var2);
    }
}

