/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.metadata.RevisionResolver;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.AbstractServiceSubscribeHandler;
import com.alibaba.cloud.dubbo.registry.DubboCloudRegistry;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.rpc.RpcContext;
import org.springframework.cloud.client.ServiceInstance;

public class GenearalServiceSubscribeHandler
extends AbstractServiceSubscribeHandler {
    private final Map<String, Set<String>> providers = new HashMap<String, Set<String>>();
    private final Map<String, URL> urlTemplateMap = new HashMap<String, URL>();
    private final JSONUtils jsonUtils;
    private final DubboServiceMetadataRepository repository;
    private final DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;

    public GenearalServiceSubscribeHandler(URL url, NotifyListener listener, DubboCloudRegistry registry, DubboServiceMetadataRepository repository, JSONUtils jsonUtils, DubboMetadataServiceProxy dubboMetadataConfigServiceProxy) {
        super(url, listener, registry);
        this.repository = repository;
        this.jsonUtils = jsonUtils;
        this.dubboMetadataConfigServiceProxy = dubboMetadataConfigServiceProxy;
    }

    public boolean relatedWith(String appName, String revision) {
        Set<String> list = this.providers.get(appName);
        return list != null && list.size() > 0 && list.contains(revision);
    }

    public void removeAppNameWithRevision(String appName, String revision) {
        Set<String> list = this.providers.get(appName);
        if (list != null) {
            list.remove(revision);
            if (list.size() == 0) {
                this.providers.remove(appName);
            }
        }
    }

    public void addAppNameWithRevision(String appName, String revision) {
        Set set = this.providers.computeIfAbsent(appName, k -> new HashSet());
        set.add(revision);
    }

    @Override
    public synchronized void doInit() {
        this.logger.debug("Subscription interface {}, GenearalServiceSubscribeHandler init", (Object)this.url.getServiceKey());
        Map<String, Map<String, List<ServiceInstance>>> map = this.registry.getServiceRevisionInstanceMap();
        for (Map.Entry<String, Map<String, List<ServiceInstance>>> entry : map.entrySet()) {
            String appName = entry.getKey();
            Map<String, List<ServiceInstance>> revisionMap = entry.getValue();
            for (Map.Entry<String, List<ServiceInstance>> revisionEntity : revisionMap.entrySet()) {
                String revision = revisionEntity.getKey();
                List<ServiceInstance> instances = revisionEntity.getValue();
                this.init(appName, revision, instances);
            }
        }
        this.refresh();
    }

    public void init(String appName, String revision, List<ServiceInstance> instanceList) {
        List<URL> urls = this.getTemplateExportedURLs(this.url, revision, instanceList);
        if (urls != null && urls.size() > 0) {
            this.addAppNameWithRevision(appName, revision);
            this.setUrlTemplate(appName, revision, urls);
        }
    }

    public synchronized void refresh() {
        List<URL> urls = this.getProviderURLs();
        this.notifyAllSubscribedURLs(this.url, urls, this.listener);
    }

    private List<URL> getProviderURLs() {
        List<ServiceInstance> instances = this.registry.getServiceInstances(this.providers);
        this.logger.debug("Subscription interfece {}, providers {}, total {}", new Object[]{this.url.getServiceKey(), this.providers, instances.size()});
        if (instances.size() == 0) {
            return Collections.emptyList();
        }
        return this.cloneExportedURLs(instances);
    }

    void setUrlTemplate(String appName, String revision, List<URL> urls) {
        if (urls == null || urls.size() == 0) {
            return;
        }
        String key = this.getAppRevisionKey(appName, revision);
        if (this.urlTemplateMap.containsKey(key)) {
            return;
        }
        this.urlTemplateMap.put(key, urls.get(0));
    }

    private String getAppRevisionKey(String appName, String revision) {
        return appName + "@" + revision;
    }

    List<URL> cloneExportedURLs(List<ServiceInstance> serviceInstances) {
        ArrayList<URL> urlsCloneTo = new ArrayList<URL>();
        serviceInstances.forEach(serviceInstance -> {
            String host = serviceInstance.getHost();
            String appName = serviceInstance.getServiceId();
            String revision = RevisionResolver.getRevision(serviceInstance);
            URL template = this.urlTemplateMap.get(this.getAppRevisionKey(appName, revision));
            Stream.of(template).map(templateURL -> templateURL.removeParameter("timestamp")).map(templateURL -> templateURL.removeParameter("pid")).map(templateURL -> {
                String protocol = templateURL.getProtocol();
                Integer port = this.repository.getDubboProtocolPort((ServiceInstance)serviceInstance, protocol);
                String tag = null;
                List<URL> urls = this.jsonUtils.toURLs((String)serviceInstance.getMetadata().get("dubbo.metadata-service.urls"));
                if (urls != null && urls.size() > 0) {
                    Map parameters = urls.get(0).getParameters();
                    tag = (String)parameters.get("dubbo.tag");
                }
                if (Objects.equals(templateURL.getHost(), host) && Objects.equals(templateURL.getPort(), port)) {
                    return templateURL;
                }
                if (port == null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("The protocol[{}] port of Dubbo  service instance[host : {}] can't be resolved", (Object)protocol, (Object)host);
                    }
                    return null;
                }
                URLBuilder clonedURLBuilder = URLBuilder.from((URL)templateURL).setHost(host).setPort(port.intValue()).addParameter("dubbo.tag", tag);
                return clonedURLBuilder.build();
            }).filter(Objects::nonNull).forEach(urlsCloneTo::add);
        });
        return urlsCloneTo;
    }

    private List<URL> getTemplateExportedURLs(URL subscribedURL, String revision, List<ServiceInstance> serviceInstances) {
        DubboMetadataService dubboMetadataService = this.getProxy(serviceInstances);
        List<URL> templateExportedURLs = Collections.emptyList();
        if (dubboMetadataService != null) {
            templateExportedURLs = this.getExportedURLs(dubboMetadataService, revision, subscribedURL);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The metadata of Dubbo service[key : {}] still can't be found, it could effect the further Dubbo service invocation", (Object)subscribedURL.getServiceKey());
        }
        return templateExportedURLs;
    }

    private DubboMetadataService getProxy(List<ServiceInstance> serviceInstances) {
        return this.dubboMetadataConfigServiceProxy.getProxy(serviceInstances);
    }

    private List<URL> getExportedURLs(DubboMetadataService dubboMetadataService, String revision, URL subscribedURL) {
        String serviceInterface = subscribedURL.getServiceInterface();
        String group = subscribedURL.getParameter("group");
        String version = subscribedURL.getParameter("version");
        RpcContext.getContext().setAttachment("sca_revision", revision);
        String exportedURLsJSON = dubboMetadataService.getExportedURLs(serviceInterface, group, version);
        String subscribedProtocol = subscribedURL.getParameter("protocol");
        return this.jsonUtils.toURLs(exportedURLsJSON).stream().filter(exportedURL -> subscribedProtocol == null || subscribedProtocol.equalsIgnoreCase(exportedURL.getProtocol())).collect(Collectors.toList());
    }
}

