/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.acm;

import com.alibaba.cloud.context.AliCloudServerMode;

/**
 * ACM配置
 *
 * @author xiaolongzuo
 */
public interface AcmConfiguration {

    /**
     * 获取服务端模式
     *
     * @return 服务端模式
     */
    AliCloudServerMode getServerMode();

    /**
     * 获取服务器列表
     *
     * @return 服务器列表
     */
    String getServerList();

    /**
     * 获取服务器端口
     *
     * @return 获取服务器端口
     */
    String getServerPort();

    /**
     * 获取分组
     *
     * @return 分组
     */
    String getGroup();

    /**
     * 获取超时时间
     *
     * @return 超时时间
     */
    int getTimeout();

    /**
     * 获取连接点
     *
     * @return 连接点
     */
    String getEndpoint();

    /**
     * 获取ACM的namespace
     *
     * @return ACM的namespace
     */
    String getNamespace();

    /**
     * 获取RAM角色名称
     *
     * @return RAM角色名称
     */
    String getRamRoleName();

    /**
     * 自动刷新是否开启
     *
     * @return 自动刷新是否开启
     */
    boolean isRefreshEnabled();

}
