/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.actuate.health;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.metadata.NacosServiceMetaData;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.context.ApplicationContext;

public class NacosConfigHealthIndicator
extends AbstractHealthIndicator {
    @Autowired
    private ApplicationContext applicationContext;
    private static final String UP_STATUS = "up";

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up();
        NacosServiceFactory nacosServiceFactory = (NacosServiceFactory)this.applicationContext.getBean("nacosServiceFactory", NacosServiceFactory.class);
        for (ConfigService configService : nacosServiceFactory.getConfigServices()) {
            if (configService instanceof NacosServiceMetaData) {
                NacosServiceMetaData nacosServiceMetaData = (NacosServiceMetaData)configService;
                Properties properties = nacosServiceMetaData.getProperties();
                builder.withDetail(JSON.toJSONString((Object)properties), (Object)configService.getServerStatus());
            }
            if (configService.getServerStatus().toLowerCase().equals(UP_STATUS)) continue;
            builder.down();
        }
    }
}

