/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NamespaceQueryVO;
import com.aizuda.snailjob.server.web.model.request.NamespaceRequestVO;
import com.aizuda.snailjob.server.web.model.response.NamespaceResponseVO;
import com.aizuda.snailjob.server.web.service.NamespaceService;
import com.aizuda.snailjob.server.web.service.convert.NamespaceResponseVOConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NamespaceMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Namespace;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class NamespaceServiceImpl
implements NamespaceService {
    private final NamespaceMapper namespaceMapper;
    private final GroupConfigMapper groupConfigMapper;

    @Override
    public Boolean saveNamespace(NamespaceRequestVO namespaceRequestVO) {
        String uniqueId = namespaceRequestVO.getUniqueId();
        if (StrUtil.isNotBlank((CharSequence)namespaceRequestVO.getUniqueId())) {
            Pattern pattern = Pattern.compile("^[A-Za-z0-9_-]{1,64}$");
            Matcher matcher = pattern.matcher(uniqueId);
            Assert.isTrue((boolean)matcher.matches(), () -> new SnailJobServerException("Only supports 1~64 characters, including numbers, letters, underscores, and hyphens"));
            Assert.isTrue((this.namespaceMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Namespace::getUniqueId, (Object)namespaceRequestVO.getUniqueId())) == 0L ? 1 : 0) != 0, () -> new SnailJobServerException("Namespace already exists {}", new Object[]{namespaceRequestVO.getUniqueId()}));
        }
        Namespace namespace = new Namespace();
        namespace.setName(namespaceRequestVO.getName());
        if (StrUtil.isBlank((CharSequence)uniqueId)) {
            namespace.setUniqueId(IdUtil.simpleUUID());
        } else {
            namespace.setUniqueId(uniqueId);
        }
        return 1 == this.namespaceMapper.insert((Object)namespace);
    }

    @Override
    public Boolean updateNamespace(NamespaceRequestVO namespaceRequestVO) {
        Long id = namespaceRequestVO.getId();
        Assert.notNull((Object)id, () -> new SnailJobServerException("Parameter error"));
        Namespace namespace = new Namespace();
        namespace.setName(namespaceRequestVO.getName());
        namespace.setId(id);
        return 1 == this.namespaceMapper.updateById((Object)namespace);
    }

    @Override
    public PageResult<List<NamespaceResponseVO>> getNamespacePage(NamespaceQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        String keywords = StrUtil.trim((CharSequence)queryVO.getKeyword());
        PageDTO selectPage = (PageDTO)this.namespaceMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Namespace::getDeleted, (Object)StatusEnum.NO.getStatus())).and(StrUtil.isNotBlank((CharSequence)keywords), w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.likeRight(Namespace::getName, (Object)keywords)).or()).likeRight(Namespace::getUniqueId, (Object)keywords))).orderByDesc(Namespace::getId));
        return new PageResult<List<NamespaceResponseVO>>(pageDTO, NamespaceResponseVOConverter.INSTANCE.convertList(selectPage.getRecords()));
    }

    @Override
    public Boolean deleteByUniqueId(String uniqueId) {
        Assert.isFalse((boolean)"764d604ec6fc45f68cd92514c40e9e1a".equals(uniqueId), () -> new SnailJobServerException("Default space cannot be deleted"));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)this.groupConfigMapper.selectList((IPage)new PageDTO(1L, 1L), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)uniqueId)).orderByAsc(GroupConfig::getId))), () -> new SnailJobServerException("There are undeleted group configuration tasks. Please delete the associated group configurations before retrying deletion"));
        Assert.isTrue((1 == this.namespaceMapper.delete((Wrapper)new LambdaQueryWrapper().eq(Namespace::getUniqueId, (Object)uniqueId)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete namespace"));
        return Boolean.TRUE;
    }

    @Override
    public List<NamespaceResponseVO> getAllNamespace() {
        List namespaces = this.namespaceMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Namespace::getName, Namespace::getUniqueId}).eq(Namespace::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Namespace::getId));
        return NamespaceResponseVOConverter.INSTANCE.convertList(namespaces);
    }

    @Generated
    public NamespaceServiceImpl(NamespaceMapper namespaceMapper, GroupConfigMapper groupConfigMapper) {
        this.namespaceMapper = namespaceMapper;
        this.groupConfigMapper = groupConfigMapper;
    }
}

