/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.convert;

import com.aizuda.snailjob.server.web.model.response.DashboardCardResponseVO;
import com.aizuda.snailjob.server.web.model.response.DashboardRetryLineResponseVO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.DashboardCardResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.DashboardRetryLineResponseDO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface JobSummaryResponseVOConverter {
    public static final JobSummaryResponseVOConverter INSTANCE = (JobSummaryResponseVOConverter)Mappers.getMapper(JobSummaryResponseVOConverter.class);

    @Mappings(value={@Mapping(target="successRate", expression="java(JobSummaryResponseVOConverter.toSuccessRate(jobTask.getSuccessNum(), jobTask.getTotalNum()))")})
    public DashboardCardResponseVO.JobTask convert(DashboardCardResponseDO.JobTask var1);

    @Mappings(value={@Mapping(target="successRate", expression="java(JobSummaryResponseVOConverter.toSuccessRate(jobTask.getSuccessNum(), jobTask.getTotalNum()))")})
    public DashboardCardResponseVO.WorkFlowTask convertToWorkFlowTask(DashboardCardResponseDO.JobTask var1);

    public List<DashboardRetryLineResponseVO.Task> convertList(List<DashboardRetryLineResponseDO.Task> var1);

    public static BigDecimal toSuccessRate(Integer successNum, Integer totalNum) {
        if (Objects.isNull(totalNum) || totalNum == 0) {
            return null;
        }
        return new BigDecimal(String.valueOf(successNum)).divide(new BigDecimal(String.valueOf(totalNum)), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
    }
}

