/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.config;

import com.aizuda.snailjob.common.core.exception.SnailJobAuthenticationException;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUser;
import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
public class WebSocketConfigurator
extends ServerEndpointConfig.Configurator {
    public static final String AUTHENTICATION = "Snail-Job-Auth";
    public static final String SID = "sid";
    public static final String SCENE = "scene";
    public static final String USER_INFO = "user-info";

    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        SystemUser systemUser;
        Map parameterMap = request.getParameterMap();
        String queryString = request.getQueryString();
        try {
            String token = (String)((List)parameterMap.get(AUTHENTICATION)).get(0);
            systemUser = (SystemUser)JsonUtil.parseObject((String)((String)JWT.decode((String)token).getAudience().get(0)), SystemUser.class);
        }
        catch (JWTDecodeException j) {
            throw new SnailJobAuthenticationException("Login expired, please login again");
        }
        String sid = (String)((List)parameterMap.get(SID)).get(0);
        String scene = (String)((List)parameterMap.get(SCENE)).get(0);
        Map userProperties = sec.getUserProperties();
        userProperties.put(SID, sid);
        userProperties.put(SCENE, scene);
        userProperties.put(USER_INFO, systemUser);
    }

    public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
        return (T)super.getEndpointInstance(clazz);
    }
}

