/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.interceptor;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.exception.SnailJobAuthenticationException;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NamespaceMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserPermissionMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Namespace;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUser;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUserPermission;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Configuration
public class AuthenticationInterceptor
implements HandlerInterceptor {
    public static final String AUTHENTICATION = "SNAIL-JOB-AUTH";
    public static final String NAMESPACE_ID = "SNAIL-JOB-NAMESPACE-ID";
    private final SystemUserMapper systemUserMapper;
    private final NamespaceMapper namespaceMapper;
    private final SystemUserPermissionMapper systemUserPermissionMapper;

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
        String token = httpServletRequest.getHeader(AUTHENTICATION);
        String namespaceId = httpServletRequest.getHeader(NAMESPACE_ID);
        if (!(object instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)object;
        Method method = handlerMethod.getMethod();
        if (!method.isAnnotationPresent(LoginRequired.class)) {
            return true;
        }
        LoginRequired loginRequired = method.getAnnotation(LoginRequired.class);
        if (loginRequired.required()) {
            SystemUser systemUser;
            if (token == null) {
                throw new SnailJobAuthenticationException("Login expired, please login again");
            }
            if (StrUtil.isBlank((CharSequence)namespaceId)) {
                throw new SnailJobAuthenticationException("Namespace {} does not exist", (Object)namespaceId);
            }
            try {
                systemUser = (SystemUser)JsonUtil.parseObject((String)((String)JWT.decode((String)token).getAudience().get(0)), SystemUser.class);
            }
            catch (JWTDecodeException j) {
                throw new SnailJobAuthenticationException("Login expired, please login again");
            }
            systemUser = (SystemUser)this.systemUserMapper.selectById((Serializable)systemUser.getId());
            if (Objects.isNull(systemUser)) {
                throw new SnailJobAuthenticationException("User does not exist");
            }
            Long count = this.namespaceMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Namespace::getUniqueId, (Object)namespaceId));
            Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobAuthenticationException("Namespace [{}] does not exist", (Object)namespaceId));
            UserSessionVO userSessionVO = new UserSessionVO();
            userSessionVO.setId(systemUser.getId());
            userSessionVO.setUsername(systemUser.getUsername());
            userSessionVO.setRole(systemUser.getRole());
            userSessionVO.setNamespaceId(namespaceId);
            if (userSessionVO.isUser()) {
                List systemUserPermissions = this.systemUserPermissionMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SystemUserPermission::getGroupName}).eq(SystemUserPermission::getSystemUserId, (Object)systemUser.getId())).eq(SystemUserPermission::getNamespaceId, (Object)namespaceId));
                List groupNames = StreamUtils.toList((Collection)systemUserPermissions, SystemUserPermission::getGroupName);
                Assert.notEmpty((Iterable)groupNames, () -> new SnailJobAuthenticationException("User group permissions are empty"));
                userSessionVO.setGroupNames(groupNames);
            }
            httpServletRequest.setAttribute("currentUser", (Object)userSessionVO);
            JWTVerifier jwtVerifier = JWT.require((Algorithm)Algorithm.HMAC256((String)systemUser.getPassword())).build();
            try {
                jwtVerifier.verify(token);
            }
            catch (JWTVerificationException e) {
                throw new SnailJobAuthenticationException("Login expired, please log in again");
            }
            RoleEnum role = loginRequired.role();
            if (role == RoleEnum.USER) {
                return true;
            }
            if (role == RoleEnum.ADMIN && role != RoleEnum.getEnumTypeMap().get(systemUser.getRole())) {
                throw new SnailJobAuthenticationException("Lack of access permission");
            }
            return true;
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }

    @Generated
    public AuthenticationInterceptor(SystemUserMapper systemUserMapper, NamespaceMapper namespaceMapper, SystemUserPermissionMapper systemUserPermissionMapper) {
        this.systemUserMapper = systemUserMapper;
        this.namespaceMapper = namespaceMapper;
        this.systemUserPermissionMapper = systemUserPermissionMapper;
    }
}

