/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogQueryVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskLogMessageResponseVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskLogResponseVO;
import com.aizuda.snailjob.server.web.service.RetryTaskLogService;
import com.aizuda.snailjob.server.web.service.convert.RetryTaskLogResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RetryTaskLogServiceImpl
implements RetryTaskLogService {
    private final RetryTaskLogMapper retryTaskLogMapper;
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;

    @Override
    public PageResult<List<RetryTaskLogResponseVO>> getRetryTaskLogPage(RetryTaskLogQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        LambdaQueryWrapper retryTaskLogLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLog::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetryTaskLog::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetryTaskLog::getSceneName, (Object)queryVO.getSceneName())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getBizNo()), RetryTaskLog::getBizNo, (Object)queryVO.getBizNo())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId()), RetryTaskLog::getUniqueId, (Object)queryVO.getUniqueId())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId()), RetryTaskLog::getIdempotentId, (Object)queryVO.getIdempotentId())).eq(queryVO.getRetryStatus() != null, RetryTaskLog::getRetryStatus, (Object)queryVO.getRetryStatus())).between(ObjUtil.isNotNull((Object)queryVO.getDatetimeRange()), CreateDt::getCreateDt, (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).select(new SFunction[]{RetryTaskLog::getGroupName, RetryTaskLog::getId, RetryTaskLog::getSceneName, RetryTaskLog::getIdempotentId, RetryTaskLog::getBizNo, RetryTaskLog::getRetryStatus, CreateDt::getCreateDt, RetryTaskLog::getUniqueId, RetryTaskLog::getTaskType}).orderByDesc(CreateDt::getCreateDt);
        PageDTO retryTaskLogPageDTO = (PageDTO)this.retryTaskLogMapper.selectPage((IPage)pageDTO, (Wrapper)retryTaskLogLambdaQueryWrapper);
        return new PageResult<List<RetryTaskLogResponseVO>>(retryTaskLogPageDTO, RetryTaskLogResponseVOConverter.INSTANCE.convertList(retryTaskLogPageDTO.getRecords()));
    }

    @Override
    public RetryTaskLogMessageResponseVO getRetryTaskLogMessagePage(RetryTaskLogMessageQueryVO queryVO) {
        RetryTaskLogMessage record;
        if (StrUtil.isBlank((CharSequence)queryVO.getUniqueId()) || StrUtil.isBlank((CharSequence)queryVO.getGroupName())) {
            RetryTaskLogMessageResponseVO jobLogResponseVO = new RetryTaskLogMessageResponseVO();
            jobLogResponseVO.setNextStartId(0L);
            jobLogResponseVO.setFromIndex(0);
            return jobLogResponseVO;
        }
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        PageDTO selectPage = (PageDTO)this.retryTaskLogMessageMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetryTaskLogMessage::getId, RetryTaskLogMessage::getLogNum}).ge(RetryTaskLogMessage::getId, (Object)queryVO.getStartId())).eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getUniqueId, (Object)queryVO.getUniqueId())).eq(RetryTaskLogMessage::getGroupName, (Object)queryVO.getGroupName())).orderByAsc(RetryTaskLogMessage::getId)).orderByAsc(RetryTaskLogMessage::getRealTime)).orderByDesc(CreateDt::getCreateDt));
        List records = selectPage.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return new RetryTaskLogMessageResponseVO().setFinished(Boolean.TRUE).setNextStartId(queryVO.getStartId()).setFromIndex(0);
        }
        Integer fromIndex = Optional.ofNullable(queryVO.getFromIndex()).orElse(0);
        RetryTaskLogMessage firstRecord = (RetryTaskLogMessage)records.get(0);
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{firstRecord.getId()});
        int total = firstRecord.getLogNum() - fromIndex;
        for (int i = 1; i < records.size() && total + (record = (RetryTaskLogMessage)records.get(i)).getLogNum() <= queryVO.getSize(); ++i) {
            total += record.getLogNum().intValue();
            ids.add(record.getId());
        }
        long nextStartId = 0L;
        List<Object> messages = Lists.newArrayList();
        List jobLogMessages = this.retryTaskLogMessageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTaskLogMessage::getId, (Collection)ids)).orderByAsc(RetryTaskLogMessage::getId)).orderByAsc(RetryTaskLogMessage::getRealTime));
        for (RetryTaskLogMessage retryTaskLogMessage : jobLogMessages) {
            List originalList = (List)JsonUtil.parseObject((String)retryTaskLogMessage.getMessage(), List.class);
            int size = originalList.size() - fromIndex;
            List pageList = originalList.stream().skip(fromIndex.intValue()).limit(queryVO.getSize()).collect(Collectors.toList());
            if (messages.size() + size >= queryVO.getSize()) {
                messages.addAll(pageList);
                nextStartId = retryTaskLogMessage.getId();
                fromIndex = Math.min(fromIndex + queryVO.getSize(), originalList.size() - 1) + 1;
                break;
            }
            messages.addAll(pageList);
            nextStartId = retryTaskLogMessage.getId() + 1L;
            fromIndex = 0;
        }
        messages = messages.stream().sorted(Comparator.comparingLong(o -> Long.parseLong((String)o.get("time_stamp")))).collect(Collectors.toList());
        RetryTaskLogMessageResponseVO responseVO = new RetryTaskLogMessageResponseVO();
        responseVO.setMessage(messages);
        responseVO.setNextStartId(nextStartId);
        responseVO.setFromIndex(fromIndex);
        return responseVO;
    }

    @Override
    public RetryTaskLogResponseVO getRetryTaskLogById(Long id) {
        RetryTaskLog retryTaskLog = (RetryTaskLog)this.retryTaskLogMapper.selectById((Serializable)id);
        return RetryTaskLogResponseVOConverter.INSTANCE.convert(retryTaskLog);
    }

    @Override
    @Transactional
    public boolean deleteById(Long id) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        RetryTaskLog retryTaskLog = (RetryTaskLog)this.retryTaskLogMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTaskLog::getRetryStatus, List.of(RetryStatusEnum.FINISH.getStatus(), RetryStatusEnum.MAX_COUNT.getStatus()))).eq(RetryTaskLog::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLog::getId, (Object)id));
        Assert.notNull((Object)retryTaskLog, () -> new SnailJobServerException("\u6570\u636e\u5220\u9664\u5931\u8d25"));
        this.retryTaskLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getGroupName, (Object)retryTaskLog.getGroupName())).eq(RetryTaskLogMessage::getUniqueId, (Object)retryTaskLog.getUniqueId()));
        return 1 == this.retryTaskLogMapper.deleteById((Serializable)id);
    }

    @Override
    @Transactional
    public boolean batchDelete(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List retryTaskLogs = this.retryTaskLogMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTaskLog::getRetryStatus, List.of(RetryStatusEnum.FINISH.getStatus(), RetryStatusEnum.MAX_COUNT.getStatus()))).eq(RetryTaskLog::getNamespaceId, (Object)namespaceId)).in(RetryTaskLog::getId, ids));
        Assert.notEmpty((Iterable)retryTaskLogs, () -> new SnailJobServerException("\u6570\u636e\u4e0d\u5b58\u5728"));
        Assert.isTrue((retryTaskLogs.size() == ids.size() ? 1 : 0) != 0, () -> new SnailJobServerException("\u6570\u636e\u4e0d\u5b58\u5728"));
        for (RetryTaskLog retryTaskLog : retryTaskLogs) {
            this.retryTaskLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getGroupName, (Object)retryTaskLog.getGroupName())).eq(RetryTaskLogMessage::getUniqueId, (Object)retryTaskLog.getUniqueId()));
        }
        return 1 == this.retryTaskLogMapper.deleteByIds(ids);
    }

    public RetryTaskLogServiceImpl(RetryTaskLogMapper retryTaskLogMapper, RetryTaskLogMessageMapper retryTaskLogMessageMapper) {
        this.retryTaskLogMapper = retryTaskLogMapper;
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
    }
}

