/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.convert.JobBatchResponseVOConverter;
import com.aizuda.snailjob.server.common.dto.CallbackConfig;
import com.aizuda.snailjob.server.common.dto.DecisionConfig;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.vo.JobBatchResponseVO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiGetJobBatchDetailRequestHandler
extends PostHttpRequestHandler {
    private final JobMapper jobMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final WorkflowNodeMapper workflowNodeMapper;

    public boolean supports(String path) {
        return "/api/job/getJobBatchDetail".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("query job batch content:[{}]", new Object[]{content});
        SnailJobRequest jobRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = jobRequest.getArgs();
        Long jobBatchId = (Long)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), Long.class);
        Assert.notNull((Object)jobBatchId, () -> new SnailJobServerException("id cannot be null"));
        JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectById((Serializable)jobBatchId);
        if (Objects.isNull(jobTaskBatch)) {
            return new SnailJobRpcResult(null, jobRequest.getReqId());
        }
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
        JobBatchResponseVO jobBatchResponseVO = JobBatchResponseVOConverter.INSTANCE.convert(jobTaskBatch, job);
        if (jobTaskBatch.getSystemTaskType().equals(SyetemTaskTypeEnum.WORKFLOW.getType())) {
            WorkflowNode workflowNode = (WorkflowNode)this.workflowNodeMapper.selectById((Serializable)jobTaskBatch.getWorkflowNodeId());
            jobBatchResponseVO.setNodeName(workflowNode.getNodeName());
            if (SystemConstants.CALLBACK_JOB_ID.equals(jobTaskBatch.getJobId())) {
                jobBatchResponseVO.setCallback((CallbackConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), CallbackConfig.class));
                jobBatchResponseVO.setExecutionAt(jobTaskBatch.getCreateDt());
                return new SnailJobRpcResult((Object)jobBatchResponseVO, jobRequest.getReqId());
            }
            if (SystemConstants.DECISION_JOB_ID.equals(jobTaskBatch.getJobId())) {
                jobBatchResponseVO.setDecision((DecisionConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), DecisionConfig.class));
                jobBatchResponseVO.setExecutionAt(jobTaskBatch.getCreateDt());
                return new SnailJobRpcResult((Object)jobBatchResponseVO, jobRequest.getReqId());
            }
        }
        return new SnailJobRpcResult((Object)jobBatchResponseVO, jobRequest.getReqId());
    }

    @Generated
    public OpenApiGetJobBatchDetailRequestHandler(JobMapper jobMapper, JobTaskBatchMapper jobTaskBatchMapper, WorkflowNodeMapper workflowNodeMapper) {
        this.jobMapper = jobMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.workflowNodeMapper = workflowNodeMapper;
    }
}

