/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.executor.workflow;

import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.ContentTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.CallbackConfig;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.AbstractWorkflowExecutor;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.snailjob.server.model.dto.CallbackParamsDTO;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CallbackWorkflowExecutor
extends AbstractWorkflowExecutor {
    private static final String CALLBACK_TIMEOUT = "10";
    private final RestTemplate restTemplate;

    @Override
    public WorkflowNodeTypeEnum getWorkflowNodeType() {
        return WorkflowNodeTypeEnum.CALLBACK;
    }

    @Override
    protected void beforeExecute(WorkflowExecutorContext context) {
    }

    @Override
    protected void doExecute(WorkflowExecutorContext context) {
        context.setTaskBatchStatus(JobTaskBatchStatusEnum.SUCCESS.getStatus());
        context.setOperationReason(JobOperationReasonEnum.NONE.getReason());
        context.setJobTaskStatus(JobTaskStatusEnum.SUCCESS.getStatus());
        if (JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(context.getParentOperationReason())) {
            context.setTaskBatchStatus(JobTaskBatchStatusEnum.CANCEL.getStatus());
            context.setOperationReason(JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason());
            context.setJobTaskStatus(JobTaskStatusEnum.CANCEL.getStatus());
        } else if (Objects.equals(context.getWorkflowNodeStatus(), StatusEnum.NO.getStatus())) {
            context.setTaskBatchStatus(JobTaskBatchStatusEnum.CANCEL.getStatus());
            context.setOperationReason(JobOperationReasonEnum.WORKFLOW_NODE_CLOSED_SKIP_EXECUTION.getReason());
            context.setJobTaskStatus(JobTaskStatusEnum.CANCEL.getStatus());
        } else {
            this.invokeCallback(context);
        }
    }

    private void invokeCallback(WorkflowExecutorContext context) {
        CallbackConfig decisionConfig = (CallbackConfig)JsonUtil.parseObject((String)context.getNodeInfo(), CallbackConfig.class);
        String message = "";
        String result = null;
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.set("secret", decisionConfig.getSecret());
        requestHeaders.setContentType(ContentTypeEnum.valueOf((Integer)decisionConfig.getContentType()).getMediaType());
        requestHeaders.set("executorTimeout", CALLBACK_TIMEOUT);
        CallbackParamsDTO callbackParamsDTO = new CallbackParamsDTO();
        callbackParamsDTO.setWfContext(context.getWfContext());
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("secret", decisionConfig.getSecret());
            ResponseEntity response = (ResponseEntity)CallbackWorkflowExecutor.buildRetryer(decisionConfig).call(() -> this.restTemplate.exchange(decisionConfig.getWebhook(), HttpMethod.POST, new HttpEntity((Object)callbackParamsDTO, (MultiValueMap)requestHeaders), String.class, uriVariables));
            result = (String)response.getBody();
            SnailJobLog.LOCAL.info("Callback result. WebHook:[{}], Result: [{}]", new Object[]{decisionConfig.getWebhook(), result});
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Callback exception. WebHook:[{}], Parameter: [{}]", new Object[]{decisionConfig.getWebhook(), context.getWfContext(), e});
            context.setTaskBatchStatus(JobTaskBatchStatusEnum.FAIL.getStatus());
            context.setOperationReason(JobOperationReasonEnum.WORKFLOW_CALLBACK_NODE_EXECUTION_ERROR.getReason());
            context.setJobTaskStatus(JobTaskStatusEnum.FAIL.getStatus());
            Throwable throwable = e;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                RetryException re = (RetryException)e;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            }
            message = throwable.getMessage();
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(WorkflowTaskFailAlarmEventDTO.builder().workflowTaskBatchId(context.getWorkflowTaskBatchId()).notifyScene(JobNotifySceneEnum.WORKFLOW_TASK_ERROR.getNotifyScene()).reason(message).build()));
        }
        context.setEvaluationResult(result);
        context.setLogMessage(message);
    }

    private static Retryer<ResponseEntity<String>> buildRetryer(final CallbackConfig decisionConfig) {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(throwable -> true).withWaitStrategy(WaitStrategies.fixedWait((long)150L, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)10)).withRetryListener(new RetryListener(){

            public <V> void onRetry(Attempt<V> attempt) {
                if (attempt.hasException()) {
                    SnailJobLog.LOCAL.error("Callback interface attempt [{}]. Callback configuration information: [{}]", new Object[]{attempt.getAttemptNumber(), JsonUtil.toJsonString((Object)decisionConfig)});
                }
            }
        }).build();
        return retryer;
    }

    @Override
    protected boolean doPreValidate(WorkflowExecutorContext context) {
        return true;
    }

    @Override
    protected void afterExecute(WorkflowExecutorContext context) {
        JobTaskBatch jobTaskBatch = this.generateJobTaskBatch(context);
        JobTask jobTask = this.generateJobTask(context, jobTaskBatch);
        JobLogMetaDTO jobLogMetaDTO = new JobLogMetaDTO();
        jobLogMetaDTO.setNamespaceId(context.getNamespaceId());
        jobLogMetaDTO.setGroupName(context.getGroupName());
        jobLogMetaDTO.setTaskBatchId(jobTaskBatch.getId());
        jobLogMetaDTO.setJobId(SystemConstants.CALLBACK_JOB_ID);
        jobLogMetaDTO.setTaskId(jobTask.getId());
        if (jobTaskBatch.getTaskBatchStatus().intValue() == JobTaskStatusEnum.SUCCESS.getStatus()) {
            SnailJobLog.REMOTE.info("Node [{}] callback success.\nCallback params: {} \nCallback result: [{}] <|>{}<|>", new Object[]{context.getWorkflowNodeId(), context.getWfContext(), context.getEvaluationResult(), jobLogMetaDTO});
        } else if (jobTaskBatch.getTaskBatchStatus().intValue() == JobTaskStatusEnum.CANCEL.getStatus()) {
            if (JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(context.getParentOperationReason())) {
                SnailJobLog.REMOTE.warn("Node [{}] cancels callback. Cancellation reason: Current task does not require processing <|>{}<|>", new Object[]{context.getWorkflowNodeId(), jobLogMetaDTO});
            } else {
                SnailJobLog.REMOTE.warn("Node [{}] cancels callback. Cancellation reason: Task status is closed <|>{}<|>", new Object[]{context.getWorkflowNodeId(), jobLogMetaDTO});
            }
        } else {
            SnailJobLog.REMOTE.error("Node [{}] fail to callback.\nReason: {} <|>{}<|>", new Object[]{context.getWorkflowNodeId(), context.getLogMessage(), jobLogMetaDTO});
        }
    }

    @Generated
    public CallbackWorkflowExecutor(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

