/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.server.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.model.dto.JobLogTaskDTO;
import com.aizuda.snailjob.server.model.dto.RetryLogTaskDTO;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.pekko.actor.ActorRef;
import org.springframework.stereotype.Component;

@Component
public class ReportLogHttpRequestHandler
extends PostHttpRequestHandler {
    @Override
    public boolean supports(String path) {
        return "/batch/server/report/log".equals(path);
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.POST;
    }

    @Override
    public SnailJobRpcResult doHandler(String content, UrlQuery urlQuery, HttpHeaders headers) {
        ActorRef actorRef;
        SnailJobLog.LOCAL.debug("Begin Handler Log Report Data. [{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        Assert.notEmpty((Object[])args, () -> new SnailJobServerException("The log data to be reported cannot be empty. ReqId:[{}]", retryRequest.getReqId()));
        JsonNode jsonNode = JsonUtil.toJson((Object)args[0]);
        ArrayList retryTasks = Lists.newArrayList();
        ArrayList jobTasks = Lists.newArrayList();
        for (JsonNode node : jsonNode) {
            JsonNode value = node.findValue("logType");
            if (Objects.isNull(value) || value.asText().equals(LogTypeEnum.JOB.name())) {
                jobTasks.add((JobLogTaskDTO)JsonUtil.parseObject((String)node.toPrettyString(), JobLogTaskDTO.class));
                continue;
            }
            if (!value.asText().equals(LogTypeEnum.RETRY.name())) continue;
            retryTasks.add((RetryLogTaskDTO)JsonUtil.parseObject((String)node.toPrettyString(), RetryLogTaskDTO.class));
        }
        if (CollUtil.isNotEmpty((Collection)jobTasks)) {
            actorRef = ActorGenerator.jobLogActor();
            actorRef.tell((Object)jobTasks, actorRef);
        }
        if (CollUtil.isNotEmpty((Collection)retryTasks)) {
            actorRef = ActorGenerator.logActor();
            actorRef.tell((Object)retryTasks, actorRef);
        }
        return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), "Batch Log Retry Data Upload Processed Successfully", (Object)Boolean.TRUE, retryRequest.getReqId());
    }
}

