/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.client;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.exception.SnailJobRemotingTimeOutException;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.rpc.RpcContext;
import com.aizuda.snailjob.common.core.rpc.SnailJobFuture;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.cache.CacheToken;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.snailjob.server.common.rpc.client.RequestMethod;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Body;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Header;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Mapping;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Param;
import com.aizuda.snailjob.server.common.rpc.client.netty.NettyChannel;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientInvokeHandler
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcClientInvokeHandler.class);
    private final String groupName;
    private String hostId;
    private String hostIp;
    private Integer hostPort;
    private final boolean failRetry;
    private final int retryTimes;
    private final int retryInterval;
    private final RetryListener retryListener;
    private final boolean failover;
    private final Integer routeKey;
    private final String allocKey;
    private final Integer executorTimeout;
    private final String namespaceId;
    private final boolean async;

    public RpcClientInvokeHandler(String groupName, RegisterNodeInfo registerNodeInfo, boolean failRetry, int retryTimes, int retryInterval, RetryListener retryListener, Integer routeKey, String allocKey, boolean failover, Integer executorTimeout, String namespaceId) {
        this.groupName = groupName;
        this.hostId = registerNodeInfo.getHostId();
        this.hostPort = registerNodeInfo.getHostPort();
        this.hostIp = registerNodeInfo.getHostIp();
        this.failRetry = failRetry;
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
        this.retryListener = retryListener;
        this.failover = failover;
        this.routeKey = routeKey;
        this.allocKey = allocKey;
        this.executorTimeout = executorTimeout;
        this.namespaceId = namespaceId;
        this.async = false;
    }

    public Result invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Mapping annotation = method.getAnnotation(Mapping.class);
        Assert.notNull((Object)annotation, () -> new SnailJobServerException("@Mapping cannot be null"));
        if (this.failover) {
            return this.doFailoverHandler(method, args, annotation);
        }
        return this.requestRemote(method, args, annotation, 1);
    }

    @NotNull
    private Result doFailoverHandler(Method method, Object[] args, Mapping annotation) throws Throwable {
        Set<RegisterNodeInfo> serverNodeSet = CacheRegisterTable.getServerNodeSet(this.groupName, this.namespaceId);
        int size = serverNodeSet.size();
        for (int count = 1; count <= size; ++count) {
            log.debug("Start request client. count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr()});
            Result result = this.requestRemote(method, args, annotation, count);
            if (!Objects.nonNull(result)) continue;
            return result;
        }
        throw new SnailJobServerException("No available nodes.");
    }

    private Result requestRemote(Method method, Object[] args, Mapping mapping, int count) throws Throwable {
        try {
            ParseParasResult parasResult = this.doParseParams(method, args);
            if (RequestMethod.POST.name().equals(mapping.method().name())) {
                Assert.notNull((Object)parasResult.body, () -> new SnailJobServerException("body cannot be null"));
            }
            Retryer<Result> retryer = this.buildResultRetryer();
            DefaultHttpHeaders requestHeaders = parasResult.requestHeaders;
            requestHeaders.set("SJ-TOKEN", (Object)CacheToken.get(this.groupName, this.namespaceId));
            SnailJobRequest snailJobRequest = new SnailJobRequest(new Object[]{parasResult.body});
            Result result = (Result)retryer.call(() -> this.lambda$requestRemote$3(snailJobRequest, mapping, (HttpHeaders)requestHeaders));
            log.debug("Request client success. count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr()});
            return result;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof SnailJobRemotingTimeOutException && this.failover) {
                log.error("request client I/O error, count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr(), ex});
                CacheRegisterTable.remove(this.groupName, this.namespaceId, this.hostId);
                ClientNodeAllocateHandler clientNodeAllocateHandler = (ClientNodeAllocateHandler)SnailSpringContext.getBean(ClientNodeAllocateHandler.class);
                RegisterNodeInfo serverNode = clientNodeAllocateHandler.getServerNode(this.allocKey, this.groupName, this.namespaceId, this.routeKey);
                if (Objects.isNull(serverNode)) {
                    throw ex.getCause();
                }
                this.hostId = serverNode.getHostId();
                this.hostPort = serverNode.getHostPort();
                this.hostIp = serverNode.getHostIp();
            }
            log.error("request client error.count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr(), ex});
            throw ex.getCause();
        }
        catch (Exception ex) {
            RetryException re;
            log.error("request client unknown exception. count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr(), ex});
            Throwable throwable = ex;
            if (ex.getClass().isAssignableFrom(RetryException.class) && (throwable = (re = (RetryException)ex).getLastFailedAttempt().getExceptionCause()).getCause() instanceof SnailJobRemotingTimeOutException) {
                CacheRegisterTable.remove(this.groupName, this.namespaceId, this.hostId);
            }
            throw throwable;
        }
        return null;
    }

    private Retryer<Result> buildResultRetryer() {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(throwable -> this.failRetry).withStopStrategy(StopStrategies.stopAfterAttempt((int)(this.retryTimes <= 0 ? 1 : this.retryTimes))).withWaitStrategy(WaitStrategies.fixedWait((long)Math.max(this.retryInterval, 0), (TimeUnit)TimeUnit.SECONDS)).withRetryListener(this.retryListener).build();
        return retryer;
    }

    private ParseParasResult doParseParams(Method method, Object[] args) {
        Object body = null;
        DefaultHttpHeaders requestHeaders = new DefaultHttpHeaders();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.isAnnotationPresent(Body.class)) {
                body = args[i];
                continue;
            }
            if (parameter.isAnnotationPresent(Header.class)) {
                requestHeaders.add("snail-job", (Object)JsonUtil.toJsonString((Object)args[i]));
                continue;
            }
            if (parameter.isAnnotationPresent(Param.class)) {
                paramMap.put(parameter.getAnnotation(Param.class).name(), args[i]);
                continue;
            }
            throw new SnailJobServerException("parameter error");
        }
        ParseParasResult parseParasResult = new ParseParasResult();
        parseParasResult.setBody(body);
        parseParasResult.setParamMap(paramMap);
        parseParasResult.setRequestHeaders(requestHeaders);
        return parseParasResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Result lambda$requestRemote$3(SnailJobRequest snailJobRequest, Mapping mapping, HttpHeaders requestHeaders) throws Exception {
        StopWatch sw = new StopWatch();
        sw.start("request start " + snailJobRequest.getReqId());
        SnailJobFuture newFuture = SnailJobFuture.newFuture((Long)snailJobRequest.getReqId(), (long)Optional.ofNullable(this.executorTimeout).orElse(20).intValue(), (TimeUnit)TimeUnit.SECONDS);
        RpcContext.setFuture((SnailJobFuture)newFuture);
        try {
            NettyChannel.send(this.hostId, this.hostIp, this.hostPort, HttpMethod.valueOf((String)mapping.method().name()), mapping.path(), snailJobRequest.toString(), requestHeaders);
        }
        finally {
            sw.stop();
        }
        SnailJobLog.LOCAL.debug("Request complete requestId:[{}] took [{}ms]", new Object[]{snailJobRequest.getReqId(), sw.getTotalTimeMillis()});
        if (this.async) {
            return null;
        }
        Assert.notNull((Object)newFuture, () -> new SnailJobServerException("completableFuture is null"));
        return (Result)newFuture.get(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private static class ParseParasResult {
        private Object body = null;
        private DefaultHttpHeaders requestHeaders;
        private Map<String, Object> paramMap;

        @Generated
        public ParseParasResult() {
        }

        @Generated
        public Object getBody() {
            return this.body;
        }

        @Generated
        public DefaultHttpHeaders getRequestHeaders() {
            return this.requestHeaders;
        }

        @Generated
        public Map<String, Object> getParamMap() {
            return this.paramMap;
        }

        @Generated
        public void setBody(Object body) {
            this.body = body;
        }

        @Generated
        public void setRequestHeaders(DefaultHttpHeaders requestHeaders) {
            this.requestHeaders = requestHeaders;
        }

        @Generated
        public void setParamMap(Map<String, Object> paramMap) {
            this.paramMap = paramMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseParasResult)) {
                return false;
            }
            ParseParasResult other = (ParseParasResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$body = this.getBody();
            Object other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            DefaultHttpHeaders this$requestHeaders = this.getRequestHeaders();
            DefaultHttpHeaders other$requestHeaders = other.getRequestHeaders();
            if (this$requestHeaders == null ? other$requestHeaders != null : !this$requestHeaders.equals(other$requestHeaders)) {
                return false;
            }
            Map<String, Object> this$paramMap = this.getParamMap();
            Map<String, Object> other$paramMap = other.getParamMap();
            return !(this$paramMap == null ? other$paramMap != null : !((Object)this$paramMap).equals(other$paramMap));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParseParasResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            DefaultHttpHeaders $requestHeaders = this.getRequestHeaders();
            result = result * 59 + ($requestHeaders == null ? 43 : $requestHeaders.hashCode());
            Map<String, Object> $paramMap = this.getParamMap();
            result = result * 59 + ($paramMap == null ? 43 : ((Object)$paramMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RpcClientInvokeHandler.ParseParasResult(body=" + String.valueOf(this.getBody()) + ", requestHeaders=" + String.valueOf(this.getRequestHeaders()) + ", paramMap=" + String.valueOf(this.getParamMap()) + ")";
        }
    }
}

