/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.register;

import com.aizuda.snailjob.common.core.enums.NodeTypeEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.register.AbstractRegister;
import com.aizuda.snailjob.server.common.register.RegisterContext;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="clientRegister")
public class ClientRegister
extends AbstractRegister
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ClientRegister.class);
    public static final String BEAN_NAME = "clientRegister";
    public static final int DELAY_TIME = 30;
    private Thread THREAD = null;
    protected static final LinkedBlockingDeque<ServerNode> QUEUE = new LinkedBlockingDeque(1000);

    @Override
    public boolean supports(int type) {
        return this.getNodeType().equals(type);
    }

    @Override
    protected void beforeProcessor(RegisterContext context) {
    }

    @Override
    protected LocalDateTime getExpireAt() {
        return LocalDateTime.now().plusSeconds(30L);
    }

    @Override
    protected boolean doRegister(RegisterContext context, ServerNode serverNode) {
        if ("/beat".equals(context.getUri())) {
            return QUEUE.offerFirst(serverNode);
        }
        return QUEUE.offerLast(serverNode);
    }

    @Override
    protected void afterProcessor(ServerNode serverNode) {
    }

    @Override
    protected Integer getNodeType() {
        return NodeTypeEnum.CLIENT.getType();
    }

    @Override
    public void start() {
        this.THREAD = new Thread((Runnable)this, "client-register");
        this.THREAD.start();
    }

    @Override
    public void close() {
        if (Objects.nonNull(this.THREAD)) {
            this.THREAD.interrupt();
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ServerNode serverNode = QUEUE.poll(5L, TimeUnit.SECONDS);
                if (!Objects.nonNull(serverNode)) continue;
                ArrayList<ServerNode> lists = Lists.newArrayList((Object[])new ServerNode[]{serverNode});
                QUEUE.drainTo((Collection<ServerNode>)lists, 100);
                lists = new ArrayList<ServerNode>(lists.stream().collect(Collectors.toMap(ServerNode::getHostId, node -> node, (existing, replacement) -> existing)).values());
                this.refreshExpireAt(lists);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("client refresh expireAt error.", new Object[0]);
            }
            finally {
                try {
                    TimeUnit.MILLISECONDS.sleep(5000L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

