/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.cache;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.RegisterNodeInfoConverter;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.triple.Pair;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheRegisterTable
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(CacheRegisterTable.class);
    private static final Cache<Pair<String, String>, ConcurrentMap<String, RegisterNodeInfo>> CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(60L, TimeUnit.SECONDS).build();

    public static Set<RegisterNodeInfo> getAllPods() {
        ConcurrentMap concurrentMap = CACHE.asMap();
        if (CollUtil.isEmpty((Map)concurrentMap)) {
            return Sets.newHashSet();
        }
        return concurrentMap.values().stream().map(stringServerNodeConcurrentMap -> new TreeSet(stringServerNodeConcurrentMap.values())).reduce((s, y) -> {
            s.addAll(y);
            return s;
        }).orElse(new TreeSet());
    }

    public static ConcurrentMap<String, RegisterNodeInfo> get(String groupName, String namespaceId) {
        return (ConcurrentMap)CACHE.getIfPresent(CacheRegisterTable.getKey(groupName, namespaceId));
    }

    public static RegisterNodeInfo getServerNode(String groupName, String namespaceId, String hostId) {
        ConcurrentMap concurrentMap = (ConcurrentMap)CACHE.getIfPresent(CacheRegisterTable.getKey(groupName, namespaceId));
        if (Objects.isNull(concurrentMap)) {
            ServerNodeMapper serverNodeMapper = (ServerNodeMapper)SpringContext.getBeanByType(ServerNodeMapper.class);
            List serverNodes = serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNamespaceId, (Object)namespaceId)).eq(ServerNode::getGroupName, (Object)groupName)).eq(ServerNode::getHostId, (Object)hostId)).orderByDesc(ServerNode::getExpireAt));
            if (CollUtil.isEmpty((Collection)serverNodes)) {
                return null;
            }
            CacheRegisterTable.addOrUpdate((ServerNode)serverNodes.get(0));
            concurrentMap = (ConcurrentMap)CACHE.getIfPresent(CacheRegisterTable.getKey(groupName, namespaceId));
            if (CollUtil.isEmpty((Map)concurrentMap)) {
                return null;
            }
        }
        return (RegisterNodeInfo)concurrentMap.get(hostId);
    }

    public static Set<RegisterNodeInfo> getServerNodeSet(String groupName, String namespaceId) {
        ConcurrentMap concurrentMap = (ConcurrentMap)CACHE.getIfPresent(CacheRegisterTable.getKey(groupName, namespaceId));
        if (CollUtil.isEmpty((Map)concurrentMap)) {
            ServerNodeMapper serverNodeMapper = (ServerNodeMapper)SpringContext.getBeanByType(ServerNodeMapper.class);
            List serverNodes = serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNamespaceId, (Object)namespaceId)).eq(ServerNode::getGroupName, (Object)groupName));
            for (ServerNode node : serverNodes) {
                CacheRegisterTable.addOrUpdate(node);
            }
            concurrentMap = (ConcurrentMap)CACHE.getIfPresent(CacheRegisterTable.getKey(groupName, namespaceId));
            if (CollUtil.isEmpty((Collection)serverNodes) || CollUtil.isEmpty((Map)concurrentMap)) {
                return Sets.newHashSet();
            }
        }
        return new TreeSet<RegisterNodeInfo>(concurrentMap.values());
    }

    private static Pair<String, String> getKey(String groupName, String namespaceId) {
        return Pair.of(groupName, namespaceId);
    }

    public static Set<String> getPodIdSet(String groupName, String namespaceId) {
        return StreamUtils.toSet(CacheRegisterTable.getServerNodeSet(groupName, namespaceId), RegisterNodeInfo::getHostId);
    }

    public static synchronized void refreshExpireAt(ServerNode serverNode) {
        RegisterNodeInfo registerNodeInfo = CacheRegisterTable.getServerNode(serverNode.getGroupName(), serverNode.getNamespaceId(), serverNode.getHostId());
        if (Objects.isNull(registerNodeInfo)) {
            SnailJobLog.LOCAL.warn("node not exists. groupName:[{}] hostId:[{}]", new Object[]{serverNode.getGroupName(), serverNode.getHostId()});
        } else {
            registerNodeInfo.setExpireAt(serverNode.getExpireAt());
        }
    }

    public static synchronized void addOrUpdate(ServerNode serverNode) {
        RegisterNodeInfo registerNodeInfo;
        ConcurrentHashMap<String, RegisterNodeInfo> concurrentMap = (ConcurrentHashMap<String, RegisterNodeInfo>)CACHE.getIfPresent(CacheRegisterTable.getKey(serverNode.getGroupName(), serverNode.getNamespaceId()));
        if (Objects.isNull(concurrentMap)) {
            SnailJobLog.LOCAL.info("Add cache. groupName:[{}] namespaceId:[{}] hostId:[{}]", new Object[]{serverNode.getGroupName(), serverNode.getNamespaceId(), serverNode.getHostId()});
            concurrentMap = new ConcurrentHashMap<String, RegisterNodeInfo>();
            registerNodeInfo = RegisterNodeInfoConverter.INSTANCE.toRegisterNodeInfo(serverNode);
        } else {
            registerNodeInfo = concurrentMap.getOrDefault(serverNode.getHostId(), RegisterNodeInfoConverter.INSTANCE.toRegisterNodeInfo(serverNode));
            registerNodeInfo.setExpireAt(serverNode.getExpireAt());
            CacheRegisterTable.delExpireNode((ConcurrentMap<String, RegisterNodeInfo>)concurrentMap);
        }
        concurrentMap.put(serverNode.getHostId(), registerNodeInfo);
        CACHE.put(CacheRegisterTable.getKey(serverNode.getGroupName(), serverNode.getNamespaceId()), concurrentMap);
    }

    private static void delExpireNode(ConcurrentMap<String, RegisterNodeInfo> concurrentMap) {
        concurrentMap.values().stream().filter(registerNodeInfo -> registerNodeInfo.getExpireAt().isBefore(LocalDateTime.now().minusSeconds(40L))).forEach(registerNodeInfo -> CacheRegisterTable.remove(registerNodeInfo.getGroupName(), registerNodeInfo.getNamespaceId(), registerNodeInfo.getHostId()));
    }

    public static void remove(String groupName, String namespaceId, String hostId) {
        ConcurrentMap concurrentMap = (ConcurrentMap)CACHE.getIfPresent(CacheRegisterTable.getKey(groupName, namespaceId));
        if (Objects.isNull(concurrentMap)) {
            return;
        }
        SnailJobLog.LOCAL.info("Remove cache. groupName:[{}] hostId:[{}]", new Object[]{groupName, hostId});
        concurrentMap.remove(hostId);
    }

    @Override
    public void start() {
        SnailJobLog.LOCAL.info("CacheRegisterTable start", new Object[0]);
    }

    @Override
    public void close() {
        SnailJobLog.LOCAL.info("CacheRegisterTable stop", new Object[0]);
        CACHE.invalidateAll();
    }
}

