/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.template.datasource.access;

import com.aizuda.snailjob.template.datasource.access.Access;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.access.JobAccess;
import com.aizuda.snailjob.template.datasource.access.LogAccess;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.enums.OperationTypeEnum;
import com.aizuda.snailjob.template.datasource.exception.SnailJobDatasourceException;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.JobLogMessageDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.RetryTaskLogMessageDO;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.JobExecutor;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class AccessTemplate {
    protected Map<String, Access> REGISTER_ACCESS = new HashMap<String, Access>();

    public AccessTemplate(List<Access> accesses) {
        block0: for (Access access : accesses) {
            for (OperationTypeEnum typeEnum : OperationTypeEnum.values()) {
                if (!access.supports(typeEnum.name())) continue;
                this.REGISTER_ACCESS.put(typeEnum.name(), access);
                continue block0;
            }
        }
    }

    public TaskAccess<RetryTask> getRetryTaskAccess() {
        return (TaskAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.RETRY_TASK.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public TaskAccess<Retry> getRetryAccess() {
        return (TaskAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.RETRY.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public TaskAccess<RetryDeadLetter> getRetryDeadLetterAccess() {
        return (TaskAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.RETRY_DEAD_LETTER.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public ConfigAccess<RetrySceneConfig> getSceneConfigAccess() {
        return (ConfigAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.SCENE.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public ConfigAccess<GroupConfig> getGroupConfigAccess() {
        return (ConfigAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.GROUP.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public ConfigAccess<NotifyConfig> getNotifyConfigAccess() {
        return (ConfigAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.NOTIFY.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public LogAccess<RetryTaskLogMessageDO> getRetryTaskLogMessageAccess() {
        return (LogAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.RETRY_LOG.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public LogAccess<JobLogMessageDO> getJobLogMessageAccess() {
        return (LogAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.JOB_LOG.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }

    public JobAccess<JobExecutor> getJobExecutorAccess() {
        return (JobAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.JOB_EXECUTORS.name())).orElseThrow(() -> new SnailJobDatasourceException("not supports operation type"));
    }
}

