/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client.grpc;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.client.grpc.GrpcChannel;
import com.aizuda.snailjob.common.core.enums.RpcTypeEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ConnectivityState;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SnailJobGrpcClient
implements Lifecycle {
    private ManagedChannel channel;
    private final SnailJobProperties snailJobProperties;
    private final Set<ConnectivityState> STATES = Sets.newHashSet((Object[])new ConnectivityState[]{ConnectivityState.CONNECTING});
    private static final ScheduledExecutorService SCHEDULE_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sj-client-check"));

    @Override
    public void start() {
        if (RpcTypeEnum.GRPC != this.snailJobProperties.getRpcType()) {
            return;
        }
        this.channel = this.connection();
        GrpcChannel.setChannel(this.channel);
        SnailJobLog.LOCAL.info("gRPC client started connect to server", new Object[0]);
        SCHEDULE_EXECUTOR.scheduleAtFixedRate(() -> {
            ConnectivityState state = this.channel.getState(true);
            if (state == ConnectivityState.TRANSIENT_FAILURE) {
                SnailJobLog.LOCAL.warn("gRPC channel state=TRANSIENT_FAILURE, try reconnect...", new Object[0]);
                this.reconnect();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private void reconnect() {
        try {
            ManagedChannel newChannel = this.connection();
            GrpcChannel.setChannel(newChannel);
            ManagedChannel oldChannel = this.channel;
            this.channel = newChannel;
            if (oldChannel != null && !oldChannel.isShutdown()) {
                oldChannel.shutdownNow();
            }
            if (this.STATES.contains(newChannel.getState(false))) {
                SnailJobLog.LOCAL.info("reconnect success", new Object[0]);
            }
        }
        catch (Throwable e) {
            SnailJobLog.LOCAL.error("reconnect error", new Object[]{e});
        }
    }

    public ManagedChannel connection() {
        SnailJobProperties.RpcClientProperties clientRpc = this.snailJobProperties.getClientRpc();
        String serverHost = GrpcChannel.getServerHost();
        return ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)serverHost, (int)GrpcChannel.getServerPort()).executor((Executor)this.createGrpcExecutor(serverHost))).decompressorRegistry(DecompressorRegistry.getDefaultInstance())).maxInboundMessageSize(clientRpc.getMaxInboundMessageSize()).keepAliveTime(clientRpc.getKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(clientRpc.getKeepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS).idleTimeout(clientRpc.getIdleTimeout().toMillis(), TimeUnit.MILLISECONDS)).usePlaintext().enableRetry()).maxRetryAttempts(16)).build();
    }

    private ThreadPoolExecutor createGrpcExecutor(String serverIp) {
        SnailJobProperties.RpcClientProperties clientRpc = this.snailJobProperties.getClientRpc();
        SnailJobProperties.ThreadPoolConfig threadPool = clientRpc.getClientTp();
        serverIp = serverIp.replaceAll("%", "-");
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(threadPool.getCorePoolSize(), threadPool.getMaximumPoolSize(), threadPool.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(threadPool.getQueueCapacity()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("snail-job-grpc-client-executor-" + serverIp + "-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    @Override
    public void close() {
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdownNow();
        }
    }

    @Generated
    public SnailJobGrpcClient(SnailJobProperties snailJobProperties) {
        this.snailJobProperties = snailJobProperties;
    }
}

