/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.server;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.event.SnailServerStartFailedEvent;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.rpc.supports.handler.NettyHttpServerHandler;
import com.aizuda.snailjob.client.common.rpc.supports.handler.SnailDispatcherRequestHandler;
import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.log.SnailJobLog;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SnailNettyHttpServer
implements Runnable,
Lifecycle {
    private final SnailJobProperties snailJobProperties;
    private final SnailDispatcherRequestHandler snailDispatcherRequestHandler;
    private Thread thread = null;
    private volatile boolean started = false;

    @Override
    public void run() {
        if (this.started) {
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x500000)}).addLast(new ChannelHandler[]{new NettyHttpServerHandler(SnailNettyHttpServer.this.snailDispatcherRequestHandler, SnailNettyHttpServer.this.snailJobProperties)});
                }
            });
            ChannelFuture future = bootstrap.bind(this.snailJobProperties.getPort().intValue()).sync();
            SnailJobLog.LOCAL.info("------> snail-job client remoting server start success, nettype = {}, port = {}", new Object[]{SnailNettyHttpServer.class.getName(), this.snailJobProperties.getPort()});
            this.started = true;
            future.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            SnailJobLog.LOCAL.info("--------> snail-job client remoting server stop.", new Object[0]);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("--------> snail-job client remoting server error.", new Object[]{e});
            this.started = false;
            SpringContext.getContext().publishEvent((ApplicationEvent)new SnailServerStartFailedEvent());
            throw new SnailJobClientException("snail-job client server start error");
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void start() {
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void close() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    public SnailNettyHttpServer(SnailJobProperties snailJobProperties, SnailDispatcherRequestHandler snailDispatcherRequestHandler) {
        this.snailJobProperties = snailJobProperties;
        this.snailDispatcherRequestHandler = snailDispatcherRequestHandler;
    }

    public SnailJobProperties getSnailJobProperties() {
        return this.snailJobProperties;
    }

    public SnailDispatcherRequestHandler getSnailDispatcherRequestHandler() {
        return this.snailDispatcherRequestHandler;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isStarted() {
        return this.started;
    }
}

