/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.config;

import com.aizuda.snailjob.common.core.alarm.email.MailProperties;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="snail-job")
public class SnailJobProperties {
    private String namespace;
    private String group;
    private String token;
    private String host;
    private Integer port = 1789;
    private LogSlidingWindowConfig logSlidingWindow = new LogSlidingWindowConfig();
    private ServerConfig server = new ServerConfig();
    private DispatcherThreadPool dispatcherThreadPool = new DispatcherThreadPool();
    private Retry retry = new Retry();
    @NestedConfigurationProperty
    private MailProperties mail = new MailProperties();

    public String getNamespace() {
        return this.namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getToken() {
        return this.token;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public LogSlidingWindowConfig getLogSlidingWindow() {
        return this.logSlidingWindow;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public DispatcherThreadPool getDispatcherThreadPool() {
        return this.dispatcherThreadPool;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public MailProperties getMail() {
        return this.mail;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setLogSlidingWindow(LogSlidingWindowConfig logSlidingWindow) {
        this.logSlidingWindow = logSlidingWindow;
    }

    public void setServer(ServerConfig server) {
        this.server = server;
    }

    public void setDispatcherThreadPool(DispatcherThreadPool dispatcherThreadPool) {
        this.dispatcherThreadPool = dispatcherThreadPool;
    }

    public void setRetry(Retry retry) {
        this.retry = retry;
    }

    public void setMail(MailProperties mail) {
        this.mail = mail;
    }

    public static class LogSlidingWindowConfig {
        private int totalThreshold = 50;
        private int windowTotalThreshold = 150;
        private long duration = 5L;
        private ChronoUnit chronoUnit = ChronoUnit.SECONDS;

        public int getTotalThreshold() {
            return this.totalThreshold;
        }

        public int getWindowTotalThreshold() {
            return this.windowTotalThreshold;
        }

        public long getDuration() {
            return this.duration;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public void setTotalThreshold(int totalThreshold) {
            this.totalThreshold = totalThreshold;
        }

        public void setWindowTotalThreshold(int windowTotalThreshold) {
            this.windowTotalThreshold = windowTotalThreshold;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setChronoUnit(ChronoUnit chronoUnit) {
            this.chronoUnit = chronoUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogSlidingWindowConfig)) {
                return false;
            }
            LogSlidingWindowConfig other = (LogSlidingWindowConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalThreshold() != other.getTotalThreshold()) {
                return false;
            }
            if (this.getWindowTotalThreshold() != other.getWindowTotalThreshold()) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            ChronoUnit this$chronoUnit = this.getChronoUnit();
            ChronoUnit other$chronoUnit = other.getChronoUnit();
            return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LogSlidingWindowConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotalThreshold();
            result = result * 59 + this.getWindowTotalThreshold();
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            ChronoUnit $chronoUnit = this.getChronoUnit();
            result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.LogSlidingWindowConfig(totalThreshold=" + this.getTotalThreshold() + ", windowTotalThreshold=" + this.getWindowTotalThreshold() + ", duration=" + this.getDuration() + ", chronoUnit=" + this.getChronoUnit() + ")";
        }
    }

    public static class ServerConfig {
        private String host = "127.0.0.1";
        private int port = 1788;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerConfig)) {
                return false;
            }
            ServerConfig other = (ServerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServerConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.ServerConfig(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }
    }

    public static class DispatcherThreadPool {
        private int corePoolSize = 16;
        private int maximumPoolSize = 16;
        private long keepAliveTime;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private int queueCapacity = 10000;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DispatcherThreadPool)) {
                return false;
            }
            DispatcherThreadPool other = (DispatcherThreadPool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCorePoolSize() != other.getCorePoolSize()) {
                return false;
            }
            if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
                return false;
            }
            if (this.getKeepAliveTime() != other.getKeepAliveTime()) {
                return false;
            }
            if (this.getQueueCapacity() != other.getQueueCapacity()) {
                return false;
            }
            TimeUnit this$timeUnit = this.getTimeUnit();
            TimeUnit other$timeUnit = other.getTimeUnit();
            return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DispatcherThreadPool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCorePoolSize();
            result = result * 59 + this.getMaximumPoolSize();
            long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
            result = result * 59 + this.getQueueCapacity();
            TimeUnit $timeUnit = this.getTimeUnit();
            result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.DispatcherThreadPool(corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ", timeUnit=" + this.getTimeUnit() + ", queueCapacity=" + this.getQueueCapacity() + ")";
        }
    }

    public static class Retry {
        private SlidingWindowConfig reportSlidingWindow = new SlidingWindowConfig();

        public SlidingWindowConfig getReportSlidingWindow() {
            return this.reportSlidingWindow;
        }

        public void setReportSlidingWindow(SlidingWindowConfig reportSlidingWindow) {
            this.reportSlidingWindow = reportSlidingWindow;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Retry)) {
                return false;
            }
            Retry other = (Retry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SlidingWindowConfig this$reportSlidingWindow = this.getReportSlidingWindow();
            SlidingWindowConfig other$reportSlidingWindow = other.getReportSlidingWindow();
            return !(this$reportSlidingWindow == null ? other$reportSlidingWindow != null : !((Object)this$reportSlidingWindow).equals(other$reportSlidingWindow));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Retry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SlidingWindowConfig $reportSlidingWindow = this.getReportSlidingWindow();
            result = result * 59 + ($reportSlidingWindow == null ? 43 : ((Object)$reportSlidingWindow).hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.Retry(reportSlidingWindow=" + this.getReportSlidingWindow() + ")";
        }
    }

    public static class SlidingWindowConfig {
        private int totalThreshold = 50;
        private int windowTotalThreshold = 150;
        private long duration = 10L;
        private ChronoUnit chronoUnit = ChronoUnit.SECONDS;

        public int getTotalThreshold() {
            return this.totalThreshold;
        }

        public int getWindowTotalThreshold() {
            return this.windowTotalThreshold;
        }

        public long getDuration() {
            return this.duration;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public void setTotalThreshold(int totalThreshold) {
            this.totalThreshold = totalThreshold;
        }

        public void setWindowTotalThreshold(int windowTotalThreshold) {
            this.windowTotalThreshold = windowTotalThreshold;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setChronoUnit(ChronoUnit chronoUnit) {
            this.chronoUnit = chronoUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlidingWindowConfig)) {
                return false;
            }
            SlidingWindowConfig other = (SlidingWindowConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalThreshold() != other.getTotalThreshold()) {
                return false;
            }
            if (this.getWindowTotalThreshold() != other.getWindowTotalThreshold()) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            ChronoUnit this$chronoUnit = this.getChronoUnit();
            ChronoUnit other$chronoUnit = other.getChronoUnit();
            return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SlidingWindowConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotalThreshold();
            result = result * 59 + this.getWindowTotalThreshold();
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            ChronoUnit $chronoUnit = this.getChronoUnit();
            result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
            return result;
        }

        public String toString() {
            return "SnailJobProperties.SlidingWindowConfig(totalThreshold=" + this.getTotalThreshold() + ", windowTotalThreshold=" + this.getWindowTotalThreshold() + ", duration=" + this.getDuration() + ", chronoUnit=" + this.getChronoUnit() + ")";
        }
    }
}

