/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.monitor;

import com.aizuda.monitor.CpuInfo;
import com.aizuda.monitor.DiskInfo;
import com.aizuda.monitor.JvmInfo;
import com.aizuda.monitor.MemoryInfo;
import com.aizuda.monitor.NetIoInfo;
import com.aizuda.monitor.SysInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

public class OshiMonitor {
    private SystemInfo systemInfo;

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public HardwareAbstractionLayer getHardwareAbstractionLayer() {
        return this.getSystemInfo().getHardware();
    }

    public OperatingSystem getOperatingSystem() {
        return this.getSystemInfo().getOperatingSystem();
    }

    public CentralProcessor getCentralProcessor() {
        return this.getHardwareAbstractionLayer().getProcessor();
    }

    public ComputerSystem getComputerSystem() {
        return this.getHardwareAbstractionLayer().getComputerSystem();
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public SysInfo getSysInfo() {
        Properties props = this.getSystemProperties();
        SysInfo sysInfo = new SysInfo();
        InetAddress inetAddress = null;
        try {
            inetAddress = this.getInetAddress();
            sysInfo.setName(inetAddress.getHostName());
            sysInfo.setIp(inetAddress.getHostAddress());
        }
        catch (UnknownHostException e) {
            sysInfo.setName("unknown");
            sysInfo.setIp("unknown");
        }
        sysInfo.setOsName(props.getProperty("os.name"));
        sysInfo.setOsArch(props.getProperty("os.arch"));
        sysInfo.setUserDir(props.getProperty("user.dir"));
        return sysInfo;
    }

    public CpuInfo getCpuInfo() {
        CentralProcessor centralProcessor = this.getCentralProcessor();
        long[] prevTicks = centralProcessor.getSystemCpuLoadTicks();
        Util.sleep((long)600L);
        long[] ticks = centralProcessor.getSystemCpuLoadTicks();
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long ioWait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long totalCpu = user + nice + sys + idle + ioWait + irq + softirq + steal;
        CpuInfo cpuInfo = new CpuInfo();
        cpuInfo.setPhysicalProcessorCount(centralProcessor.getPhysicalProcessorCount());
        cpuInfo.setLogicalProcessorCount(centralProcessor.getLogicalProcessorCount());
        cpuInfo.setSystemPercent(this.formatDouble((double)sys * 1.0 / (double)totalCpu));
        cpuInfo.setUserPercent(this.formatDouble((double)user * 1.0 / (double)totalCpu));
        cpuInfo.setWaitPercent(this.formatDouble((double)ioWait * 1.0 / (double)totalCpu));
        cpuInfo.setUsePercent(this.formatDouble(1.0 - (double)idle * 1.0 / (double)totalCpu));
        return cpuInfo;
    }

    public MemoryInfo getMemoryInfo() {
        GlobalMemory globalMemory = this.getHardwareAbstractionLayer().getMemory();
        long totalByte = globalMemory.getTotal();
        long availableByte = globalMemory.getAvailable();
        MemoryInfo memoryInfo = new MemoryInfo();
        memoryInfo.setTotal(this.formatByte(totalByte));
        memoryInfo.setUsed(this.formatByte(totalByte - availableByte));
        memoryInfo.setFree(this.formatByte(availableByte));
        memoryInfo.setUsePercent(this.formatDouble((double)(totalByte - availableByte) * 1.0 / (double)totalByte));
        return memoryInfo;
    }

    public JvmInfo getJvmInfo() {
        Properties props = this.getSystemProperties();
        Runtime runtime = Runtime.getRuntime();
        long jvmTotalMemoryByte = runtime.totalMemory();
        long freeMemoryByte = runtime.freeMemory();
        JvmInfo jvmInfo = new JvmInfo();
        jvmInfo.setJdkVersion(props.getProperty("java.version"));
        jvmInfo.setJdkHome(props.getProperty("java.home"));
        jvmInfo.setJvmTotalMemory(this.formatByte(jvmTotalMemoryByte));
        jvmInfo.setMaxMemory(this.formatByte(runtime.maxMemory()));
        jvmInfo.setUsedMemory(this.formatByte(jvmTotalMemoryByte - freeMemoryByte));
        jvmInfo.setFreeMemory(this.formatByte(freeMemoryByte));
        jvmInfo.setUsePercent(this.formatDouble((double)(jvmTotalMemoryByte - freeMemoryByte) * 1.0 / (double)jvmTotalMemoryByte));
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        jvmInfo.setJdkName(runtimeMXBean.getVmName());
        jvmInfo.setStartTime(runtimeMXBean.getStartTime());
        jvmInfo.setUptime(runtimeMXBean.getUptime());
        return jvmInfo;
    }

    public List<DiskInfo> getDiskInfos() {
        OperatingSystem operatingSystem = this.getOperatingSystem();
        FileSystem fileSystem = operatingSystem.getFileSystem();
        ArrayList<DiskInfo> diskInfos = new ArrayList<DiskInfo>();
        List fsArray = fileSystem.getFileStores();
        for (OSFileStore fs : fsArray) {
            DiskInfo diskInfo = new DiskInfo();
            diskInfo.setName(fs.getName());
            diskInfo.setVolume(fs.getVolume());
            diskInfo.setLabel(fs.getLabel());
            diskInfo.setLogicalVolume(fs.getLogicalVolume());
            diskInfo.setMount(fs.getMount());
            diskInfo.setDescription(fs.getDescription());
            diskInfo.setOptions(fs.getOptions());
            diskInfo.setType(fs.getType());
            diskInfo.setUUID(fs.getUUID());
            long usable = fs.getUsableSpace();
            diskInfo.setUsableSpace(usable);
            long total = fs.getTotalSpace();
            diskInfo.setSize(this.formatByte(total));
            diskInfo.setTotalSpace(total);
            diskInfo.setAvail(this.formatByte(usable));
            diskInfo.setUsed(this.formatByte(total - usable));
            double usedSize = total - usable;
            double usePercent = 0.0;
            if (total > 0L) {
                usePercent = this.formatDouble(usedSize / (double)total * 100.0);
            }
            diskInfo.setUsePercent(usePercent);
            diskInfos.add(diskInfo);
        }
        return diskInfos;
    }

    public NetIoInfo getNetIoInfo() {
        long rxBytesBegin = 0L;
        long txBytesBegin = 0L;
        long rxPacketsBegin = 0L;
        long txPacketsBegin = 0L;
        long rxBytesEnd = 0L;
        long txBytesEnd = 0L;
        long rxPacketsEnd = 0L;
        long txPacketsEnd = 0L;
        HardwareAbstractionLayer hal = this.getHardwareAbstractionLayer();
        List listBegin = hal.getNetworkIFs();
        for (Object net : listBegin) {
            rxBytesBegin += net.getBytesRecv();
            txBytesBegin += net.getBytesSent();
            rxPacketsBegin += net.getPacketsRecv();
            txPacketsBegin += net.getPacketsSent();
        }
        Util.sleep((long)3000L);
        List listEnd = hal.getNetworkIFs();
        for (NetworkIF net : listEnd) {
            rxBytesEnd += net.getBytesRecv();
            txBytesEnd += net.getBytesSent();
            rxPacketsEnd += net.getPacketsRecv();
            txPacketsEnd += net.getPacketsSent();
        }
        long rxBytesAvg = (rxBytesEnd - rxBytesBegin) / 3L / 1024L;
        long txBytesAvg = (txBytesEnd - txBytesBegin) / 3L / 1024L;
        long rxPacketsAvg = (rxPacketsEnd - rxPacketsBegin) / 3L / 1024L;
        long txPacketsAvg = (txPacketsEnd - txPacketsBegin) / 3L / 1024L;
        NetIoInfo netIoInfo = new NetIoInfo();
        netIoInfo.setRxbyt(rxBytesAvg + "");
        netIoInfo.setTxbyt(txBytesAvg + "");
        netIoInfo.setRxpck(rxPacketsAvg + "");
        netIoInfo.setTxpck(txPacketsAvg + "");
        return netIoInfo;
    }

    public String formatByte(long byteNumber) {
        double FORMAT = 1024.0;
        double kbNumber = (double)byteNumber / FORMAT;
        if (kbNumber < FORMAT) {
            return this.decimalFormat("#.##KB", kbNumber);
        }
        double mbNumber = kbNumber / FORMAT;
        if (mbNumber < FORMAT) {
            return this.decimalFormat("#.##MB", mbNumber);
        }
        double gbNumber = mbNumber / FORMAT;
        if (gbNumber < FORMAT) {
            return this.decimalFormat("#.##GB", gbNumber);
        }
        return this.decimalFormat("#.##TB", gbNumber / FORMAT);
    }

    public String decimalFormat(String pattern, double number) {
        return new DecimalFormat(pattern).format(number);
    }

    public double formatDouble(double str) {
        return new BigDecimal(str).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public OshiMonitor(SystemInfo systemInfo) {
        this.systemInfo = systemInfo;
    }
}

